/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.internal.util;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public final class GuiImages {
    public static final ImageDescriptor IMAGE_OVERLAY = GuiPlugin.getImageDescriptor("icons/action16/overlay.gif");
    public static final ImageDescriptor IMAGE_REFRESH = GuiPlugin.getImageDescriptor("icons/action16/refresh.gif");
    public static final ImageDescriptor IMAGE_CLEAR = GuiPlugin.getImageDescriptor("icons/action16/clear.gif");
    public static final ImageDescriptor IMAGE_EXPAND_ALL = GuiPlugin.getImageDescriptor("icons/action16/expandall.gif");
    public static final ImageDescriptor IMAGE_COLLAPSE_ALL = GuiPlugin.getImageDescriptor("icons/action16/collapseall.gif");
    public static final ImageDescriptor IMAGE_SPEAK = GuiPlugin.getImageDescriptor("icons/action16/speak.gif");
    public static final ImageDescriptor IMAGE_STOP = GuiPlugin.getImageDescriptor("icons/action16/stop.gif");
    public static final ImageDescriptor IMAGE_CHECKER = GuiPlugin.getImageDescriptor("icons/action16/checker.gif");
    public static final String ACC_ROLE = "icons/acc16/role_{0}.gif";
    public static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    public static Map<String, Image> imageMap = new HashMap<String, Image>();

    public static Image getImage(String path) {
        ImageDescriptor descriptor;
        if (path == null) {
            return null;
        }
        Image image = imageMap.get(path);
        if (image == null && (descriptor = GuiImages.getImageDescriptor(path)) != null) {
            image = descriptor.createImage(true);
            imageMap.put(path, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = GuiPlugin.getImageDescriptor(path);
        if (descriptor == null) {
            descriptor = sharedImages.getImageDescriptor(path);
        }
        return descriptor;
    }

    public static String roleIcon(String roleString) {
        return GuiImages.getFilename(ACC_ROLE, roleString);
    }

    public static String roleIcon(int roleNumber) {
        return GuiImages.getFilename(ACC_ROLE, "0x" + Integer.toHexString(roleNumber));
    }

    public static String getFilename(String format, String name) {
        String path = MessageFormat.format((String)format, (Object[])new Object[]{name.toLowerCase()});
        if (GuiPlugin.getImageDescriptor(path) != null) {
            return path;
        }
        DebugPrintUtil.devOrDebugPrintln((Object)("Missing MSAA icon " + path));
        return null;
    }
}

