/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl;

import java.util.HashMap;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    private IDispatch attributes;
    private HashMap<AttrKey, Node> attrMap;
    private NodeImpl baseNode;

    public NamedNodeMapImpl(NodeImpl baseNode, IDispatch attributes) {
        this.baseNode = baseNode;
        this.attributes = attributes;
    }

    private void initCache() {
        if (this.attrMap != null) {
            return;
        }
        this.attrMap = new HashMap();
        int len = this.getLength();
        int i = 0;
        while (i < len) {
            Node n = this.item(i);
            AttrKey key = new AttrKey(n.getNamespaceURI(), n.getLocalName());
            this.attrMap.put(key, n);
            ++i;
        }
    }

    public Node item(int index) {
        try {
            IDispatch i = (IDispatch)this.attributes.invoke1("item", (Object)index);
            return this.baseNode.newNode(i);
        }
        catch (DispatchException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLength() {
        Integer i = (Integer)Helper.get(this.attributes, "length");
        if (i == null) {
            return 0;
        }
        return i;
    }

    public Node getNamedItem(String name) {
        try {
            IDispatch i = (IDispatch)this.attributes.invoke1("removeNamedItem", (Object)name);
            return this.baseNode.newNode(i);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (!(node instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl ni = (NodeImpl)node;
        try {
            IDispatch i = (IDispatch)this.attributes.invoke1("setNamedItem", (Object)ni.getINode());
            return this.baseNode.newNode(i);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public Node removeNamedItem(String name) throws DOMException {
        try {
            IDispatch i = (IDispatch)this.attributes.invoke1("removeNamedItem", (Object)name);
            return this.baseNode.newNode(i);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        this.initCache();
        Node n = this.attrMap.get(new AttrKey(namespaceURI, localName));
        return n;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        this.initCache();
        Node n = this.attrMap.get(new AttrKey(node.getNamespaceURI(), node.getLocalName()));
        return this.setNamedItem(n);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        this.initCache();
        Node n = this.attrMap.get(new AttrKey(namespaceURI, localName));
        return this.removeNamedItem(n.getNodeName());
    }

    private static class AttrKey {
        String ns;
        String name;

        public boolean equals(Object o) {
            if (!(o instanceof AttrKey)) {
                return false;
            }
            AttrKey ak = (AttrKey)o;
            return this.ns.equals(ak.ns) && this.name.equals(ak.name);
        }

        public int hashCode() {
            return this.ns.hashCode() ^ this.name.hashCode();
        }

        AttrKey(String ns, String name) {
            this.ns = ns;
            this.name = name;
        }
    }
}

