/**
 * /**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Fahrstrasse.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Fahrstrasse.util.FahrstrasseAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FahrstrasseItemProviderAdapterFactory extends FahrstrasseAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FahrstrasseItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Aufloesung_Ssp_Zielgleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Aufloesung_Ssp_Zielgleis_TypeClassItemProvider aufloesung_Ssp_Zielgleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Aufloesung_Ssp_Zielgleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAufloesung_Ssp_Zielgleis_TypeClassAdapter() {
		if (aufloesung_Ssp_Zielgleis_TypeClassItemProvider == null) {
			aufloesung_Ssp_Zielgleis_TypeClassItemProvider = new Aufloesung_Ssp_Zielgleis_TypeClassItemProvider(this);
		}

		return aufloesung_Ssp_Zielgleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Aufloesung_Verzoegerung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Aufloesung_Verzoegerung_TypeClassItemProvider aufloesung_Verzoegerung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Aufloesung_Verzoegerung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAufloesung_Verzoegerung_TypeClassAdapter() {
		if (aufloesung_Verzoegerung_TypeClassItemProvider == null) {
			aufloesung_Verzoegerung_TypeClassItemProvider = new Aufloesung_Verzoegerung_TypeClassItemProvider(this);
		}

		return aufloesung_Verzoegerung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Automatische_Einstellung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Automatische_Einstellung_TypeClassItemProvider automatische_Einstellung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Automatische_Einstellung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAutomatische_Einstellung_TypeClassAdapter() {
		if (automatische_Einstellung_TypeClassItemProvider == null) {
			automatische_Einstellung_TypeClassItemProvider = new Automatische_Einstellung_TypeClassItemProvider(this);
		}

		return automatische_Einstellung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Bezeichnung_Fstr_DWeg_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Fstr_DWeg_TypeClassItemProvider bezeichnung_Fstr_DWeg_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Bezeichnung_Fstr_DWeg_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Fstr_DWeg_TypeClassAdapter() {
		if (bezeichnung_Fstr_DWeg_TypeClassItemProvider == null) {
			bezeichnung_Fstr_DWeg_TypeClassItemProvider = new Bezeichnung_Fstr_DWeg_TypeClassItemProvider(this);
		}

		return bezeichnung_Fstr_DWeg_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Bezeichnung_Markanter_Punkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Markanter_Punkt_TypeClassItemProvider bezeichnung_Markanter_Punkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Bezeichnung_Markanter_Punkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Markanter_Punkt_TypeClassAdapter() {
		if (bezeichnung_Markanter_Punkt_TypeClassItemProvider == null) {
			bezeichnung_Markanter_Punkt_TypeClassItemProvider = new Bezeichnung_Markanter_Punkt_TypeClassItemProvider(this);
		}

		return bezeichnung_Markanter_Punkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_Reihenfolge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_Reihenfolge_TypeClassItemProvider dWeg_Reihenfolge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_Reihenfolge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_Reihenfolge_TypeClassAdapter() {
		if (dWeg_Reihenfolge_TypeClassItemProvider == null) {
			dWeg_Reihenfolge_TypeClassItemProvider = new DWeg_Reihenfolge_TypeClassItemProvider(this);
		}

		return dWeg_Reihenfolge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_V_Aufwertung_Verzicht_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_V_Aufwertung_Verzicht_TypeClassItemProvider dWeg_V_Aufwertung_Verzicht_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_V_Aufwertung_Verzicht_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_V_Aufwertung_Verzicht_TypeClassAdapter() {
		if (dWeg_V_Aufwertung_Verzicht_TypeClassItemProvider == null) {
			dWeg_V_Aufwertung_Verzicht_TypeClassItemProvider = new DWeg_V_Aufwertung_Verzicht_TypeClassItemProvider(this);
		}

		return dWeg_V_Aufwertung_Verzicht_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_V_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_V_TypeClassItemProvider dWeg_V_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_V_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_V_TypeClassAdapter() {
		if (dWeg_V_TypeClassItemProvider == null) {
			dWeg_V_TypeClassItemProvider = new DWeg_V_TypeClassItemProvider(this);
		}

		return dWeg_V_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_Vorzug_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DWeg_Vorzug_TypeClassItemProvider dWeg_Vorzug_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_Vorzug_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDWeg_Vorzug_TypeClassAdapter() {
		if (dWeg_Vorzug_TypeClassItemProvider == null) {
			dWeg_Vorzug_TypeClassItemProvider = new DWeg_Vorzug_TypeClassItemProvider(this);
		}

		return dWeg_Vorzug_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Element_Verschluss_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Element_Verschluss_TypeClassItemProvider element_Verschluss_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Element_Verschluss_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElement_Verschluss_TypeClassAdapter() {
		if (element_Verschluss_TypeClassItemProvider == null) {
			element_Verschluss_TypeClassItemProvider = new Element_Verschluss_TypeClassItemProvider(this);
		}

		return element_Verschluss_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.F_Bedienung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected F_Bedienung_TypeClassItemProvider f_Bedienung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.F_Bedienung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createF_Bedienung_TypeClassAdapter() {
		if (f_Bedienung_TypeClassItemProvider == null) {
			f_Bedienung_TypeClassItemProvider = new F_Bedienung_TypeClassItemProvider(this);
		}

		return f_Bedienung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Abhaengigkeit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_AbhaengigkeitItemProvider fstr_AbhaengigkeitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Abhaengigkeit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_AbhaengigkeitAdapter() {
		if (fstr_AbhaengigkeitItemProvider == null) {
			fstr_AbhaengigkeitItemProvider = new Fstr_AbhaengigkeitItemProvider(this);
		}

		return fstr_AbhaengigkeitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Abhaengigkeit_Ssp_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Abhaengigkeit_Ssp_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Abhaengigkeit_Ssp_AttributeGroupAdapter() {
		if (fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider == null) {
			fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider = new Fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider(this);
		}

		return fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Aneinander} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_AneinanderItemProvider fstr_AneinanderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Aneinander}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_AneinanderAdapter() {
		if (fstr_AneinanderItemProvider == null) {
			fstr_AneinanderItemProvider = new Fstr_AneinanderItemProvider(this);
		}

		return fstr_AneinanderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Aneinander_Bedienstring_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Aneinander_Bedienstring_TypeClassItemProvider fstr_Aneinander_Bedienstring_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Aneinander_Bedienstring_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Aneinander_Bedienstring_TypeClassAdapter() {
		if (fstr_Aneinander_Bedienstring_TypeClassItemProvider == null) {
			fstr_Aneinander_Bedienstring_TypeClassItemProvider = new Fstr_Aneinander_Bedienstring_TypeClassItemProvider(this);
		}

		return fstr_Aneinander_Bedienstring_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Aneinander_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Aneinander_ZuordnungItemProvider fstr_Aneinander_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Aneinander_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Aneinander_ZuordnungAdapter() {
		if (fstr_Aneinander_ZuordnungItemProvider == null) {
			fstr_Aneinander_ZuordnungItemProvider = new Fstr_Aneinander_ZuordnungItemProvider(this);
		}

		return fstr_Aneinander_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Bedienstring_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Bedienstring_TypeClassItemProvider fstr_Bedienstring_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Bedienstring_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Bedienstring_TypeClassAdapter() {
		if (fstr_Bedienstring_TypeClassItemProvider == null) {
			fstr_Bedienstring_TypeClassItemProvider = new Fstr_Bedienstring_TypeClassItemProvider(this);
		}

		return fstr_Bedienstring_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_DWegItemProvider fstr_DWegItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_DWegAdapter() {
		if (fstr_DWegItemProvider == null) {
			fstr_DWegItemProvider = new Fstr_DWegItemProvider(this);
		}

		return fstr_DWegItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_DWeg_Allg_AttributeGroupItemProvider fstr_DWeg_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_DWeg_Allg_AttributeGroupAdapter() {
		if (fstr_DWeg_Allg_AttributeGroupItemProvider == null) {
			fstr_DWeg_Allg_AttributeGroupItemProvider = new Fstr_DWeg_Allg_AttributeGroupItemProvider(this);
		}

		return fstr_DWeg_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_DWeg_Bezeichnung_AttributeGroupItemProvider fstr_DWeg_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_DWeg_Bezeichnung_AttributeGroupAdapter() {
		if (fstr_DWeg_Bezeichnung_AttributeGroupItemProvider == null) {
			fstr_DWeg_Bezeichnung_AttributeGroupItemProvider = new Fstr_DWeg_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return fstr_DWeg_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Spezifisch_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_DWeg_Spezifisch_AttributeGroupItemProvider fstr_DWeg_Spezifisch_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Spezifisch_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_DWeg_Spezifisch_AttributeGroupAdapter() {
		if (fstr_DWeg_Spezifisch_AttributeGroupItemProvider == null) {
			fstr_DWeg_Spezifisch_AttributeGroupItemProvider = new Fstr_DWeg_Spezifisch_AttributeGroupItemProvider(this);
		}

		return fstr_DWeg_Spezifisch_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_W_Kr} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_DWeg_W_KrItemProvider fstr_DWeg_W_KrItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_W_Kr}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_DWeg_W_KrAdapter() {
		if (fstr_DWeg_W_KrItemProvider == null) {
			fstr_DWeg_W_KrItemProvider = new Fstr_DWeg_W_KrItemProvider(this);
		}

		return fstr_DWeg_W_KrItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_FahrwegItemProvider fstr_FahrwegItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_FahrwegAdapter() {
		if (fstr_FahrwegItemProvider == null) {
			fstr_FahrwegItemProvider = new Fstr_FahrwegItemProvider(this);
		}

		return fstr_FahrwegItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Mittel_Art_TypeClassItemProvider fstr_Mittel_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Mittel_Art_TypeClassAdapter() {
		if (fstr_Mittel_Art_TypeClassItemProvider == null) {
			fstr_Mittel_Art_TypeClassItemProvider = new Fstr_Mittel_Art_TypeClassItemProvider(this);
		}

		return fstr_Mittel_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Mittel_AttributeGroupItemProvider fstr_Mittel_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Mittel_AttributeGroupAdapter() {
		if (fstr_Mittel_AttributeGroupItemProvider == null) {
			fstr_Mittel_AttributeGroupItemProvider = new Fstr_Mittel_AttributeGroupItemProvider(this);
		}

		return fstr_Mittel_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_V_Aufwertung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Mittel_V_Aufwertung_TypeClassItemProvider fstr_Mittel_V_Aufwertung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_V_Aufwertung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Mittel_V_Aufwertung_TypeClassAdapter() {
		if (fstr_Mittel_V_Aufwertung_TypeClassItemProvider == null) {
			fstr_Mittel_V_Aufwertung_TypeClassItemProvider = new Fstr_Mittel_V_Aufwertung_TypeClassItemProvider(this);
		}

		return fstr_Mittel_V_Aufwertung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Nichthaltfall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_NichthaltfallItemProvider fstr_NichthaltfallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Nichthaltfall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_NichthaltfallAdapter() {
		if (fstr_NichthaltfallItemProvider == null) {
			fstr_NichthaltfallItemProvider = new Fstr_NichthaltfallItemProvider(this);
		}

		return fstr_NichthaltfallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Rangier_Art_TypeClassItemProvider fstr_Rangier_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Rangier_Art_TypeClassAdapter() {
		if (fstr_Rangier_Art_TypeClassItemProvider == null) {
			fstr_Rangier_Art_TypeClassItemProvider = new Fstr_Rangier_Art_TypeClassItemProvider(this);
		}

		return fstr_Rangier_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Rangier_AttributeGroupItemProvider fstr_Rangier_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Rangier_AttributeGroupAdapter() {
		if (fstr_Rangier_AttributeGroupItemProvider == null) {
			fstr_Rangier_AttributeGroupItemProvider = new Fstr_Rangier_AttributeGroupItemProvider(this);
		}

		return fstr_Rangier_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_Fla_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Rangier_Fla_ZuordnungItemProvider fstr_Rangier_Fla_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_Fla_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Rangier_Fla_ZuordnungAdapter() {
		if (fstr_Rangier_Fla_ZuordnungItemProvider == null) {
			fstr_Rangier_Fla_ZuordnungItemProvider = new Fstr_Rangier_Fla_ZuordnungItemProvider(this);
		}

		return fstr_Rangier_Fla_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Reihenfolge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Reihenfolge_TypeClassItemProvider fstr_Reihenfolge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Reihenfolge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Reihenfolge_TypeClassAdapter() {
		if (fstr_Reihenfolge_TypeClassItemProvider == null) {
			fstr_Reihenfolge_TypeClassItemProvider = new Fstr_Reihenfolge_TypeClassItemProvider(this);
		}

		return fstr_Reihenfolge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Signalisierung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_SignalisierungItemProvider fstr_SignalisierungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Signalisierung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_SignalisierungAdapter() {
		if (fstr_SignalisierungItemProvider == null) {
			fstr_SignalisierungItemProvider = new Fstr_SignalisierungItemProvider(this);
		}

		return fstr_SignalisierungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Umfahrpunkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_UmfahrpunktItemProvider fstr_UmfahrpunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Umfahrpunkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_UmfahrpunktAdapter() {
		if (fstr_UmfahrpunktItemProvider == null) {
			fstr_UmfahrpunktItemProvider = new Fstr_UmfahrpunktItemProvider(this);
		}

		return fstr_UmfahrpunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_V_Hg_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_V_Hg_TypeClassItemProvider fstr_V_Hg_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_V_Hg_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_V_Hg_TypeClassAdapter() {
		if (fstr_V_Hg_TypeClassItemProvider == null) {
			fstr_V_Hg_TypeClassItemProvider = new Fstr_V_Hg_TypeClassItemProvider(this);
		}

		return fstr_V_Hg_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_V_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_V_TypeClassItemProvider fstr_V_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_V_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_V_TypeClassAdapter() {
		if (fstr_V_TypeClassItemProvider == null) {
			fstr_V_TypeClassItemProvider = new Fstr_V_TypeClassItemProvider(this);
		}

		return fstr_V_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Vsigabstand_Verkuerzt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Vsigabstand_Verkuerzt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Vsigabstand_Verkuerzt_TypeClassAdapter() {
		if (fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider == null) {
			fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider = new Fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider(this);
		}

		return fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Zug_Art_TypeClassItemProvider fstr_Zug_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Zug_Art_TypeClassAdapter() {
		if (fstr_Zug_Art_TypeClassItemProvider == null) {
			fstr_Zug_Art_TypeClassItemProvider = new Fstr_Zug_Art_TypeClassItemProvider(this);
		}

		return fstr_Zug_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Zug_AttributeGroupItemProvider fstr_Zug_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Zug_AttributeGroupAdapter() {
		if (fstr_Zug_AttributeGroupItemProvider == null) {
			fstr_Zug_AttributeGroupItemProvider = new Fstr_Zug_AttributeGroupItemProvider(this);
		}

		return fstr_Zug_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_DWeg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Zug_DWeg_AttributeGroupItemProvider fstr_Zug_DWeg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_DWeg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Zug_DWeg_AttributeGroupAdapter() {
		if (fstr_Zug_DWeg_AttributeGroupItemProvider == null) {
			fstr_Zug_DWeg_AttributeGroupItemProvider = new Fstr_Zug_DWeg_AttributeGroupItemProvider(this);
		}

		return fstr_Zug_DWeg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Zug_RangierItemProvider fstr_Zug_RangierItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Zug_RangierAdapter() {
		if (fstr_Zug_RangierItemProvider == null) {
			fstr_Zug_RangierItemProvider = new Fstr_Zug_RangierItemProvider(this);
		}

		return fstr_Zug_RangierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fstr_Zug_Rangier_Allg_AttributeGroupItemProvider fstr_Zug_Rangier_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFstr_Zug_Rangier_Allg_AttributeGroupAdapter() {
		if (fstr_Zug_Rangier_Allg_AttributeGroupItemProvider == null) {
			fstr_Zug_Rangier_Allg_AttributeGroupItemProvider = new Fstr_Zug_Rangier_Allg_AttributeGroupItemProvider(this);
		}

		return fstr_Zug_Rangier_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Laenge_Soll_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Laenge_Soll_TypeClassItemProvider laenge_Soll_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Laenge_Soll_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLaenge_Soll_TypeClassAdapter() {
		if (laenge_Soll_TypeClassItemProvider == null) {
			laenge_Soll_TypeClassItemProvider = new Laenge_Soll_TypeClassItemProvider(this);
		}

		return laenge_Soll_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Markanter_Punkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Markanter_PunktItemProvider markanter_PunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Markanter_Punkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMarkanter_PunktAdapter() {
		if (markanter_PunktItemProvider == null) {
			markanter_PunktItemProvider = new Markanter_PunktItemProvider(this);
		}

		return markanter_PunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Markanter_Punkt_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Markanter_Punkt_Bezeichnung_AttributeGroupItemProvider markanter_Punkt_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Markanter_Punkt_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMarkanter_Punkt_Bezeichnung_AttributeGroupAdapter() {
		if (markanter_Punkt_Bezeichnung_AttributeGroupItemProvider == null) {
			markanter_Punkt_Bezeichnung_AttributeGroupItemProvider = new Markanter_Punkt_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return markanter_Punkt_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Massgebende_Neigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Massgebende_Neigung_TypeClassItemProvider massgebende_Neigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Massgebende_Neigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassgebende_Neigung_TypeClassAdapter() {
		if (massgebende_Neigung_TypeClassItemProvider == null) {
			massgebende_Neigung_TypeClassItemProvider = new Massgebende_Neigung_TypeClassItemProvider(this);
		}

		return massgebende_Neigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Rangier_Gegenfahrtausschluss_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rangier_Gegenfahrtausschluss_TypeClassItemProvider rangier_Gegenfahrtausschluss_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Rangier_Gegenfahrtausschluss_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRangier_Gegenfahrtausschluss_TypeClassAdapter() {
		if (rangier_Gegenfahrtausschluss_TypeClassItemProvider == null) {
			rangier_Gegenfahrtausschluss_TypeClassItemProvider = new Rangier_Gegenfahrtausschluss_TypeClassItemProvider(this);
		}

		return rangier_Gegenfahrtausschluss_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Sonstiger_Punkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sonstiger_PunktItemProvider sonstiger_PunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Sonstiger_Punkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSonstiger_PunktAdapter() {
		if (sonstiger_PunktItemProvider == null) {
			sonstiger_PunktItemProvider = new Sonstiger_PunktItemProvider(this);
		}

		return sonstiger_PunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Start_Signal_Charakter_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Start_Signal_Charakter_TypeClassItemProvider start_Signal_Charakter_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Fahrstrasse.Start_Signal_Charakter_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStart_Signal_Charakter_TypeClassAdapter() {
		if (start_Signal_Charakter_TypeClassItemProvider == null) {
			start_Signal_Charakter_TypeClassItemProvider = new Start_Signal_Charakter_TypeClassItemProvider(this);
		}

		return start_Signal_Charakter_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (aufloesung_Ssp_Zielgleis_TypeClassItemProvider != null) aufloesung_Ssp_Zielgleis_TypeClassItemProvider.dispose();
		if (aufloesung_Verzoegerung_TypeClassItemProvider != null) aufloesung_Verzoegerung_TypeClassItemProvider.dispose();
		if (automatische_Einstellung_TypeClassItemProvider != null) automatische_Einstellung_TypeClassItemProvider.dispose();
		if (bezeichnung_Fstr_DWeg_TypeClassItemProvider != null) bezeichnung_Fstr_DWeg_TypeClassItemProvider.dispose();
		if (bezeichnung_Markanter_Punkt_TypeClassItemProvider != null) bezeichnung_Markanter_Punkt_TypeClassItemProvider.dispose();
		if (dWeg_Reihenfolge_TypeClassItemProvider != null) dWeg_Reihenfolge_TypeClassItemProvider.dispose();
		if (dWeg_V_Aufwertung_Verzicht_TypeClassItemProvider != null) dWeg_V_Aufwertung_Verzicht_TypeClassItemProvider.dispose();
		if (dWeg_V_TypeClassItemProvider != null) dWeg_V_TypeClassItemProvider.dispose();
		if (dWeg_Vorzug_TypeClassItemProvider != null) dWeg_Vorzug_TypeClassItemProvider.dispose();
		if (element_Verschluss_TypeClassItemProvider != null) element_Verschluss_TypeClassItemProvider.dispose();
		if (f_Bedienung_TypeClassItemProvider != null) f_Bedienung_TypeClassItemProvider.dispose();
		if (fstr_AbhaengigkeitItemProvider != null) fstr_AbhaengigkeitItemProvider.dispose();
		if (fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider != null) fstr_Abhaengigkeit_Ssp_AttributeGroupItemProvider.dispose();
		if (fstr_AneinanderItemProvider != null) fstr_AneinanderItemProvider.dispose();
		if (fstr_Aneinander_Bedienstring_TypeClassItemProvider != null) fstr_Aneinander_Bedienstring_TypeClassItemProvider.dispose();
		if (fstr_Aneinander_ZuordnungItemProvider != null) fstr_Aneinander_ZuordnungItemProvider.dispose();
		if (fstr_Bedienstring_TypeClassItemProvider != null) fstr_Bedienstring_TypeClassItemProvider.dispose();
		if (fstr_DWegItemProvider != null) fstr_DWegItemProvider.dispose();
		if (fstr_DWeg_Allg_AttributeGroupItemProvider != null) fstr_DWeg_Allg_AttributeGroupItemProvider.dispose();
		if (fstr_DWeg_Bezeichnung_AttributeGroupItemProvider != null) fstr_DWeg_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (fstr_DWeg_Spezifisch_AttributeGroupItemProvider != null) fstr_DWeg_Spezifisch_AttributeGroupItemProvider.dispose();
		if (fstr_DWeg_W_KrItemProvider != null) fstr_DWeg_W_KrItemProvider.dispose();
		if (fstr_FahrwegItemProvider != null) fstr_FahrwegItemProvider.dispose();
		if (fstr_Mittel_Art_TypeClassItemProvider != null) fstr_Mittel_Art_TypeClassItemProvider.dispose();
		if (fstr_Mittel_AttributeGroupItemProvider != null) fstr_Mittel_AttributeGroupItemProvider.dispose();
		if (fstr_Mittel_V_Aufwertung_TypeClassItemProvider != null) fstr_Mittel_V_Aufwertung_TypeClassItemProvider.dispose();
		if (fstr_NichthaltfallItemProvider != null) fstr_NichthaltfallItemProvider.dispose();
		if (fstr_Rangier_Art_TypeClassItemProvider != null) fstr_Rangier_Art_TypeClassItemProvider.dispose();
		if (fstr_Rangier_AttributeGroupItemProvider != null) fstr_Rangier_AttributeGroupItemProvider.dispose();
		if (fstr_Rangier_Fla_ZuordnungItemProvider != null) fstr_Rangier_Fla_ZuordnungItemProvider.dispose();
		if (fstr_Reihenfolge_TypeClassItemProvider != null) fstr_Reihenfolge_TypeClassItemProvider.dispose();
		if (fstr_SignalisierungItemProvider != null) fstr_SignalisierungItemProvider.dispose();
		if (fstr_UmfahrpunktItemProvider != null) fstr_UmfahrpunktItemProvider.dispose();
		if (fstr_V_Hg_TypeClassItemProvider != null) fstr_V_Hg_TypeClassItemProvider.dispose();
		if (fstr_V_TypeClassItemProvider != null) fstr_V_TypeClassItemProvider.dispose();
		if (fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider != null) fstr_Vsigabstand_Verkuerzt_TypeClassItemProvider.dispose();
		if (fstr_Zug_Art_TypeClassItemProvider != null) fstr_Zug_Art_TypeClassItemProvider.dispose();
		if (fstr_Zug_AttributeGroupItemProvider != null) fstr_Zug_AttributeGroupItemProvider.dispose();
		if (fstr_Zug_DWeg_AttributeGroupItemProvider != null) fstr_Zug_DWeg_AttributeGroupItemProvider.dispose();
		if (fstr_Zug_RangierItemProvider != null) fstr_Zug_RangierItemProvider.dispose();
		if (fstr_Zug_Rangier_Allg_AttributeGroupItemProvider != null) fstr_Zug_Rangier_Allg_AttributeGroupItemProvider.dispose();
		if (laenge_Soll_TypeClassItemProvider != null) laenge_Soll_TypeClassItemProvider.dispose();
		if (markanter_PunktItemProvider != null) markanter_PunktItemProvider.dispose();
		if (markanter_Punkt_Bezeichnung_AttributeGroupItemProvider != null) markanter_Punkt_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (massgebende_Neigung_TypeClassItemProvider != null) massgebende_Neigung_TypeClassItemProvider.dispose();
		if (rangier_Gegenfahrtausschluss_TypeClassItemProvider != null) rangier_Gegenfahrtausschluss_TypeClassItemProvider.dispose();
		if (sonstiger_PunktItemProvider != null) sonstiger_PunktItemProvider.dispose();
		if (start_Signal_Charakter_TypeClassItemProvider != null) start_Signal_Charakter_TypeClassItemProvider.dispose();
	}

}
