/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.internal;

import java.util.LinkedList;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.commands.internal.HandlerServiceHandler;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;

public class HandlerServiceImpl
implements EHandlerService {
    private static final String SWT_TRIGGER = "org.eclipse.swt.widgets.Event";
    static final String TMP_STATIC_CONTEXT = "tmp-staticContext";
    public static final String H_ID = "handler::";
    public static final String PARM_MAP = "parmMap::";
    public static final String CAN_EXECUTE = "HandlerServiceImpl.canExecute";
    public static final String NOT_HANDLED = "HandlerServiceImpl.notHandled";
    public static final String STATIC_CONTEXT = "HandlerServiceImpl.staticContext";
    public static final String HANDLER_EXCEPTION = "HandlerServiceImpl.exception";
    public static ContextFunction handlerGenerator = null;
    private static LinkedList<ExecutionContexts> DEFAULT_STACKLIST = new LinkedList();
    private IEclipseContext context;
    @Inject
    @Optional
    Logger logger;

    public static IHandler getHandler(String commandId, IEclipseContext context) {
        if (handlerGenerator != null) {
            return (IHandler)handlerGenerator.compute(null, commandId);
        }
        return new HandlerServiceHandler(commandId, context);
    }

    static LinkedList<ExecutionContexts> getContextStack(IEclipseContext context) {
        if (context == null) {
            return DEFAULT_STACKLIST;
        }
        Object handlerExecutionStack = context.get("_handlerExecutionStack");
        if (handlerExecutionStack == null) {
            return DEFAULT_STACKLIST;
        }
        return (LinkedList)handlerExecutionStack;
    }

    public static void push(IEclipseContext ctx, IEclipseContext staticCtx) {
        HandlerServiceImpl.getContextStack(ctx).addFirst(new ExecutionContexts(ctx, staticCtx));
    }

    public static ExecutionContexts pop(IEclipseContext ctx) {
        return HandlerServiceImpl.getContextStack(ctx).poll();
    }

    static ExecutionContexts peek(IEclipseContext ctx) {
        return HandlerServiceImpl.getContextStack(ctx).peek();
    }

    public static Object lookUpHandler(IEclipseContext context, String commandId) {
        return context.getActiveLeaf().get(H_ID + commandId);
    }

    private void addParms(ParameterizedCommand command, IEclipseContext staticContext) {
        Map parms = command.getParameterMap();
        for (Map.Entry entry : parms.entrySet()) {
            String parameterId = (String)entry.getKey();
            staticContext.set(parameterId, this.convertParameterValue(command.getCommand(), parameterId, (String)entry.getValue()));
        }
        staticContext.set(PARM_MAP, (Object)parms);
        staticContext.set(ParameterizedCommand.class, (Object)command);
    }

    private Object convertParameterValue(Command command, String parameterId, String value) {
        try {
            AbstractParameterValueConverter valueConverter;
            ParameterType parameterType = command.getParameterType(parameterId);
            if (parameterType != null && (valueConverter = parameterType.getValueConverter()) != null) {
                return valueConverter.convertToObject(value);
            }
        }
        catch (NotDefinedException notDefinedException) {
        }
        catch (ParameterValueConversionException parameterValueConversionException) {}
        return value;
    }

    @Override
    public void activateHandler(String commandId, Object handler) {
        String handlerId = H_ID + commandId;
        this.context.set(handlerId, handler);
    }

    @Override
    public boolean canExecute(ParameterizedCommand command) {
        IEclipseContext staticContext = EclipseContextFactory.create((String)TMP_STATIC_CONTEXT);
        try {
            boolean bl = this.canExecute(command, staticContext);
            return bl;
        }
        finally {
            staticContext.dispose();
        }
    }

    @Override
    public boolean canExecute(ParameterizedCommand command, IEclipseContext staticContext) {
        IEclipseContext executionContext = this.getExecutionContext();
        this.addParms(command, staticContext);
        HandlerServiceImpl.push(executionContext, staticContext);
        try {
            Command cmd = command.getCommand();
            cmd.setEnabled((Object)new ExpressionContext(HandlerServiceImpl.peek((IEclipseContext)executionContext).context));
            boolean bl = cmd.isEnabled();
            return bl;
        }
        finally {
            HandlerServiceImpl.pop(executionContext);
        }
    }

    @Override
    public void deactivateHandler(String commandId, Object handler) {
        this.context.remove(H_ID + commandId);
    }

    @Override
    public Object executeHandler(ParameterizedCommand command) {
        IEclipseContext staticContext = EclipseContextFactory.create((String)TMP_STATIC_CONTEXT);
        try {
            Object object = this.executeHandler(command, staticContext);
            return object;
        }
        finally {
            staticContext.dispose();
        }
    }

    @Override
    public Object executeHandler(ParameterizedCommand command, IEclipseContext staticContext) {
        IEclipseContext executionContext = this.getExecutionContext();
        this.addParms(command, staticContext);
        HandlerServiceImpl.push(executionContext, staticContext);
        try {
            Object object = command.executeWithChecks(staticContext.get(SWT_TRIGGER), (Object)new ExpressionContext(HandlerServiceImpl.peek((IEclipseContext)executionContext).context));
            return object;
        }
        catch (ExecutionException e) {
            staticContext.set(HANDLER_EXCEPTION, (Object)e);
        }
        catch (NotDefinedException e) {
            staticContext.set(HANDLER_EXCEPTION, (Object)e);
        }
        catch (NotEnabledException e) {
            staticContext.set(HANDLER_EXCEPTION, (Object)e);
        }
        catch (NotHandledException e) {
            staticContext.set(HANDLER_EXCEPTION, (Object)e);
        }
        finally {
            HandlerServiceImpl.pop(executionContext);
        }
        return null;
    }

    @Inject
    public void setContext(IEclipseContext c) {
        this.context = c;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public IEclipseContext getExecutionContext() {
        return this.context.getActiveLeaf();
    }

    public static class ExecutionContexts {
        public IEclipseContext context;
        public IEclipseContext staticContext;

        public ExecutionContexts(IEclipseContext ctx, IEclipseContext staticCtx) {
            this.context = ctx;
            this.staticContext = staticCtx;
        }
    }
}

