/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.nio.ByteBuffer;
import org.eclipse.rdf4j.sail.lmdb.Statistics;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.lmdb.MDBVal;

class Pool {
    private static final ThreadLocal<Pool> threadlocal = ThreadLocal.withInitial(Pool::new);
    private final MDBVal[] valPool = new MDBVal[1024];
    private final ByteBuffer[] keyPool = new ByteBuffer[1024];
    private final Statistics[] statisticsPool = new Statistics[512];
    private int valPoolIndex = -1;
    private int keyPoolIndex = -1;
    private int statisticsPoolIndex = -1;

    Pool() {
    }

    final MDBVal getVal() {
        if (this.valPoolIndex >= 0) {
            return this.valPool[this.valPoolIndex--];
        }
        return MDBVal.malloc();
    }

    final ByteBuffer getKeyBuffer() {
        if (this.keyPoolIndex >= 0) {
            ByteBuffer bb = this.keyPool[this.keyPoolIndex--];
            bb.clear();
            return bb;
        }
        return MemoryUtil.memAlloc((int)36);
    }

    final Statistics getStatistics() {
        if (this.statisticsPoolIndex >= 0) {
            return this.statisticsPool[this.statisticsPoolIndex--];
        }
        return new Statistics();
    }

    final void free(MDBVal val) {
        if (this.valPoolIndex < this.valPool.length - 1) {
            this.valPool[++this.valPoolIndex] = val;
        } else {
            val.close();
        }
    }

    final void free(ByteBuffer bb) {
        if (this.keyPoolIndex < this.keyPool.length - 1) {
            this.keyPool[++this.keyPoolIndex] = bb;
        } else {
            MemoryUtil.memFree((ByteBuffer)bb);
        }
    }

    final void free(Statistics statistics) {
        if (this.statisticsPoolIndex < this.statisticsPool.length - 1) {
            this.statisticsPool[++this.statisticsPoolIndex] = statistics;
        }
    }

    final void close() {
        while (this.valPoolIndex >= 0) {
            this.valPool[this.valPoolIndex--].close();
        }
        while (this.keyPoolIndex >= 0) {
            MemoryUtil.memFree((ByteBuffer)this.keyPool[this.keyPoolIndex--]);
        }
    }

    public static Pool get() {
        return threadlocal.get();
    }

    public static void release() {
        Pool pool = threadlocal.get();
        pool.close();
        threadlocal.remove();
    }
}

