/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;

public class AndValueEvaluationStep
implements QueryValueEvaluationStep {
    private final QueryValueEvaluationStep leftStep;
    private final QueryValueEvaluationStep rightStep;

    public AndValueEvaluationStep(QueryValueEvaluationStep leftStep, QueryValueEvaluationStep rightStep) {
        this.leftStep = leftStep;
        this.rightStep = rightStep;
    }

    @Override
    public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            if (QueryEvaluationUtility.getEffectiveBooleanValue(this.leftStep.evaluate(bindings)) == QueryEvaluationUtility.Result._false) {
                return BooleanLiteral.FALSE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.rightStep.evaluate(bindings);
            if (QueryEvaluationUtility.getEffectiveBooleanValue(rightValue) == QueryEvaluationUtility.Result._false) {
                return BooleanLiteral.FALSE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.rightStep.evaluate(bindings);
        return BooleanLiteral.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public static QueryValueEvaluationStep supply(QueryValueEvaluationStep leftStep, QueryValueEvaluationStep rightStep) {
        QueryEvaluationUtility.Result constantRightValue;
        if (leftStep.isConstant()) {
            QueryEvaluationUtility.Result constantLeftValue = QueryEvaluationUtility.getEffectiveBooleanValue(leftStep.evaluate(EmptyBindingSet.getInstance()));
            if (constantLeftValue == QueryEvaluationUtility.Result._false) {
                return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(BooleanLiteral.FALSE);
            }
            if (constantLeftValue == QueryEvaluationUtility.Result._true && rightStep.isConstant()) {
                QueryEvaluationUtility.Result constantRightValue2 = QueryEvaluationUtility.getEffectiveBooleanValue(rightStep.evaluate(EmptyBindingSet.getInstance()));
                if (constantRightValue2 == QueryEvaluationUtility.Result._false) {
                    return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(BooleanLiteral.FALSE);
                }
                if (constantRightValue2 == QueryEvaluationUtility.Result._true) {
                    return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(BooleanLiteral.TRUE);
                }
            }
        }
        if (rightStep.isConstant() && (constantRightValue = QueryEvaluationUtility.getEffectiveBooleanValue(rightStep.evaluate(EmptyBindingSet.getInstance()))) == QueryEvaluationUtility.Result._false) {
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(BooleanLiteral.FALSE);
        }
        return new AndValueEvaluationStep(leftStep, rightStep);
    }
}

