/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.jaas.MQAdminGroup;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQAccessControlContext;
import com.sun.messaging.jmq.util.BASE64Decoder;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public final class JMQAdminKeyAuthenticationHandler
implements AuthenticationProtocolHandler {
    private static boolean DEBUG = false;
    private static Logger logger = Globals.getLogger();
    private AccessControlContext acc = null;
    private Properties authProps = null;
    private static final String ADMINKEYNAME = "admin";

    @Override
    public String getType() {
        return "jmqadminkey";
    }

    @Override
    public byte[] init(int sequence, Properties authProperties, Refreshable cacheData) {
        this.authProps = authProperties;
        return null;
    }

    @Override
    public byte[] handleResponse(byte[] authResponse, int sequence) throws LoginException {
        Subject subject = null;
        this.acc = null;
        if (this.authProps == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4100", this.getType()));
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(authResponse);
            DataInputStream dis = new DataInputStream(bis);
            String username = dis.readUTF();
            BASE64Decoder decoder = new BASE64Decoder();
            String pass = dis.readUTF();
            String password = new String(decoder.decodeBuffer(pass), "UTF8");
            dis.close();
            String adminkey = this.authProps.getProperty("imq.adminkey");
            if (DEBUG) {
                logger.log(4, "imq.adminkey:" + adminkey + ": password:" + password + ":");
            }
            if (adminkey != null) {
                if (username.equals(ADMINKEYNAME) && password.equals(adminkey)) {
                    final String tempUserName = username;
                    subject = (Subject)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            Subject tempSubject = new Subject();
                            tempSubject.getPrincipals().add(new MQUser(tempUserName));
                            tempSubject.getPrincipals().add(new MQAdminGroup(JMQAdminKeyAuthenticationHandler.ADMINKEYNAME));
                            return tempSubject;
                        }
                    });
                    this.acc = new JMQAccessControlContext(new MQUser(username), subject, this.authProps);
                    return null;
                }
                FailedLoginException ex = new FailedLoginException(Globals.getBrokerResources().getKString("B4051", username));
                ex.setUser(username);
                throw ex;
            }
            throw new LoginException(Globals.getBrokerResources().getKString("B4099"));
        }
        catch (IOException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IOException: " + e.getMessage()));
        }
    }

    @Override
    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    @Override
    public Refreshable getCacheData() {
        return null;
    }

    @Override
    public void logout() {
        this.authProps = null;
    }
}

