/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.Element;
import org.eclipse.oomph.internal.version.Messages;
import org.eclipse.oomph.internal.version.Release;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IRelease;
import org.eclipse.oomph.version.IReleaseManager;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.osgi.framework.Version;
import org.xml.sax.SAXException;

public class ReleaseManager
implements IReleaseManager {
    private final Map<IRelease, Long> releases = new WeakHashMap<IRelease, Long>();
    private final Map<IProductModel, Long> productModels = new WeakHashMap<IProductModel, Long>();
    private SAXParserFactory parserFactory;

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        return this.parserFactory.newSAXParser();
    }

    @Override
    public synchronized IRelease getRelease(IFile file) throws CoreException {
        try {
            Activator.LaxLowerBoundCheckMode laxLowerBoundCheckMode;
            for (Map.Entry<IRelease, Long> entry : this.releases.entrySet()) {
                IRelease release = entry.getKey();
                if (!release.getFile().equals((Object)file)) continue;
                long timeStamp = entry.getValue();
                if (file.getLocalTimeStamp() == timeStamp) {
                    return release;
                }
                this.releases.remove(release);
                break;
            }
            String releasePath = file.getFullPath().toString();
            Activator.ReleaseCheckMode releaseCheckMode = Activator.getReleaseCheckMode(releasePath);
            if (releaseCheckMode == null) {
                Activator.setReleaseCheckMode(releasePath, Activator.ReleaseCheckMode.FULL);
            }
            if ((laxLowerBoundCheckMode = Activator.getLaxLowerBoundCheckMode(releasePath)) == null) {
                Activator.setLaxLowerBoundCheckMode(releasePath, Activator.LaxLowerBoundCheckMode.SAME_RELEASE);
            }
            if (!file.exists()) {
                throw new FileNotFoundException(releasePath);
            }
            Release release = new Release(this.getParser(), file);
            this.releases.put(release, file.getLocalTimeStamp());
            return release;
        }
        catch (CoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.oomph.version", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    @Override
    public Map<IElement, IElement> createElements(String path, boolean resolve) {
        HashMap<IElement, IElement> elements = new HashMap<IElement, IElement>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                VersionBuilderArguments args = new VersionBuilderArguments(project);
                String releasePath = args.getReleasePath();
                if (path == null || path.equals(releasePath)) {
                    for (IModel componentModel : VersionUtil.getComponentModels(project)) {
                        IElement element = this.createElement(componentModel, true, resolve);
                        elements.put(element, element);
                    }
                }
            }
            ++n2;
        }
        Set keySet = elements.keySet();
        ArrayList queue = new ArrayList(keySet);
        int i = 0;
        while (i < queue.size()) {
            IElement element = (IElement)queue.get(i);
            for (IElement child : element.getChildren()) {
                if (elements.containsKey(child)) continue;
                IModel childModel = this.getComponentModel(child.trimVersion());
                if (childModel != null) {
                    IElement topElement = this.createElement(childModel, true, resolve);
                    queue.add(topElement);
                    elements.put(topElement, topElement);
                    continue;
                }
                elements.put(child, child);
            }
            ++i;
        }
        return elements;
    }

    @Override
    public synchronized IRelease createRelease(IFile file) throws CoreException, IOException, NoSuchAlgorithmException {
        Release release = new Release(file);
        String path = file.getFullPath().toString();
        release.getElements().putAll(this.createElements(path, true));
        release.write();
        this.releases.put(release, file.getLocalTimeStamp());
        return release;
    }

    @Override
    public IElement createElement(IModel componentModel, boolean withFeatureContent, boolean resolve) {
        if (componentModel instanceof IPluginModelBase) {
            IPluginModelBase pluginModel = (IPluginModelBase)componentModel;
            BundleDescription description = pluginModel.getBundleDescription();
            if (description == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.ReleaseManager_NoDescription_exception, (Object)pluginModel.getInstallLocation()));
            }
            String name = description.getSymbolicName();
            Version version = description.getVersion();
            return new Element(IElement.Type.PLUGIN, name, null, version, pluginModel instanceof IFragmentModel);
        }
        if (componentModel instanceof IFeatureModel) {
            return this.createFeatureElement(componentModel, withFeatureContent, resolve);
        }
        return this.createProductElement(componentModel, resolve);
    }

    private IElement createFeatureElement(IModel componentModel, boolean withContent, boolean resolve) {
        IFeatureModel featureModel = (IFeatureModel)componentModel;
        IFeature feature = featureModel.getFeature();
        String name = feature.getId();
        String versionValue = feature.getVersion();
        Version version = new Version(StringUtil.isEmpty((String)versionValue) ? "1.0.0.qualifier" : versionValue);
        Element element = new Element(IElement.Type.FEATURE, name, null, version);
        if (withContent) {
            Element child;
            IFeatureChild versionable;
            List<IElement> children = element.getChildren();
            String licenseFeatureID = feature.getLicenseFeatureID();
            if (!StringUtil.isEmpty((String)licenseFeatureID)) {
                Element child2 = new Element(IElement.Type.FEATURE, licenseFeatureID, null, feature.getLicenseFeatureVersion());
                if (resolve) {
                    child2.resolveVersion();
                }
                child2.setLicenseFeature(true);
                children.add(child2);
            }
            IFeatureChild[] iFeatureChildArray = feature.getIncludedFeatures();
            int n = iFeatureChildArray.length;
            int n2 = 0;
            while (n2 < n) {
                versionable = iFeatureChildArray[n2];
                child = new Element(IElement.Type.FEATURE, versionable.getId(), null, versionable.getVersion());
                if (resolve) {
                    child.resolveVersion();
                }
                children.add(child);
                ++n2;
            }
            iFeatureChildArray = feature.getPlugins();
            n = iFeatureChildArray.length;
            n2 = 0;
            while (n2 < n) {
                versionable = iFeatureChildArray[n2];
                child = new Element(IElement.Type.PLUGIN, versionable.getId(), null, versionable.getVersion(), versionable.isFragment());
                if (resolve) {
                    child.resolveVersion();
                }
                children.add(child);
                ++n2;
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IElement createProductElement(IModel componentModel, boolean resolve) {
        Element child;
        IProductFeature versionable;
        IProductModel productModel = (IProductModel)componentModel;
        IProduct product = productModel.getProduct();
        ReleaseManager releaseManager = this;
        synchronized (releaseManager) {
            this.productModels.put(productModel, productModel.getUnderlyingResource().getModificationStamp());
        }
        String name = product.getId();
        String versionValue = product.getVersion();
        Version version = new Version(StringUtil.isEmpty((String)versionValue) ? "1.0.0.qualifier" : versionValue);
        Element element = new Element(IElement.Type.PRODUCT, name, product.getProductId(), version);
        List<IElement> children = element.getChildren();
        IProductFeature[] iProductFeatureArray = product.getFeatures();
        int n = iProductFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            versionable = iProductFeatureArray[n2];
            String featureVersion = versionable.getVersion();
            if (StringUtil.isEmpty((String)featureVersion)) {
                featureVersion = "0.0.0";
            }
            child = new Element(IElement.Type.FEATURE, versionable.getId(), null, featureVersion);
            if (resolve) {
                child.resolveVersion();
            }
            children.add(child);
            ++n2;
        }
        iProductFeatureArray = product.getPlugins();
        n = iProductFeatureArray.length;
        n2 = 0;
        while (n2 < n) {
            versionable = iProductFeatureArray[n2];
            String pluginVersion = versionable.getVersion();
            if (StringUtil.isEmpty((String)pluginVersion)) {
                pluginVersion = "0.0.0";
            }
            child = new Element(IElement.Type.PLUGIN, versionable.getId(), null, pluginVersion, versionable.isFragment());
            if (resolve) {
                child.resolveVersion();
            }
            children.add(child);
            ++n2;
        }
        return element;
    }

    @Override
    public IModel getComponentModel(IElement element) {
        String name = element.getName();
        switch (element.getType()) {
            case PLUGIN: {
                IPluginModelBase model = PluginRegistry.findModel((String)name);
                if (name.endsWith(".source") && model != null && model.getUnderlyingResource() == null) {
                    return null;
                }
                if (model != null && !element.isVersionUnresolved()) {
                    Version pluginVersion = VersionUtil.normalize(model.getBundleDescription().getVersion());
                    if (!element.getVersion().equals((Object)pluginVersion)) {
                        return null;
                    }
                }
                return model;
            }
            case FEATURE: {
                FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
                IFeatureModel[] featureModels = manager.getWorkspaceModels();
                IFeatureModel featureModel = this.getFeatureModel(name, featureModels);
                if (featureModel == null && (featureModel = this.getFeatureModel(name, featureModels = manager.getExternalModels())) == null) {
                    return null;
                }
                if (name.endsWith(".source") && featureModel.getUnderlyingResource() == null) {
                    return null;
                }
                if (!element.isVersionUnresolved()) {
                    IFeature feature = featureModel.getFeature();
                    Version featureVersion = VersionUtil.normalize(new Version(feature.getVersion()));
                    if (!element.getVersion().equals((Object)featureVersion)) {
                        return null;
                    }
                }
                return featureModel;
            }
            case PRODUCT: {
                return this.getProductModel(element);
            }
        }
        throw new IllegalStateException(NLS.bind((String)Messages.ReleaseManager_UnknownElement_exception, (Object)element));
    }

    private IFeatureModel getFeatureModel(String name, IFeatureModel[] featureModels) {
        Version highestVersion = null;
        IFeatureModel highestModel = null;
        IFeatureModel[] iFeatureModelArray = featureModels;
        int n = featureModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel featureModel = iFeatureModelArray[n2];
            IFeature feature = featureModel.getFeature();
            String id = feature.getId();
            if (id.equals(name)) {
                Version newVersion = new Version(feature.getVersion());
                if (highestVersion == null || highestVersion.compareTo(newVersion) < 0) {
                    highestVersion = newVersion;
                    highestModel = featureModel;
                }
            }
            ++n2;
        }
        return highestModel;
    }

    private synchronized IProductModel getProductModel(IElement element) {
        this.clearStaleCachedProductModels();
        IProductModel productModel = this.getCachedProduct(element);
        if (productModel == null) {
            this.populateCachedProducts();
            productModel = this.getCachedProduct(element);
        }
        return productModel;
    }

    private void clearStaleCachedProductModels() {
        Iterator<Map.Entry<IProductModel, Long>> it = this.productModels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IProductModel, Long> entry = it.next();
            IProductModel productModel = entry.getKey();
            IResource underlyingResource = productModel.getUnderlyingResource();
            long timeStamp = entry.getValue();
            if (underlyingResource.getModificationStamp() == timeStamp) continue;
            it.remove();
        }
    }

    private void populateCachedProducts() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                for (IProductModel productModel : VersionUtil.getProductModels(project)) {
                    IResource underlyingResource = productModel.getUnderlyingResource();
                    long timeStamp = underlyingResource.getModificationStamp();
                    this.productModels.put(productModel, timeStamp);
                }
            }
            ++n2;
        }
    }

    private IProductModel getCachedProduct(IElement element) {
        String name = element.getName();
        for (IProductModel productModel : this.productModels.keySet()) {
            IProduct product = productModel.getProduct();
            if (!name.equals(product.getId())) continue;
            if (!element.isVersionUnresolved()) {
                Version productVersion = VersionUtil.normalize(new Version(product.getVersion()));
                if (!element.getVersion().equals((Object)productVersion)) continue;
            }
            return productModel;
        }
        return null;
    }
}

