/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.presentation;

import java.lang.reflect.Method;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.internal.ui.AbstractPreferencePage;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.presentation.Messages;
import org.eclipse.oomph.projectconfig.presentation.ProjectConfigEditorPlugin;
import org.eclipse.oomph.projectconfig.presentation.sync.ProjectConfigSynchronizerPreferences;
import org.eclipse.oomph.projectconfig.util.ProjectConfigUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ProjectConfigPreferencePage
extends AbstractPreferencePage {
    private IWorkbench workbench;
    private boolean configurationManagementAutomatic = ProjectConfigSynchronizerPreferences.isConfigurationManagementAutomatic();
    private boolean configurationValidationPrompt = ProjectConfigSynchronizerPreferences.isConfigurationValidationPrompt();
    private ProjectConfigSynchronizerPreferences.PropertyModificationHandling propertyModificationHandling = ProjectConfigSynchronizerPreferences.getPropertyModificationHandling();
    private Button automaticPreferenceManagementButton;
    private Button ignoreErrorsButton;
    private Button promptErrorsButton;
    private Button overwriteButton;
    private Button propagate;
    private Button promptButton;
    private Group errorHandlingGroup;
    private Group modificationHandlingGroup;

    public ProjectConfigPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    private void update() {
        this.errorHandlingGroup.setEnabled(this.configurationManagementAutomatic);
        this.ignoreErrorsButton.setEnabled(this.configurationManagementAutomatic);
        this.promptErrorsButton.setEnabled(this.configurationManagementAutomatic);
        this.modificationHandlingGroup.setEnabled(this.configurationManagementAutomatic);
        this.overwriteButton.setEnabled(this.configurationManagementAutomatic);
        this.propagate.setEnabled(this.configurationManagementAutomatic);
        this.promptButton.setEnabled(this.configurationManagementAutomatic);
    }

    protected Control doCreateContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        this.automaticPreferenceManagementButton = new Button(composite, 32);
        this.automaticPreferenceManagementButton.setText(Messages.ProjectConfigPreferencePage_AutomaticPreferenceManagement_label);
        this.automaticPreferenceManagementButton.setSelection(this.configurationManagementAutomatic);
        this.automaticPreferenceManagementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.configurationManagementAutomatic = !ProjectConfigPreferencePage.this.configurationManagementAutomatic;
                ProjectConfigPreferencePage.this.update();
            }
        });
        this.errorHandlingGroup = new Group(composite, 0);
        this.errorHandlingGroup.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.horizontalIndent = 10;
        this.errorHandlingGroup.setLayoutData((Object)layoutData);
        this.errorHandlingGroup.setText(Messages.ProjectConfigPreferencePage_InvalidConfigurationHandling_label);
        this.ignoreErrorsButton = new Button((Composite)this.errorHandlingGroup, 16);
        this.ignoreErrorsButton.setText(Messages.ProjectConfigPreferencePage_IgnoreErrors_label);
        if (!this.configurationValidationPrompt) {
            this.ignoreErrorsButton.setSelection(true);
        }
        this.ignoreErrorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.configurationValidationPrompt = false;
            }
        });
        this.promptErrorsButton = new Button((Composite)this.errorHandlingGroup, 16);
        this.promptErrorsButton.setText(Messages.ProjectConfigPreferencePage_PromptFixErrors_label);
        if (this.configurationValidationPrompt) {
            this.promptErrorsButton.setSelection(true);
        }
        this.promptErrorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.configurationValidationPrompt = true;
            }
        });
        this.modificationHandlingGroup = new Group(composite, 0);
        this.modificationHandlingGroup.setLayout((Layout)new GridLayout());
        layoutData = new GridData(4, 128, true, false);
        layoutData.horizontalIndent = 10;
        this.modificationHandlingGroup.setLayoutData((Object)layoutData);
        this.modificationHandlingGroup.setText(Messages.ProjectConfigPreferencePage_ManagedPropertyModificationHandling_label);
        this.overwriteButton = new Button((Composite)this.modificationHandlingGroup, 16);
        this.overwriteButton.setText(Messages.ProjectConfigPreferencePage_Overwite_label);
        if (this.propertyModificationHandling == ProjectConfigSynchronizerPreferences.PropertyModificationHandling.OVERWRITE) {
            this.overwriteButton.setSelection(true);
        }
        this.overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.propertyModificationHandling = ProjectConfigSynchronizerPreferences.PropertyModificationHandling.OVERWRITE;
            }
        });
        this.propagate = new Button((Composite)this.modificationHandlingGroup, 16);
        this.propagate.setText(Messages.ProjectConfigPreferencePage_Propagate_label);
        if (this.propertyModificationHandling == ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROPAGATE) {
            this.propagate.setSelection(true);
        }
        this.propagate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.propertyModificationHandling = ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROPAGATE;
            }
        });
        this.promptButton = new Button((Composite)this.modificationHandlingGroup, 16);
        this.promptButton.setText(Messages.ProjectConfigPreferencePage_Prompt_label);
        if (this.propertyModificationHandling == ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROMPT) {
            this.promptButton.setSelection(true);
        }
        this.promptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.propertyModificationHandling = ProjectConfigSynchronizerPreferences.PropertyModificationHandling.PROMPT;
            }
        });
        this.update();
        Label label = new Label(composite, 0);
        label.setText(Messages.ProjectConfigPreferencePage_ManageConfigurations_label);
        TreeViewer treeViewer = new TreeViewer(composite);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        treeViewer.setInput((Object)ProjectConfigUtil.getWorkspaceConfiguration().eResource());
        treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected void contributeButtons(Composite parent) {
        super.contributeButtons(parent);
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        gridLayout.numColumns += 2;
        Button applyButton = new Button(parent, 8);
        applyButton.setText(Messages.ProjectConfigPreferencePage_Apply_label);
        Dialog.applyDialogFont((Control)applyButton);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minButtonSize = applyButton.computeSize(-1, -1, true);
        GridData data = new GridData(256);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        applyButton.setLayoutData((Object)data);
        applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.performOk();
                WorkspaceConfiguration workspaceConfiguration = ProjectConfigUtil.getWorkspaceConfiguration();
                workspaceConfiguration.updatePreferenceProfileReferences();
                workspaceConfiguration.applyPreferenceProfiles();
            }
        });
        Button editButton = new Button(parent, 8);
        editButton.setText(Messages.ProjectConfigPreferencePage_Edit_label);
        Dialog.applyDialogFont((Control)editButton);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        minButtonSize = editButton.computeSize(-1, -1, true);
        data = new GridData(256);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigPreferencePage.this.performOk();
                IPreferencePageContainer container = ProjectConfigPreferencePage.this.getContainer();
                try {
                    Method method = container.getClass().getMethod("close", new Class[0]);
                    method.invoke((Object)container, new Object[0]);
                }
                catch (Throwable ex) {
                    ProjectConfigEditorPlugin.INSTANCE.log(ex);
                }
                ProjectConfigPreferencePage.this.openWorkingSetsEditor();
            }
        });
    }

    protected void openWorkingSetsEditor() {
        final IWorkbenchWindow activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        Display display = activeWorkbenchWindow.getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    URIEditorInput editorInput = new URIEditorInput(ProjectConfigUtil.PROJECT_CONFIG_URI.appendSegment("All.projectconfig"), Messages.ProjectConfigPreferencePage_ProjectPreferenceConfiguration_label);
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    activePage.openEditor((IEditorInput)editorInput, "org.eclipse.oomph.projectconfig.presentation.ProjectConfigEditorID");
                    activePage.showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (Exception ex) {
                    ProjectConfigEditorPlugin.INSTANCE.log(ex);
                }
            }
        });
    }

    public boolean performOk() {
        ProjectConfigSynchronizerPreferences.setConfigurationManagementAutomatic(this.configurationManagementAutomatic);
        ProjectConfigSynchronizerPreferences.setConfigurationValidationPrompt(this.configurationValidationPrompt);
        ProjectConfigSynchronizerPreferences.setPropertyModificationHandling(this.propertyModificationHandling);
        ProjectConfigSynchronizerPreferences.flush();
        ProjectConfigEditorPlugin.getPlugin().update();
        return true;
    }
}

