/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2;

import java.util.Comparator;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.p2.RequirementType;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Requirement
extends ModelElement {
    public static final String FEATURE_SUFFIX = ".feature.group";
    public static final String PROJECT_SUFFIX = ".plain.project";
    public static final Comparator<Requirement> COMPARATOR = new Comparator<Requirement>(){

        @Override
        public int compare(Requirement o1, Requirement o2) {
            String n2;
            String n1;
            String ns2;
            String ns1 = StringUtil.safe((String)o1.getNamespace());
            int result = ns1.compareTo(ns2 = StringUtil.safe((String)o2.getNamespace()));
            if (result == 0 && (result = (n1 = StringUtil.safe((String)o1.getName())).compareTo(n2 = StringUtil.safe((String)o2.getName()))) == 0) {
                VersionRange range1 = o1.getVersionRange();
                VersionRange range2 = o2.getVersionRange();
                result = range1.getMinimum().compareTo((Object)range2.getMinimum());
                if (result == 0) {
                    result = range1.getMaximum().compareTo((Object)range2.getMaximum());
                }
            }
            return result;
        }
    };

    public String getName();

    public void setName(String var1);

    public String getNamespace();

    public void setNamespace(String var1);

    public VersionRange getVersionRange();

    public void setVersionRange(VersionRange var1);

    public boolean isOptional();

    public void setOptional(boolean var1);

    public String getFilter();

    public void setFilter(String var1);

    public RequirementType getType();

    public IMatchExpression<IInstallableUnit> getMatchExpression();

    public void setMatchExpression(IMatchExpression<IInstallableUnit> var1);

    public void setVersionRange(Version var1, VersionSegment var2);
}

