/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public abstract class AbstractQuickfixTest
extends AbstractEditorTest {
    @Inject
    protected Injector injector;
    @Inject
    protected IResourceSetProvider resourceSetProvider;
    @Inject
    protected IResourceValidator resourceValidator;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected IssueResolutionProvider issueResolutionProvider;
    protected IProject project;

    public void testQuickfixesOn(CharSequence content, String issueCode, Quickfix ... quickfixes) {
        IFile dslFile = this.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content);
        this.project = dslFile.getProject();
        this.quickfixesAreOffered(this.openInEditor(dslFile), issueCode, quickfixes);
    }

    protected String getProjectName() {
        return "QuickfixTestProject";
    }

    protected String getFileName() {
        return "quickfix";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }

    protected XtextEditor openInEditor(IFile dslFile) {
        IResourcesSetupUtil.waitForBuild();
        try {
            return this.openEditor(dslFile);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void quickfixesAreOffered(XtextEditor editor, String issueCode, Quickfix ... expected) {
        List<Quickfix> expectedSorted = Arrays.asList(expected);
        expectedSorted.sort(Comparator.comparing(e -> e.getLabel()));
        IXtextDocument document = editor.getDocument();
        String originalText = document.get();
        Issue issue = this.getValidationIssue(document, issueCode);
        List actualIssueResolutions = this.issueResolutionProvider.getResolutions(issue);
        actualIssueResolutions.sort(Comparator.comparing(i -> i.getLabel()));
        AbstractQuickfixTest.assertEquals((String)"The number of quickfixes does not match!", (long)expectedSorted.size(), (long)actualIssueResolutions.size());
        int i2 = 0;
        while (i2 < actualIssueResolutions.size()) {
            IssueResolution actualIssueResolution = (IssueResolution)actualIssueResolutions.get(i2);
            Quickfix expectedIssueResolution = expectedSorted.get(i2);
            AbstractQuickfixTest.assertEquals((Object)expectedIssueResolution.label, (Object)actualIssueResolution.getLabel());
            AbstractQuickfixTest.assertEquals((Object)expectedIssueResolution.description, (Object)actualIssueResolution.getDescription());
            this.assertIssueResolutionResult(expectedIssueResolution.result, actualIssueResolution, originalText);
            ++i2;
        }
    }

    protected Issue getValidationIssue(IXtextDocument document, String issueCode) {
        List issueCandidates = ((List)document.readOnly(state -> this.resourceValidator.validate((Resource)state, CheckMode.NORMAL_AND_FAST, CancelIndicator.NullImpl))).stream().filter(issue -> Objects.equals(issue.getCode(), issueCode)).collect(Collectors.toList());
        AbstractQuickfixTest.assertEquals((String)("There should be one '" + issueCode + "' validation issue!"), (long)1L, (long)issueCandidates.size());
        return (Issue)issueCandidates.get(0);
    }

    protected List<Issue> getAllValidationIssues(IXtextDocument document) {
        return (List)document.readOnly((IUnitOfWork)new IUnitOfWork<List<Issue>, XtextResource>(){

            public List<Issue> exec(XtextResource state) throws Exception {
                return AbstractQuickfixTest.this.resourceValidator.validate((Resource)state, CheckMode.ALL, null);
            }
        });
    }

    protected void assertIssueResolutionResult(String expectedResult, IssueResolution actualIssueResolution, String originalText) {
        IXtextDocument document = this.getDocument(originalText);
        TestModificationContext modificationContext = new TestModificationContext();
        modificationContext.setDocument(document);
        new IssueResolution(actualIssueResolution.getLabel(), actualIssueResolution.getDescription(), actualIssueResolution.getImage(), (IModificationContext)modificationContext, actualIssueResolution.getModification(), actualIssueResolution.getRelevance()).apply();
        String actualResult = document.get();
        AbstractQuickfixTest.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    protected IXtextDocument getDocument(String model) {
        XtextResource xtextResource = this.getXtextResource(model);
        XtextDocument document = (XtextDocument)this.injector.getInstance(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        return document;
    }

    protected XtextResource getXtextResource(String model) {
        StringInputStream in = new StringInputStream(Strings.emptyIfNull((String)model));
        URI uri = URI.createURI((String)"");
        ResourceSet resourceSet = this.resourceSetProvider.get(this.project);
        Resource resource = ((IResourceFactory)this.injector.getInstance(IResourceFactory.class)).createResource(uri);
        resourceSet.getResources().add((Object)resource);
        try {
            resource.load((InputStream)in, null);
            if (resource instanceof LazyLinkingResource) {
                ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
            } else {
                EcoreUtil.resolveAll((Resource)resource);
            }
            return (XtextResource)resource;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class Quickfix {
        private final String label;
        private final String description;
        private final String result;

        public Quickfix(String label, String description, String result) {
            this.label = label;
            this.description = description;
            this.result = result;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getResult() {
            return this.result;
        }

        public int hashCode() {
            return Objects.hash(this.description, this.label, this.result);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Quickfix other = (Quickfix)obj;
            return Objects.equals(this.description, other.description) && Objects.equals(this.label, other.label) && Objects.equals(this.result, other.result);
        }

        public String toString() {
            return "label: " + this.label + ", description: " + this.description + ", result: " + this.result;
        }
    }

    private static class TestModificationContext
    implements IModificationContext {
        private IXtextDocument document;

        private TestModificationContext() {
        }

        public IXtextDocument getXtextDocument() {
            return this.document;
        }

        public IXtextDocument getXtextDocument(URI uri) {
            return this.document;
        }

        public IXtextDocument setDocument(IXtextDocument document) {
            this.document = document;
            return document;
        }
    }
}

