/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.base.Joiner;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.generator.GeneratorWarning;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.NewlineNormalizer;
import org.eclipse.xtext.generator.parser.antlr.AbstractAntlrGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.debug.SimpleAntlrRuntimeModule;
import org.eclipse.xtext.generator.parser.antlr.debug.SimpleAntlrStandaloneSetup;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xtext.generator.parser.antlr.DebugGrammarToken;

@Deprecated(forRemoval=true)
public class DebugAntlrGeneratorFragment
extends AbstractAntlrGeneratorFragment {
    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        issues.addInfo("Generate debugging grammar file");
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        DebugGrammarToken token = DebugGrammarToken.aquire();
        try {
            super.generate(grammar, ctx);
            String srcGenPath = ctx.getOutput().getOutlet("SRC_GEN").getPath();
            String absoluteGrammarFileName = String.valueOf(srcGenPath) + "/" + this.getGrammarFileName(grammar, this.getNaming()).replace('.', '/') + ".g";
            this.prettyPrint(absoluteGrammarFileName, Charset.forName(this.getEncoding(ctx, "SRC_GEN")));
        }
        finally {
            token.done();
        }
    }

    protected void prettyPrint(String absoluteGrammarFileName, Charset encoding) {
        try {
            String content = this.readFileIntoString(absoluteGrammarFileName, encoding);
            final ILineSeparatorInformation lineSeparatorInformation = new ILineSeparatorInformation(){

                public String getLineSeparator() {
                    return DebugAntlrGeneratorFragment.this.getLineDelimiter();
                }
            };
            Injector injector = new SimpleAntlrStandaloneSetup(){

                @Override
                public Injector createInjector() {
                    return Guice.createInjector((Module[])new Module[]{new SimpleAntlrRuntimeModule(){

                        @Override
                        public void configure(Binder binder) {
                            super.configure(binder);
                            binder.bind(ILineSeparatorInformation.class).toInstance((Object)lineSeparatorInformation);
                        }
                    }});
                }
            }.createInjectorAndDoEMFRegistration();
            XtextResource resource = (XtextResource)injector.getInstance(XtextResource.class);
            resource.setURI(URI.createFileURI((String)absoluteGrammarFileName));
            resource.load((InputStream)new StringInputStream(content, encoding.name()), Collections.singletonMap(XtextResource.OPTION_ENCODING, encoding.name()));
            if (!resource.getErrors().isEmpty()) {
                String errors = Joiner.on((String)this.getLineDelimiter()).join((Iterable)resource.getErrors());
                throw new GeneratorWarning("Non fatal problem: Debug grammar could not be formatted due to:" + this.getLineDelimiter() + errors);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(content.length());
            resource.save((OutputStream)outputStream, SaveOptions.newBuilder().format().getOptions().toOptionsMap());
            String toBeWritten = new NewlineNormalizer(this.getLineDelimiter()).normalizeLineDelimiters(new String(outputStream.toByteArray(), encoding.name()));
            this.writeStringIntoFile(absoluteGrammarFileName, toBeWritten, encoding);
        }
        catch (IOException e) {
            throw new GeneratorWarning(e.getMessage());
        }
    }

    @Deprecated(forRemoval=true)
    protected void prettyPrint(String absoluteGrammarFileName) {
        this.prettyPrint(absoluteGrammarFileName, Charset.defaultCharset());
    }

    public String getGrammarFileName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageRuntime(g)) + ".parser.antlr.internal.DebugInternal" + GrammarUtil.getSimpleName((Grammar)g);
    }
}

