/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.naming.IQualifiedNameSupport;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.contentassist.AbstractXtextProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.label.StylerFactory;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ui.editor.syntaxcoloring.SemanticHighlightingConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextProposalProvider
extends AbstractXtextProposalProvider {
    @Inject
    private DefaultHighlightingConfiguration defaultLexicalHighlightingConfiguration;
    @Inject
    private SemanticHighlightingConfiguration semanticHighlightingConfiguration;
    @Inject
    private StylerFactory stylerFactory;

    @Override
    public void completeGrammar_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Resource resource = model.eResource();
        URI uri = resource.getURI();
        Path path = new Path(uri.toPlatformString(true));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        IProject project = file.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    IPath packageFragmentRootPath = packageFragmentRoot.getPath();
                    if (packageFragmentRootPath.isPrefixOf((IPath)path)) {
                        IPath relativePath = path.makeRelativeTo(packageFragmentRootPath);
                        relativePath = relativePath.removeFileExtension();
                        String result = relativePath.toString();
                        result = result.replace('/', '.');
                        acceptor.accept(this.createCompletionProposal(result, context));
                        return;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    @Override
    public void completeGeneratedMetamodel_Alias(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof GeneratedMetamodel) {
            EPackage ePackage = ((GeneratedMetamodel)model).getEPackage();
            String name = ((GeneratedMetamodel)model).getName();
            this.createAliasProposal(context, acceptor, ePackage, name);
        }
        super.completeGeneratedMetamodel_Alias(model, assignment, context, acceptor);
    }

    private void createAliasProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor, EPackage ePackage, String proposal) {
        ConfigurableCompletionProposal completionProposal;
        if (!Strings.isEmpty((String)proposal) && (completionProposal = (ConfigurableCompletionProposal)this.createCompletionProposal(proposal, String.valueOf(proposal) + " - alias", ePackage != null ? this.getImage((EObject)ePackage) : null, context)) != null) {
            completionProposal.setPriority(completionProposal.getPriority() * 2);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeReferencedMetamodel_Alias(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EPackage ePackage;
        if (model instanceof AbstractMetamodelDeclaration && (ePackage = ((AbstractMetamodelDeclaration)model).getEPackage()) != null) {
            this.createAliasProposal(context, acceptor, ePackage, ePackage.getName());
            this.createAliasProposal(context, acceptor, ePackage, ePackage.getNsPrefix());
        }
        super.completeReferencedMetamodel_Alias(model, assignment, context, acceptor);
    }

    protected StyledString getKeywordDisplayString(Keyword keyword) {
        return this.stylerFactory.createFromXtextStyle(keyword.getValue(), this.defaultLexicalHighlightingConfiguration.keywordTextStyle());
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
        StyledString styledDisplayString = super.getStyledDisplayString(element, qualifiedName, shortName);
        if (element instanceof ParserRule && GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)element))) {
            styledDisplayString = this.stylerFactory.createFromXtextStyle(styledDisplayString.getString(), this.semanticHighlightingConfiguration.dataTypeRule());
        }
        return styledDisplayString;
    }

    protected String getDisplayString(EObject element, String proposal, String shortName) {
        if (element instanceof AbstractMetamodelDeclaration) {
            AbstractMetamodelDeclaration decl = (AbstractMetamodelDeclaration)element;
            if (!Strings.isEmpty((String)decl.getAlias())) {
                return decl.getAlias();
            }
        } else if (element instanceof EPackage) {
            EPackage pack = (EPackage)element;
            return String.valueOf(pack.getName()) + " - " + pack.getNsURI();
        }
        return super.getDisplayString(element, proposal, shortName);
    }

    @Override
    public void completeAssignment_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractRule rule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)model, AbstractRule.class);
        EClassifier type = rule.getType().getClassifier();
        if (type instanceof EClass) {
            EList features = ((EClass)type).getEAllStructuralFeatures();
            this.completeStructuralFeatures(context, acceptor, (Iterable<? extends EStructuralFeature>)features);
        }
        super.completeAssignment_Feature(model, assignment, context, acceptor);
    }

    private void completeStructuralFeatures(ContentAssistContext context, ICompletionProposalAcceptor acceptor, Iterable<? extends EStructuralFeature> features) {
        if (features != null) {
            Function factory = this.getProposalFactory("ID", context);
            for (EStructuralFeature eStructuralFeature : features) {
                IEObjectDescription description = EObjectDescription.create((String)eStructuralFeature.getName(), (EObject)eStructuralFeature);
                ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)factory.apply((Object)description);
                if (proposal != null) {
                    proposal.setPriority(proposal.getPriority() * 2);
                }
                acceptor.accept((ICompletionProposal)proposal);
            }
        }
    }

    @Override
    public void completeAction_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EClassifier classifier;
        Action action = (Action)EcoreUtil2.getContainerOfType((EObject)model, Action.class);
        if (action != null && action.getType() != null && (classifier = action.getType().getClassifier()) instanceof EClass) {
            EList containments = ((EClass)classifier).getEAllContainments();
            this.completeStructuralFeatures(context, acceptor, (Iterable<? extends EStructuralFeature>)containments);
        }
        super.completeAction_Feature(model, assignment, context, acceptor);
    }

    @Override
    public void completeTypeRef_Classifier(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Grammar grammar = GrammarUtil.getGrammar((EObject)model);
        ContentAssistContext myContext = context.copy();
        myContext.setMatcher((PrefixMatcher)new ClassifierPrefixMatcher(context.getMatcher(), this.getQualifiedNameSupport()));
        if (model instanceof TypeRef) {
            CompositeNode node = NodeUtil.getNodeAdapter((EObject)model).getParserNode();
            int offset = node.getOffset();
            Region replaceRegion = new Region(offset, myContext.getReplaceRegion().getLength() + myContext.getReplaceRegion().getOffset() - offset);
            myContext.setReplaceRegion(replaceRegion);
            myContext.setLastCompleteNode((AbstractNode)node);
            StringBuilder availablePrefix = new StringBuilder(4);
            for (LeafNode leaf : node.getLeafNodes()) {
                if (leaf.getGrammarElement() != null && !leaf.isHidden()) {
                    if (leaf.getTotalLength() + leaf.getTotalOffset() < context.getOffset()) {
                        availablePrefix.append(leaf.getText());
                    } else {
                        availablePrefix.append(leaf.getText().substring(0, context.getOffset() - leaf.getTotalOffset()));
                    }
                }
                if (leaf.getTotalOffset() >= context.getOffset()) break;
            }
            myContext.setPrefix(availablePrefix.toString());
        }
        for (AbstractMetamodelDeclaration declaration : grammar.getMetamodelDeclarations()) {
            if (declaration.getEPackage() == null) continue;
            this.createClassifierProposals(declaration, model, myContext, acceptor);
        }
    }

    private void createClassifierProposals(AbstractMetamodelDeclaration declaration, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String alias = declaration.getAlias();
        String prefix = "";
        if (!Strings.isEmpty((String)alias)) {
            prefix = String.valueOf(this.getValueConverter().toString((Object)alias, "ID")) + this.getQualifiedNameSupport().getDelimiter();
        }
        boolean createDatatypeProposals = !(model instanceof AbstractElement) && this.modelOrContainerIs(model, AbstractRule.class);
        boolean createEnumProposals = !(model instanceof AbstractElement) && this.modelOrContainerIs(model, EnumRule.class);
        boolean createClassProposals = this.modelOrContainerIs(model, ParserRule.class, CrossReference.class, Action.class);
        Function factory = this.getProposalFactory(null, context);
        for (EClassifier classifier : declaration.getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EDataType && createDatatypeProposals || classifier instanceof EEnum && createEnumProposals) && (!(classifier instanceof EClass) || !createClassProposals)) continue;
            String proposalString = String.valueOf(prefix) + this.getValueConverter().toString((Object)classifier.getName(), "ID");
            IEObjectDescription description = EObjectDescription.create((String)proposalString, (EObject)classifier);
            ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)factory.apply((Object)description);
            if (proposal != null) {
                if (!Strings.isEmpty((String)prefix)) {
                    proposal.setDisplayString(String.valueOf(classifier.getName()) + " - " + alias);
                }
                proposal.setPriority(proposal.getPriority() * 2);
            }
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    private boolean modelOrContainerIs(EObject model, Class<?> ... types) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type.isInstance(model) || type.isInstance(model.eContainer())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void complete_ParserRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeParserRule(model, context, acceptor);
        super.complete_ParserRule(model, ruleCall, context, acceptor);
    }

    @Override
    public void completeParserRule_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeParserRule(model, context, acceptor);
        super.completeParserRule_Name(model, assignment, context, acceptor);
    }

    private void completeParserRule(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Grammar grammar = GrammarUtil.getGrammar((EObject)model);
        for (AbstractMetamodelDeclaration metamodelDeclaration : grammar.getMetamodelDeclarations()) {
            ReferencedMetamodel referencedMetamodel;
            EPackage ePackage;
            if (!(metamodelDeclaration instanceof ReferencedMetamodel) || (ePackage = (referencedMetamodel = (ReferencedMetamodel)metamodelDeclaration).getEPackage()) == null) continue;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                ConfigurableCompletionProposal completionProposal;
                if (!this.isProposeParserRule(eClassifier, grammar)) continue;
                String proposal = eClassifier.getName();
                String metamodelAlias = referencedMetamodel.getAlias();
                if (metamodelAlias != null) {
                    proposal = String.valueOf(proposal) + " returns " + metamodelAlias + "::" + eClassifier.getName();
                }
                if ((completionProposal = (ConfigurableCompletionProposal)this.createCompletionProposal(proposal = String.valueOf(proposal) + ": \n;\n", String.valueOf(eClassifier.getName()) + " - parser rule", this.getImage((EObject)XtextFactory.eINSTANCE.createParserRule()), context)) == null) continue;
                completionProposal.setCursorPosition(proposal.length() - 3);
                acceptor.accept((ICompletionProposal)completionProposal);
            }
        }
    }

    private boolean isProposeParserRule(EClassifier eClassifier, Grammar grammar) {
        if (eClassifier instanceof EDataType && !((EDataType)eClassifier).isSerializable()) {
            return false;
        }
        Iterable allRuleNames = Iterables.transform((Iterable)GrammarUtil.allParserRules((Grammar)grammar), (Function)new Function<ParserRule, EClassifier>(){

            public EClassifier apply(ParserRule from) {
                return from.getType().getClassifier();
            }
        });
        return !Iterables.contains((Iterable)allRuleNames, (Object)eClassifier);
    }

    public static class ClassifierPrefixMatcher
    extends PrefixMatcher {
        private PrefixMatcher delegate;
        private String delimiter;

        public ClassifierPrefixMatcher(PrefixMatcher delegate, IQualifiedNameSupport qualifiedNameSupport) {
            this.delegate = delegate;
            this.delimiter = qualifiedNameSupport.getDelimiter();
        }

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            if (this.delegate.isCandidateMatchingPrefix(name, prefix)) {
                return true;
            }
            if (name.indexOf(this.delimiter) >= 0) {
                String[] splitName = name.split(this.delimiter);
                if (splitName.length == 1) {
                    return false;
                }
                String[] splitPrefix = prefix.split(this.delimiter);
                if (splitName.length < splitPrefix.length) {
                    return false;
                }
                if (splitPrefix.length == 1) {
                    return this.delegate.isCandidateMatchingPrefix(splitName[1], prefix);
                }
                if (!this.delegate.isCandidateMatchingPrefix(splitName[0], splitPrefix[0])) {
                    return false;
                }
                return this.delegate.isCandidateMatchingPrefix(splitName[1], splitPrefix[1]);
            }
            return false;
        }
    }
}

