/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist.antlr.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.parser.antlr.UnorderedGroupHelper;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.LookAheadTerminal;
import org.eclipse.xtext.ui.editor.contentassist.antlr.LookAheadTerminalRuleCall;
import org.eclipse.xtext.ui.editor.contentassist.antlr.LookaheadKeyword;
import org.eclipse.xtext.ui.editor.contentassist.antlr.ObservableXtextTokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInternalContentAssistParser
extends Parser
implements ObservableXtextTokenStream.StreamListener,
ITokenDefProvider {
    protected final List<EObject> grammarElements;
    protected final List<EObject> localTrace;
    protected int stackSize;
    protected final Set<FollowElement> followElements;
    protected ObservableXtextTokenStream.StreamListener delegate;
    protected List<TerminalRule> terminalRules;
    protected boolean mismatch;
    protected RecoveryListener recoveryListener;
    protected int lookAheadAddOn;
    protected boolean marked = false;
    protected boolean resyncing = false;
    protected int predictionLevel = 0;
    protected int currentMarker;
    protected int firstMarker;
    protected Multimap<Integer, AbstractElement> indexToHandledElements;
    protected IUnorderedGroupHelper unorderedGroupHelper;
    protected IFollowElementFactory followElementFactory = new DefaultFollowElementFactory();

    public AbstractInternalContentAssistParser(TokenStream input) {
        super(input);
        this.grammarElements = new ArrayList<EObject>();
        this.localTrace = new ArrayList<EObject>();
        this.followElements = new LinkedHashSet<FollowElement>();
    }

    public void before(EObject grammarElement) {
        this.grammarElements.add(grammarElement);
        this.localTrace.add(grammarElement);
    }

    public void after(EObject grammarElement) {
        int index;
        EObject foundGrammarElement = this.grammarElements.remove(this.grammarElements.size() - 1);
        if (grammarElement != foundGrammarElement) {
            throw new IllegalStateException("expected element: '" + grammarElement + "', but was: '" + foundGrammarElement + "'");
        }
        if (grammarElement instanceof UnorderedGroup && this.indexToHandledElements != null) {
            this.indexToHandledElements.removeAll((Object)this.grammarElements.size());
        } else if (!this.grammarElements.isEmpty() && this.grammarElements.get(index = this.grammarElements.size() - 1) instanceof UnorderedGroup) {
            if (this.indexToHandledElements == null) {
                this.indexToHandledElements = Multimaps.newLinkedHashMultimap();
            }
            this.indexToHandledElements.put((Object)index, (Object)((AbstractElement)grammarElement));
        }
    }

    public void recover(IntStream stream, RecognitionException ex) {
        if (this.recoveryListener != null) {
            this.recoveryListener.beginErrorRecovery();
        }
        this.removeUnexpectedElements();
        super.recover(stream, ex);
        if (this.recoveryListener != null) {
            this.recoveryListener.endErrorRecovery();
        }
    }

    private void removeUnexpectedElements() {
        while (this.stackSize < this.grammarElements.size()) {
            this.grammarElements.remove(this.grammarElements.size() - 1);
        }
    }

    public void emitErrorMessage(String msg) {
    }

    public void recoverFromMismatchedToken(IntStream in, RecognitionException re, int ttype, BitSet follow) throws RecognitionException {
        if (this.input.LA(2) == ttype) {
            this.reportError(re);
            this.beginResync();
            this.input.consume();
            this.endResync();
            this.input.consume();
            return;
        }
        if (!this.recoverFromMismatchedElement((IntStream)this.input, re, follow)) {
            throw re;
        }
    }

    protected abstract Grammar getGrammar();

    protected int keepStackSize() {
        int result = this.stackSize;
        this.stackSize = this.grammarElements.size();
        return result;
    }

    protected void restoreStackSize(int stackSize) {
        if (this.backtracking == 0) {
            this.removeUnexpectedElements();
            this.stackSize = stackSize;
        }
    }

    protected void selectEofStrategy() {
        this.delegate = this.mismatch ? this.createMismatchStrategy() : (!this.errorRecovery ? this.createNotErrorRecoveryStrategy() : this.createErrorRecoveryStrategy());
        if (this.predictionLevel > 0) {
            this.delegate = this.createPredictionStrategy();
        }
    }

    protected StreamAdapter createPredictionStrategy() {
        return new StreamAdapter(){
            private AbstractElement lastAddedElement;
            private AbstractElement globalLastAddedElement;
            private boolean wasMismatch;
            private ObservableXtextTokenStream.StreamListener privateDelegate;
            private IFollowElementFactory followElementFactory;
            {
                this.wasMismatch = false;
                this.privateDelegate = AbstractInternalContentAssistParser.this.delegate;
                this.followElementFactory = AbstractInternalContentAssistParser.this.followElementFactory;
                AbstractInternalContentAssistParser.this.followElementFactory = new IFollowElementFactory(){

                    public FollowElement createFollowElement(AbstractElement current, int lookAhead) {
                        FollowElement result = followElementFactory.createFollowElement(current, lookAhead);
                        if (result != null) {
                            globalLastAddedElement = result.getGrammarElement();
                        }
                        return result;
                    }
                };
            }

            public void announceEof(int lookAhead) {
                if (AbstractInternalContentAssistParser.this.predictionLevel == 0) {
                    AbstractElement current;
                    if (!(this.wasMismatch || AbstractInternalContentAssistParser.this.errorRecovery && AbstractInternalContentAssistParser.this.resyncing || (current = AbstractInternalContentAssistParser.this.getCurrentGrammarElement()) == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                        if (AbstractInternalContentAssistParser.this.errorRecovery) {
                            if (this.globalLastAddedElement == null || GrammarUtil.isOptionalCardinality((AbstractElement)this.globalLastAddedElement) || GrammarUtil.isOneOrMoreCardinality((AbstractElement)this.globalLastAddedElement)) {
                                if (AbstractInternalContentAssistParser.this.marked) {
                                    lookAhead += AbstractInternalContentAssistParser.this.lookAheadAddOn;
                                }
                                FollowElement followElement = this.followElementFactory.createFollowElement(current, lookAhead);
                                AbstractInternalContentAssistParser.this.followElements.add(followElement);
                                this.lastAddedElement = current;
                            }
                        } else {
                            if (AbstractInternalContentAssistParser.this.marked) {
                                lookAhead += AbstractInternalContentAssistParser.this.lookAheadAddOn;
                            }
                            FollowElement followElement = this.followElementFactory.createFollowElement(current, lookAhead);
                            AbstractInternalContentAssistParser.this.followElements.add(followElement);
                            this.lastAddedElement = current;
                        }
                    }
                } else {
                    this.privateDelegate.announceEof(lookAhead);
                }
                this.wasMismatch |= AbstractInternalContentAssistParser.this.mismatch;
            }
        };
    }

    protected StreamAdapter createErrorRecoveryStrategy() {
        return new StreamAdapter(){
            private AbstractElement lastAddedElement;

            public void announceEof(int lookAhead) {
                AbstractElement current = AbstractInternalContentAssistParser.this.getCurrentGrammarElement();
                if (!(current == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                    if (AbstractInternalContentAssistParser.this.marked) {
                        lookAhead += AbstractInternalContentAssistParser.this.lookAheadAddOn;
                    }
                    AbstractInternalContentAssistParser.this.followElements.add(AbstractInternalContentAssistParser.this.createFollowElement(current, lookAhead));
                    this.lastAddedElement = current;
                }
            }
        };
    }

    protected StreamAdapter createNotErrorRecoveryStrategy() {
        return new StreamAdapter(){

            public void announceEof(int lookAhead) {
                AbstractElement current;
                if (!AbstractInternalContentAssistParser.this.errorRecovery && !AbstractInternalContentAssistParser.this.mismatch && (current = AbstractInternalContentAssistParser.this.getCurrentGrammarElement()) != null) {
                    if (AbstractInternalContentAssistParser.this.marked) {
                        lookAhead += AbstractInternalContentAssistParser.this.lookAheadAddOn;
                    }
                    AbstractInternalContentAssistParser.this.followElements.add(AbstractInternalContentAssistParser.this.createFollowElement(current, lookAhead));
                }
            }
        };
    }

    protected StreamAdapter createMismatchStrategy() {
        return new StreamAdapter(){
            private boolean wasErrorRecovery;
            {
                this.wasErrorRecovery = false;
            }

            public void announceEof(int lookAhead) {
                AbstractElement current;
                boolean bl = this.wasErrorRecovery = this.wasErrorRecovery || AbstractInternalContentAssistParser.this.errorRecovery;
                if (!this.wasErrorRecovery && !AbstractInternalContentAssistParser.this.mismatch && (current = AbstractInternalContentAssistParser.this.getCurrentGrammarElement()) != null) {
                    if (AbstractInternalContentAssistParser.this.marked) {
                        lookAhead += AbstractInternalContentAssistParser.this.lookAheadAddOn;
                    }
                    AbstractInternalContentAssistParser.this.followElements.add(AbstractInternalContentAssistParser.this.createFollowElement(current, lookAhead));
                }
            }
        };
    }

    public void beginResync() {
        this.resyncing = true;
    }

    public void endResync() {
        this.resyncing = false;
    }

    protected void mismatch(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        try {
            this.mismatch = true;
            super.mismatch(input, ttype, follow);
        }
        finally {
            this.mismatch = false;
        }
    }

    protected AbstractElement getCurrentGrammarElement() {
        int i = this.grammarElements.size() - 1;
        while (i >= 0) {
            EObject result = this.grammarElements.get(this.grammarElements.size() - 1);
            if (result instanceof AbstractElement) {
                return (AbstractElement)result;
            }
            --i;
        }
        return null;
    }

    protected FollowElement createFollowElement(AbstractElement current, int lookAhead) {
        return this.followElementFactory.createFollowElement(current, lookAhead);
    }

    public LookAheadTerminal createLookAheadTerminal(Token token) {
        Grammar grammar = this.getGrammar();
        String tokenName = this.getTokenNames()[token.getType()];
        if ((tokenName = this.getValueForTokenName(tokenName)).charAt(0) == '\'') {
            LookaheadKeyword result = new LookaheadKeyword();
            result.setKeyword(tokenName.substring(1, tokenName.length() - 1));
            result.setToken(token);
            return result;
        }
        LookAheadTerminalRuleCall result = new LookAheadTerminalRuleCall();
        result.setToken(token);
        String ruleName = tokenName.substring(5);
        if (this.terminalRules == null) {
            this.terminalRules = GrammarUtil.allTerminalRules((Grammar)grammar);
        }
        for (TerminalRule rule : this.terminalRules) {
            if (!rule.getName().equalsIgnoreCase(ruleName)) continue;
            result.setRule(rule);
            return result;
        }
        throw new IllegalArgumentException("tokenType " + token.getType() + " seems to be invalid.");
    }

    @Override
    public void announceEof(int lookAhead) {
        if (this.delegate == null) {
            this.selectEofStrategy();
        }
        if (this.grammarElements.isEmpty() || this.delegate == null) {
            return;
        }
        this.delegate.announceEof(lookAhead);
    }

    @Override
    public void announceConsume() {
        if (!this.marked) {
            this.localTrace.clear();
        } else {
            ++this.lookAheadAddOn;
        }
    }

    @Override
    public void announceRewind(int marker) {
        this.currentMarker = marker;
        this.lookAheadAddOn = this.currentMarker - this.firstMarker;
        if (this.firstMarker == this.currentMarker) {
            this.marked = false;
        }
    }

    @Override
    public void announceMark(int marker) {
        if (!this.marked) {
            this.marked = true;
            this.lookAheadAddOn = 0;
            this.currentMarker = marker;
            this.firstMarker = marker;
        } else {
            this.currentMarker = marker;
        }
    }

    public void beginDFAPrediction() {
        ++this.predictionLevel;
    }

    public void endDFAPrediction() {
        --this.predictionLevel;
    }

    public Set<FollowElement> getFollowElements() {
        return this.followElements;
    }

    public Map<Integer, String> getTokenDefMap() {
        String[] names = this.getTokenNames();
        HashMap result = Maps.newHashMapWithExpectedSize((int)(names.length - 4));
        int i = 4;
        while (i < names.length) {
            result.put(i, this.getValueForTokenName(names[i]));
            ++i;
        }
        return result;
    }

    protected String getValueForTokenName(String tokenName) {
        return tokenName;
    }

    public List<EObject> getGrammarElements() {
        return this.grammarElements;
    }

    public List<EObject> getLocalTrace() {
        return this.localTrace;
    }

    public RecoveryListener getRecoveryListener() {
        return this.recoveryListener;
    }

    public void setRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListener = recoveryListener;
    }

    public void setUnorderedGroupHelper(IUnorderedGroupHelper unorderedGroupHelper) {
        this.unorderedGroupHelper = unorderedGroupHelper;
        if (unorderedGroupHelper instanceof UnorderedGroupHelper) {
            ((UnorderedGroupHelper)unorderedGroupHelper).initializeWith((BaseRecognizer)this);
        }
    }

    public IUnorderedGroupHelper getUnorderedGroupHelper() {
        return this.unorderedGroupHelper;
    }

    protected void pushFollow(BitSet fset) {
        if (this._fsp + 1 >= this.following.length) {
            BitSet[] f = new BitSet[this.following.length * 2];
            System.arraycopy(this.following, 0, f, 0, this.following.length);
            this.following = f;
        }
        this.following[++this._fsp] = fset;
    }

    protected class DefaultFollowElementFactory
    implements IFollowElementFactory {
        protected DefaultFollowElementFactory() {
        }

        public FollowElement createFollowElement(AbstractElement current, int lookAhead) {
            FollowElement result = new FollowElement();
            result.setLookAhead(lookAhead);
            if (lookAhead != 1) {
                int from = AbstractInternalContentAssistParser.this.input.index();
                int to = AbstractInternalContentAssistParser.this.input.size();
                if (AbstractInternalContentAssistParser.this.marked) {
                    from = AbstractInternalContentAssistParser.this.firstMarker;
                }
                ArrayList lookAheadTerminals = Lists.newArrayListWithExpectedSize((int)(to - from));
                int tokenIndex = from;
                while (tokenIndex < to) {
                    Token token = AbstractInternalContentAssistParser.this.input.get(tokenIndex);
                    if (token != null) {
                        LookAheadTerminal lookAheadTerminal = AbstractInternalContentAssistParser.this.createLookAheadTerminal(token);
                        lookAheadTerminals.add(lookAheadTerminal);
                    }
                    ++tokenIndex;
                }
                result.setLookAheadTerminals(lookAheadTerminals);
                result.setLookAhead(lookAheadTerminals.size() + 1);
            }
            result.setGrammarElement(current);
            result.setTrace(Lists.newArrayList((Iterator)Iterators.filter(AbstractInternalContentAssistParser.this.grammarElements.iterator(), AbstractElement.class)));
            result.setLocalTrace(Lists.newArrayList((Iterator)Iterators.filter(AbstractInternalContentAssistParser.this.localTrace.iterator(), AbstractElement.class)));
            if (current instanceof UnorderedGroup && AbstractInternalContentAssistParser.this.indexToHandledElements != null) {
                int index = AbstractInternalContentAssistParser.this.grammarElements.lastIndexOf(current);
                result.setHandledUnorderedGroupElements(Lists.newArrayList((Iterator)Iterators.filter(AbstractInternalContentAssistParser.this.indexToHandledElements.get((Object)index).iterator(), AbstractElement.class)));
            }
            return result;
        }
    }

    static interface IFollowElementFactory {
        public FollowElement createFollowElement(AbstractElement var1, int var2);
    }

    public static interface RecoveryListener {
        public void beginErrorRecovery();

        public void endErrorRecovery();
    }

    protected abstract class StreamAdapter
    implements ObservableXtextTokenStream.StreamListener {
        protected StreamAdapter() {
        }

        public void announceConsume() {
            AbstractInternalContentAssistParser.this.announceConsume();
        }

        public void announceMark(int marker) {
            AbstractInternalContentAssistParser.this.announceMark(marker);
        }

        public void announceRewind(int marker) {
            AbstractInternalContentAssistParser.this.announceRewind(marker);
        }
    }
}

