/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.ui.label.StylerFactory;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ui.editor.syntaxcoloring.SemanticHighlightingConfiguration;

public class XtextLabelProvider
extends DefaultEObjectLabelProvider {
    private static final String UNKNOWN = "<unknown>";
    @Inject
    private SemanticHighlightingConfiguration semanticHighlightingConfiguration;
    @Inject
    private StylerFactory stylerFactory;

    @Inject
    public XtextLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    StyledString text(ParserRule parserRule) {
        if (GrammarUtil.isDatatypeRule((ParserRule)parserRule)) {
            StyledString.Styler xtextStyleAdapterStyler = this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.dataTypeRule());
            return new StyledString(parserRule.getName(), xtextStyleAdapterStyler);
        }
        return this.convertToStyledString(parserRule.getName());
    }

    StyledString text(EnumLiteralDeclaration object) {
        String literalName = this.getLiteralName(object);
        Keyword kw = object.getLiteral();
        String kwValue = kw == null ? "" : " = '" + kw.getValue() + "'";
        return new StyledString(String.valueOf(literalName) + kwValue, UNKNOWN.equalsIgnoreCase(literalName) ? this.stylerFactory.createStyler("ERROR_COLOR", null) : null);
    }

    String text(Grammar object) {
        return "grammar " + GrammarUtil.getLanguageId((Grammar)object);
    }

    String text(GeneratedMetamodel object) {
        return "generate " + object.getName() + (!Strings.isEmpty((String)object.getAlias()) ? " as " + object.getAlias() : "");
    }

    String text(ReferencedMetamodel object) {
        String label = "";
        if (object.getAlias() != null) {
            label = " " + object.getAlias();
        }
        if (object.getEPackage() != null) {
            label = label.length() == 0 ? " " + object.getEPackage().getName() : " " + object.getEPackage().getName() + " as" + label;
        }
        if (label.length() == 0) {
            label = " <unknown>";
        }
        return "import" + label;
    }

    String text(Assignment object) {
        StringBuffer label = new StringBuffer();
        label.append(object.getFeature()).append(" ").append(object.getOperator()).append(" ");
        AbstractElement terminal = object.getTerminal();
        if (terminal instanceof RuleCall) {
            RuleCall ruleCall = (RuleCall)terminal;
            String string = NodeUtil.getNodeAdapter((EObject)ruleCall).getParserNode().serialize();
            label.append(string);
        } else if (terminal instanceof Keyword) {
            Keyword keyword = (Keyword)terminal;
            String value = "'" + keyword.getValue() + "'";
            label.append(value);
        } else if (terminal instanceof CrossReference) {
            CrossReference crossReference = (CrossReference)terminal;
            label.append(this.getLabel(crossReference));
        } else {
            label.append("(..)");
        }
        String cardinality = object.getCardinality();
        label.append(cardinality != null ? cardinality : "");
        return label.toString();
    }

    String text(CrossReference object) {
        return this.getLabel(object);
    }

    String text(AbstractRule object) {
        return object.getName();
    }

    String text(Action object) {
        String classifierName = this.getClassifierName(object.getType());
        return "{" + classifierName + (object.getFeature() != null ? "." + object.getFeature() : "") + "}";
    }

    String text(Alternatives object) {
        return "|";
    }

    String text(UnorderedGroup object) {
        return "&";
    }

    String text(CharacterRange object) {
        return String.valueOf(object.getLeft().getValue()) + " .. " + object.getRight().getValue();
    }

    String text(NegatedToken object) {
        return "!";
    }

    String text(UntilToken object) {
        return "->";
    }

    String text(Wildcard object) {
        return "*";
    }

    String text(Keyword object) {
        return "'" + object.getValue() + "'";
    }

    String text(TypeRef object) {
        return "'" + object + "'";
    }

    private String getLiteralName(EnumLiteralDeclaration declaration) {
        if (declaration.getEnumLiteral() != null) {
            return declaration.getEnumLiteral().getName();
        }
        NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter((EObject)declaration);
        String literalName = UNKNOWN;
        if (nodeAdapter != null) {
            EList leafs = nodeAdapter.getParserNode().getLeafNodes();
            for (LeafNode leaf : leafs) {
                if (leaf.isHidden()) continue;
                literalName = leaf.getText();
                break;
            }
        }
        return literalName;
    }

    private String getLabel(RuleCall ruleCall) {
        if (ruleCall.getRule() != null) {
            return ruleCall.getRule().getName();
        }
        NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter((EObject)ruleCall);
        String ruleName = UNKNOWN;
        if (nodeAdapter != null) {
            EList leafs = nodeAdapter.getParserNode().getLeafNodes();
            for (LeafNode leaf : leafs) {
                if (leaf.isHidden()) continue;
                ruleName = leaf.getText();
                break;
            }
        }
        return ruleName;
    }

    private String getLabel(CrossReference ref) {
        TypeRef type = ref.getType();
        String typeName = this.getClassifierName(type);
        if (ref.getTerminal() instanceof RuleCall) {
            return "[" + typeName + "|" + this.getLabel((RuleCall)ref.getTerminal()) + "]";
        }
        return "[" + typeName + "|..]";
    }

    private String getClassifierName(TypeRef ref) {
        String classifierName = UNKNOWN;
        if (ref != null) {
            if (ref.getClassifier() != null) {
                classifierName = ref.getClassifier().getName();
            } else {
                NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter((EObject)ref);
                if (nodeAdapter != null) {
                    EList leafs = nodeAdapter.getParserNode().getLeafNodes();
                    int i = leafs.size() - 1;
                    while (i >= 0) {
                        if (!((LeafNode)leafs.get(i)).isHidden()) {
                            classifierName = ((LeafNode)leafs.get(i)).getText();
                            break;
                        }
                        --i;
                    }
                }
            }
        }
        return classifierName;
    }

    String image(Grammar grammar) {
        return "language.gif";
    }

    String image(GeneratedMetamodel metamodel) {
        return "export.gif";
    }

    String image(ReferencedMetamodel metamodel) {
        return "import.gif";
    }

    String image(AbstractRule rule) {
        return "rule.gif";
    }

    String image(RuleCall ruleCall) {
        return "rule.gif";
    }

    String image(Keyword keyword) {
        return "keyword.gif";
    }
}

