/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.samples.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.internal.qvt.oml.samples.QVTSamplesPlugin;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.SampleProject;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.SampleProjectsCreationOperation;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.wizard.SamplesWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class SamplesWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private SampleProject[] myProjects;
    private SamplesWizardPage myPage;
    private IConfigurationElement myConfigElement;
    private IWorkbench myWorkbench;
    private static final String README_TXT = "readme.txt";

    public SamplesWizard(SampleProject project) {
        this(new SampleProject[]{project});
    }

    public SamplesWizard(SampleProject[] projects) {
        this();
        this.setProjects(projects);
    }

    public SamplesWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void setProject(SampleProject project) {
        this.setProjects(new SampleProject[]{project});
    }

    public void addPages() {
        this.myPage = this.createPage(this.myProjects);
        this.addPage((IWizardPage)this.myPage);
    }

    protected SamplesWizardPage createPage(SampleProject[] projects) {
        return new SamplesWizardPage(projects);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.myConfigElement = config;
    }

    public boolean performFinish() {
        int i = 0;
        while (i < this.myProjects.length) {
            SampleProject project = this.myProjects[i];
            try {
                SampleProjectsCreationOperation op = new SampleProjectsCreationOperation(project, this.getShell());
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
                project.performActions(op.getCreatedProject());
                String fileToOpen = project.getFileToOpen();
                if (fileToOpen == null) {
                    fileToOpen = README_TXT;
                }
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.myConfigElement);
                BasicNewResourceWizard.selectAndReveal((IResource)op.getCreatedProject(), (IWorkbenchWindow)this.myWorkbench.getActiveWorkbenchWindow());
                IFile readme = op.getCreatedProject().getFile(fileToOpen);
                if (readme.exists()) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)readme);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                Throwable t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause() : e;
                String logMessage = NLS.bind((String)Messages.SamplesWizard_LogMessage, (Object)project.getName(), (Object)t);
                Status status = new Status(4, "org.eclipse.m2m.qvt.oml.samples", 1, logMessage, (Throwable)e);
                QVTSamplesPlugin.getDefault().getLog().log((IStatus)status);
                String message = NLS.bind((String)Messages.SamplesWizard_ErrorMessage, (Object)project.getName());
                String title = Messages.SamplesWizard_ErrorTitle;
                ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            }
            ++i;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.myWorkbench = workbench;
    }

    public void setProjects(SampleProject[] projects) {
        this.myProjects = projects;
    }
}

