/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTTemplate.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.DomainOperations;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.TemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.operations.AbstractQVTTemplateOperations;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.operations.QVTTemplateMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExpOperations
extends AbstractQVTTemplateOperations {
    public static TemplateExpOperations INSTANCE = new TemplateExpOperations();

    public boolean checkDomainExists(TemplateExp templateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Domain domain = this.getDomain(templateExp);
        if (domain != null) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)templateExp, context)};
        this.appendError(diagnostics, templateExp, QVTTemplateMessages._UI_TemplateExp_DomainDoesNotExist, messageSubstitutions);
        return false;
    }

    public boolean checkPatternExists(TemplateExp templateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern(templateExp);
        if (pattern != null) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)templateExp, context)};
        this.appendError(diagnostics, templateExp, QVTTemplateMessages._UI_TemplateExp_PatternDoesNotExist, messageSubstitutions);
        return false;
    }

    public boolean checkVariableIsBoundByPattern(TemplateExp templateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Pattern pattern = this.getPattern(templateExp);
        if (pattern == null) {
            return true;
        }
        Variable variable = templateExp.getBindsTo();
        if (variable == null) {
            return true;
        }
        if (pattern.getBindsTo().contains((Object)variable)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)pattern, context)};
        this.appendError(diagnostics, templateExp, QVTTemplateMessages._UI_TemplateExp_VariableIsNotBoundByPattern, messageSubstitutions);
        return false;
    }

    public boolean checkVariableTypeIsDeclaredByDomain(TemplateExp templateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Domain domain = this.getDomain(templateExp);
        if (domain == null) {
            return true;
        }
        Variable variable = templateExp.getBindsTo();
        if (variable == null) {
            return true;
        }
        EClassifier type = this.getTransitiveElementType(variable.getEType());
        if (type == null) {
            return true;
        }
        if (DomainOperations.INSTANCE.declaresType(domain, type)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)type, context), this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)domain, context)};
        this.appendError(diagnostics, templateExp, QVTTemplateMessages._UI_TemplateExp_VariableTypeIsNotDeclaredByDomain, messageSubstitutions);
        return false;
    }

    public boolean checkWhereIsBoolean(TemplateExp templateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCLExpression expression = templateExp.getWhere();
        if (expression == null) {
            return true;
        }
        EClassifier type = expression.getEType();
        if (type == null) {
            return true;
        }
        if (type == TemplateExpOperations.getBooleanType()) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)expression, context)};
        this.appendError(diagnostics, templateExp, QVTTemplateMessages._UI_TemplateExp_WhereIsNotBoolean, messageSubstitutions);
        return false;
    }

    public Domain getDomain(TemplateExp templateExp) {
        return (Domain)this.getAncestor((EObject)templateExp, Domain.class);
    }

    public Pattern getPattern(TemplateExp templateExp) {
        return (Pattern)this.getAncestor((EObject)templateExp, Pattern.class);
    }
}

