/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.ExpressionsPackage;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.BagType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.SetType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;

public class BagTypeImpl
extends CollectionTypeImpl
implements BagType {
    public static final String copyright = "";
    private static EList operations;
    private static EList iterators;

    protected BagTypeImpl() {
        this.setInstanceClass(Collection.class);
        this.setClassifierID(1);
    }

    protected BagTypeImpl(EClassifier elementType) {
        super(elementType);
        this.setInstanceClass(Collection.class);
        this.setClassifierID(1);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.elementType != null ? "Bag(" + this.elementType.getName() + ')' : "Bag(?)";
        }
        return super.getName();
    }

    public CollectionKind getKind() {
        return CollectionKind.BAG_LITERAL;
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        EClassifier elemType = this.getElementType();
        switch (opcode) {
            case 60: 
            case 61: {
                return Types.OCL_BOOLEAN;
            }
            case 157: {
                OCLExpression arg = (OCLExpression)args.get(0);
                CollectionType argType = (CollectionType)arg.getType();
                EClassifier argElementType = argType.getElementType();
                return TypesFactory.eINSTANCE.createBagType(TypeUtil.commonSuperType(elemType, argElementType));
            }
            case 155: {
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier eArgType = arg.getType();
                return TypesFactory.eINSTANCE.createBagType(TypeUtil.commonSuperType(elemType, eArgType));
            }
            case 156: {
                OCLExpression arg = (OCLExpression)args.get(0);
                CollectionType argType = (CollectionType)arg.getType();
                EClassifier argElementType = argType.getElementType();
                if (argType instanceof SetType) {
                    return TypesFactory.eINSTANCE.createSetType(TypeUtil.commonSuperType(elemType, argElementType));
                }
                return TypesFactory.eINSTANCE.createBagType(TypeUtil.commonSuperType(elemType, argElementType));
            }
            case 153: {
                return this;
            }
            case 140: {
                return Types.OCL_INTEGER;
            }
            case 154: {
                if (!(elemType instanceof CollectionType)) {
                    return this;
                }
                return TypesFactory.eINSTANCE.createBagType(((CollectionType)elemType).getElementType());
            }
            case 149: {
                return this;
            }
            case 151: {
                return TypesFactory.eINSTANCE.createSequenceType(elemType);
            }
            case 152: {
                return TypesFactory.eINSTANCE.createSetType(elemType);
            }
            case 150: {
                return TypesFactory.eINSTANCE.createOrderedSetType(elemType);
            }
            case 209: 
            case 210: {
                return this;
            }
            case 211: {
                return TypesFactory.eINSTANCE.createSequenceType(this.getElementType());
            }
            case 207: {
                return TypesFactory.eINSTANCE.createBagType(AnyTypeImpl.OCL_T2);
            }
        }
        return super.getResultTypeFor(ownerType, opcode, args);
    }

    protected static EList createOperations() {
        BasicEList result = new BasicEList();
        result.addAll((Collection)CollectionTypeImpl.createOperations());
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "=", (EClassifier)OCL_BAG, "bag"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "<>", (EClassifier)OCL_BAG, "bag"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_BAG, "union", (EClassifier)OCL_BAG, "bag"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_BAG, "union", (EClassifier)OCL_SET, "set"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_BAG, "intersection", (EClassifier)OCL_BAG, "bag"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "intersection", (EClassifier)OCL_SET, "set"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_BAG, "including", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_BAG, "excluding", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)new BagTypeImpl(AnyTypeImpl.OCL_T2), "flatten"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_BAG, "asBag"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_SET, "asSet"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_SEQUENCE, "asSequence"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_ORDERED_SET, "asOrderedSet"));
        return result;
    }

    protected static EList createIterators() {
        BasicEList result = new BasicEList();
        result.addAll((Collection)CollectionTypeImpl.createIterators());
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_BAG, "select", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_BAG, "reject", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_SEQUENCE, "sortedBy", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)TypesFactory.eINSTANCE.createBagType(AnyTypeImpl.OCL_T2), "collectNested", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        return result;
    }

    public EList getOperations() {
        if (operations == null) {
            operations = BagTypeImpl.createOperations();
        }
        return operations;
    }

    public EList getIterators() {
        if (iterators == null) {
            iterators = BagTypeImpl.createIterators();
        }
        return iterators;
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.BAG_TYPE;
    }
}

