/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parameter;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.diagram.common.parameter.EditParametersTableConstants;
import org.eclipse.uml2.diagram.common.parameter.EditPropertyParametersCommand;
import org.eclipse.uml2.diagram.common.parameter.ParametersCellModifier;
import org.eclipse.uml2.diagram.common.parameter.celleditors.BooleanCellEditor;
import org.eclipse.uml2.diagram.common.parameter.celleditors.DirectionCellEditor;
import org.eclipse.uml2.diagram.common.parameter.celleditors.PositiveIntegerCellEditor;
import org.eclipse.uml2.diagram.common.parameter.celleditors.TypeDialogCellEditor;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class EditPropertyParametersDialog
extends TrayDialog {
    private static final int TABLE_HEIGHT = 100;
    private static final int ADD_ID = 1025;
    private static final int REMOVE_ID = 1026;
    private static final int UP_ID = 1027;
    private static final int DOWN_ID = 1028;
    private TableViewer myTableViewer;
    private final Operation myOperation;
    private final Operation myOldOperation;
    public static final Type NULL_TYPE = UMLFactory.eINSTANCE.createClass();
    private final AdapterFactory myAdapterFactory;

    public EditPropertyParametersDialog(Shell parentShell, Operation operation, AdapterFactory af) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myAdapterFactory = af;
        this.myOldOperation = operation;
        this.myOperation = (Operation)EcoreUtil.copy((EObject)operation);
        this.setHelpAvailable(false);
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonSection = super.createButtonBar(parent);
        ((GridData)buttonSection.getLayoutData()).grabExcessVerticalSpace = false;
        return buttonSection;
    }

    protected void okPressed() {
        try {
            try {
                new EditPropertyParametersCommand(this.myOldOperation, this.myOperation).execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                super.okPressed();
            }
        }
        finally {
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Select Parameters for Operation");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.createAddRemoveButtonBar(parentComposite);
        Table table = this.buildTable(parentComposite);
        GridData tableLayoutData = new GridData(4, 4, true, true);
        tableLayoutData.heightHint = 100;
        table.setLayoutData((Object)tableLayoutData);
        this.myTableViewer = this.createTableViewer(table);
        this.myTableViewer.setInput((Object)this.myOperation);
        return parentComposite;
    }

    private Table buildTable(Composite parent) {
        Table table = new Table(parent, 101124);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn name = new TableColumn(table, 16384, 0);
        name.setText("name");
        name.setWidth(70);
        TableColumn types = new TableColumn(table, 16384, 1);
        types.setText("types");
        types.setWidth(70);
        TableColumn direction = new TableColumn(table, 16384, 2);
        direction.setText("direction");
        direction.setWidth(70);
        TableColumn multiplicity = new TableColumn(table, 16384, 3);
        multiplicity.setText("multiplicity");
        multiplicity.setWidth(70);
        TableColumn defaultValue = new TableColumn(table, 16384, 4);
        defaultValue.setText("defaultValue");
        defaultValue.setWidth(70);
        TableColumn isOrdered = new TableColumn(table, 16384, 5);
        isOrdered.setText("isOrdered");
        isOrdered.setWidth(70);
        TableColumn isUnique = new TableColumn(table, 16384, 6);
        isUnique.setText("isUnique");
        isUnique.setWidth(70);
        return table;
    }

    private Control createAddRemoveButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000008, 1, false, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createAddButton(composite);
        this.createRemoveButton(composite);
        this.createUpButton(composite);
        this.createDownButton(composite);
        return composite;
    }

    private void createRemoveButton(Composite composite) {
        Button removeButton = this.createButton(composite, 1026, "Remove", false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EditPropertyParametersDialog.this.myTableViewer.getSelection();
                Object selected = selection.getFirstElement();
                EditPropertyParametersDialog.this.myOperation.getOwnedParameters().remove(selected);
                EditPropertyParametersDialog.this.myTableViewer.refresh();
                EditPropertyParametersDialog.this.myTableViewer.getControl().setFocus();
            }
        });
    }

    private void createAddButton(Composite composite) {
        Button addButton = this.createButton(composite, 1025, "Add", false);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Parameter newParameter = UMLFactory.eINSTANCE.createParameter();
                newParameter.setName("Parameter");
                newParameter.createDefaultValue(null, null, UMLPackage.eINSTANCE.getLiteralString());
                EditPropertyParametersDialog.this.myOperation.getOwnedParameters().add((Object)newParameter);
                EditPropertyParametersDialog.this.myTableViewer.refresh();
                EditPropertyParametersDialog.this.myTableViewer.getControl().setFocus();
                EditPropertyParametersDialog.this.myTableViewer.setSelection((ISelection)new StructuredSelection((Object)newParameter));
            }
        });
    }

    private void createUpButton(Composite composite) {
        Button addButton = this.createButton(composite, 1027, "Up", false);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EditPropertyParametersDialog.this.myTableViewer.getSelection();
                Parameter selected = (Parameter)selection.getFirstElement();
                if (selected == null) {
                    return;
                }
                int index = EditPropertyParametersDialog.this.myOperation.getOwnedParameters().indexOf((Object)selected);
                if (index - 1 < 0) {
                    return;
                }
                EditPropertyParametersDialog.this.myOperation.getOwnedParameters().remove((Object)selected);
                EditPropertyParametersDialog.this.myOperation.getOwnedParameters().add(index - 1, (Object)selected);
                EditPropertyParametersDialog.this.myTableViewer.refresh();
                EditPropertyParametersDialog.this.myTableViewer.getControl().setFocus();
            }
        });
    }

    private void createDownButton(Composite composite) {
        Button addButton = this.createButton(composite, 1028, "Down", false);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EditPropertyParametersDialog.this.myTableViewer.getSelection();
                Parameter selected = (Parameter)selection.getFirstElement();
                if (selected == null) {
                    return;
                }
                int index = EditPropertyParametersDialog.this.myOperation.getOwnedParameters().indexOf((Object)selected);
                if (index + 1 > EditPropertyParametersDialog.this.myOperation.getOwnedParameters().size() - 1) {
                    return;
                }
                EditPropertyParametersDialog.this.myOperation.getOwnedParameters().remove((Object)selected);
                EditPropertyParametersDialog.this.myOperation.getOwnedParameters().add(index + 1, (Object)selected);
                EditPropertyParametersDialog.this.myTableViewer.refresh();
                EditPropertyParametersDialog.this.myTableViewer.getControl().setFocus();
            }
        });
    }

    private TableViewer createTableViewer(Table table) {
        final TableViewer viewer = new TableViewer(table);
        viewer.setColumnProperties(EditParametersTableConstants.COLUMN_PROPERTIES);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new ParametersContentProvider());
        this.addCellEditors(table, viewer);
        viewer.setCellModifier((ICellModifier)new ParametersCellModifier(){

            public void updateViewer(Parameter parameter, String property) {
                viewer.update((Object)parameter, new String[]{property});
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ParameterLabelProvider());
        return viewer;
    }

    private void addCellEditors(Table table, TableViewer viewer) {
        TextCellEditor name = new TextCellEditor((Composite)table);
        TypeDialogCellEditor types = new TypeDialogCellEditor((Composite)table, this.myAdapterFactory, (EObject)this.myOldOperation, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
        DirectionCellEditor direction = new DirectionCellEditor((Composite)table);
        PositiveIntegerCellEditor multiplicity = new PositiveIntegerCellEditor((Composite)table);
        TextCellEditor defaultValue = new TextCellEditor((Composite)table);
        BooleanCellEditor isOrdered = new BooleanCellEditor((Composite)table);
        BooleanCellEditor isUnique = new BooleanCellEditor((Composite)table);
        CellEditor[] editors = new CellEditor[]{name, types, direction, multiplicity, defaultValue, isOrdered, isUnique};
        viewer.setCellEditors(editors);
    }

    private static class ParameterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String EMPTY_VALUE = "";
        private static final String UNDEFINED_VALUE = "-";

        private ParameterLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Parameter p = (Parameter)element;
            switch (columnIndex) {
                case 0: {
                    return p.getName() != null ? p.getName() : EMPTY_VALUE;
                }
                case 1: {
                    return p.getType() != null ? p.getType().getName() : EMPTY_VALUE;
                }
                case 3: {
                    return Integer.toString(p.getUpper());
                }
                case 2: {
                    return p.getDirection().toString();
                }
                case 4: {
                    ValueSpecification defValue = p.getDefaultValue();
                    if (defValue == null) {
                        return EMPTY_VALUE;
                    }
                    return (String)new ValueSpecificationToStringConverter().doSwitch((EObject)defValue);
                }
                case 5: {
                    return Boolean.toString(p.isOrdered());
                }
                case 6: {
                    return Boolean.toString(p.isUnique());
                }
            }
            return UNDEFINED_VALUE;
        }
    }

    private class ParametersContentProvider
    implements IStructuredContentProvider {
        private ParametersContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Operation)inputElement).getOwnedParameters().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetValueToSpecification
    extends UMLSwitch<ValueSpecification> {
        private final String myNewValue;

        public SetValueToSpecification(String value) {
            this.myNewValue = value;
        }

        public ValueSpecification caseLiteralString(LiteralString object) {
            object.setValue(this.myNewValue);
            return object;
        }

        public ValueSpecification caseLiteralInteger(LiteralInteger object) {
            Integer intValue = Integer.parseInt(this.myNewValue);
            object.setValue(intValue.intValue());
            return object;
        }

        public ValueSpecification caseExpression(Expression object) {
            object.setSymbol(this.myNewValue);
            return object;
        }

        public ValueSpecification defaultCase(EObject object) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueSpecificationToStringConverter
    extends UMLSwitch<String> {
        private static final String EMPTY_VALUE = "";

        public String caseLiteralString(LiteralString object) {
            String value = object.getValue();
            return value != null ? value : EMPTY_VALUE;
        }

        public String caseLiteralInteger(LiteralInteger object) {
            String value = Integer.toString(object.getValue());
            return value != null ? value : EMPTY_VALUE;
        }

        public String caseExpression(Expression object) {
            String value = object.getSymbol();
            return value != null ? value : EMPTY_VALUE;
        }

        public String defaultCase(EObject object) {
            return EMPTY_VALUE;
        }
    }
}

