/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.async.SyncModelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplySynchronizationCommand
extends AbstractTransactionalCommand {
    private final SyncModelNode mySyncRoot;
    private final ArrayList<View> myAddedTopLevelViews = new ArrayList();

    public ApplySynchronizationCommand(SyncModelNode syncRoot) {
        super(syncRoot.getContext().getDomain(), "Applying synchronization changes", ApplySynchronizationCommand.getWorkspaceFiles((EObject)syncRoot.getDiagramView()));
        assert (syncRoot.getDiagramView() != null);
        this.mySyncRoot = syncRoot;
    }

    public ArrayList<View> getAddedTopLevelViews() {
        return this.myAddedTopLevelViews;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        LinkedList<SyncModelNode> queue = new LinkedList<SyncModelNode>();
        queue.add(this.mySyncRoot);
        while (!queue.isEmpty()) {
            SyncModelNode next = (SyncModelNode)queue.removeFirst();
            this.syncNode(next, queue);
        }
        return CommandResult.newOKCommandResult(this.myAddedTopLevelViews);
    }

    private void syncNode(SyncModelNode node, List<SyncModelNode> queue) {
        View diagramView = node.getDiagramView();
        assert (diagramView != null);
        if (!node.isRoot() && !node.isChecked()) {
            this.removeView(diagramView);
            return;
        }
        node.applyCanonicalStyle();
        for (SyncModelNode nextSyncChild : node.getChildren()) {
            if (nextSyncChild.isChecked()) {
                this.forceHasDiagramView(nextSyncChild);
                queue.add(nextSyncChild);
                continue;
            }
            if (nextSyncChild.getDiagramView() == null) continue;
            queue.add(nextSyncChild);
        }
    }

    private void forceHasDiagramView(SyncModelNode node) {
        if (node.getDiagramView() != null) {
            return;
        }
        SyncModelNode parent = node.getParent();
        View diagramParent = parent.getDiagramView();
        if (node.isInCompartment()) {
            View syncCompartment = node.getSyncModelCompartment();
            View diagramCompartment = SyncModelNode.findCounterpart(syncCompartment, node.getParent().getDiagramView());
            if (diagramCompartment == null) {
                throw new IllegalStateException("Can't find diagram compartment for sync-model compartment: " + syncCompartment + ", sync-model parent: " + node.getSyncModelView() + ", diagram parent: " + node.getDiagramView());
            }
            diagramParent = diagramCompartment;
        }
        Node copy = ViewService.createNode((View)diagramParent, (EObject)node.getSyncModelView().getElement(), (String)node.getSyncModelView().getType(), (PreferencesHint)this.mySyncRoot.getContext().getPreferencesHint());
        assert (copy != null);
        if (diagramParent instanceof Diagram) {
            this.myAddedTopLevelViews.add((View)copy);
        }
        node.associateWithDiagramView((View)copy);
        node.applyCanonicalStyle();
    }

    private void removeView(View view) {
        ViewUtil.destroy((View)view);
    }
}

