/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StatusUtils {
    public static String getLocalizedMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            return ce.getStatus().getMessage();
        }
        return "An unexpected exception was thrown.";
    }

    public static Throwable getCause(Throwable exception) {
        Throwable cause = null;
        if (exception != null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                cause = ce.getStatus().getException();
            } else {
                try {
                    Method causeMethod = exception.getClass().getMethod("getCause", new Class[0]);
                    Object o = causeMethod.invoke((Object)exception, new Object[0]);
                    if (o instanceof Throwable) {
                        cause = (Throwable)o;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (cause == null) {
                cause = exception;
            }
        }
        return cause;
    }

    public static IStatus newStatus(String pluginId, int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().length() == 0) {
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, pluginId, severity, statusMessage, StatusUtils.getCause(exception));
    }
}

