/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.data.command;

import ca.odell.glazedlists.EventList;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.command.RowObjectDeleteCommand;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsLockHelper;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowObjectDeleteEvent;

public class GlazedListsRowObjectDeleteCommandHandler<T>
implements ILayerCommandHandler<RowObjectDeleteCommand> {
    protected EventList<T> bodyData;

    public GlazedListsRowObjectDeleteCommandHandler(EventList<T> bodyData) {
        this.bodyData = bodyData;
    }

    public boolean doCommand(ILayer targetLayer, RowObjectDeleteCommand command) {
        int[] indexes = new int[command.getObjectsToDelete().size()];
        TreeMap deleted = new TreeMap();
        GlazedListsLockHelper.performWriteOperation(this.bodyData.getReadWriteLock(), () -> {
            int idx = 0;
            for (Object rowObject : command.getObjectsToDelete()) {
                int index = this.bodyData.indexOf(rowObject);
                deleted.put(index, rowObject);
                nArray[idx] = index;
                ++idx;
            }
            this.bodyData.removeAll((Collection)command.getObjectsToDelete());
        });
        targetLayer.fireLayerEvent((ILayerEvent)new RowObjectDeleteEvent(targetLayer, deleted));
        return true;
    }

    public Class<RowObjectDeleteCommand> getCommandClass() {
        return RowObjectDeleteCommand.class;
    }
}

