/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.views.modelexplorer.matching.HashCodeCalculus;
import org.eclipse.papyrus.views.modelexplorer.matching.IMatchingItem;
import org.eclipse.papyrus.views.modelexplorer.matching.IReferencable;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.navigator.dnd.NavigatorDnDService;
import org.eclipse.ui.navigator.CommonDragAdapter;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonViewer;

public class CustomCommonViewer
extends CommonViewer {
    protected CommonDropAdapter dropAdapter;

    public CustomCommonViewer(String aViewerId, Composite aParent, int aStyle) {
        super(aViewerId, aParent, aStyle);
        this.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                if (element instanceof EObjectTreeElement) {
                    EObject eObject = ((EObjectTreeElement)element).getEObject();
                    return HashCodeCalculus.getHashCode(eObject);
                }
                if (element instanceof EReferenceTreeElement) {
                    EObject eParent = ((EReferenceTreeElement)element).getParent().getEObject();
                    EReference eref = ((EReferenceTreeElement)element).getEReference();
                    return HashCodeCalculus.getHashCode(eParent, eref);
                }
                if (element instanceof IReferencable) {
                    IReferencable ref = (IReferencable)element;
                    return ref.getElementBehind().hashCode();
                }
                if (element instanceof IMatchingItem) {
                    IMatchingItem matchItem = (IMatchingItem)element;
                    return matchItem.matchingItemHashcode();
                }
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof IMatchingItem) {
                    return ((IMatchingItem)a).matchingItemEquals(b);
                }
                if (b != null) {
                    return b.equals(a);
                }
                return false;
            }
        });
    }

    protected void initDragAndDrop() {
        this.dropAdapter = null;
        int operations = 7;
        CommonDragAdapter dragAdapter = this.createDragAdapter();
        this.addDragSupport(operations, dragAdapter.getSupportedDragTransfers(), (DragSourceListener)dragAdapter);
        this.dropAdapter = this.createDropAdapter();
        this.addDropSupport(operations, this.dropAdapter.getSupportedDropTransfers(), (DropTargetListener)this.dropAdapter);
        NavigatorDnDService dnd = (NavigatorDnDService)this.getNavigatorContentService().getDnDService();
        dnd.setDropAdaptor(this.dropAdapter);
    }

    public CommonDropAdapter getDropAdapter() {
        return this.dropAdapter;
    }

    protected ColumnViewerEditor createViewerEditor() {
        FocusCellHighlighter fch = new FocusCellHighlighter((ColumnViewer)this){};
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager((TreeViewer)this, fch);
        TreeViewerEditor.create((TreeViewer)this, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 1 && event.keyCode == 0x100000B || event.eventType == 4;
            }
        }, (int)32);
        ColumnViewerEditor editor = this.getColumnViewerEditor();
        return editor;
    }

    public void dispose() {
        this.setColumnViewerEditor(super.createViewerEditor());
        super.dispose();
    }
}

