/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder.SequenceDiagramEndReorderHelper;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder.SequenceDiagramSemanticReorderHelper;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class SequenceDiagramReorderElementSwitch
extends UMLSwitch<Element> {
    private final SequenceDiagramOrderServices orderService = new SequenceDiagramOrderServices();
    private final SequenceDiagramUMLHelper umlHelper = new SequenceDiagramUMLHelper();
    private final SequenceDiagramEndReorderHelper endReorderHelper = new SequenceDiagramEndReorderHelper();
    private final SequenceDiagramSemanticReorderHelper elementsReorder = new SequenceDiagramSemanticReorderHelper();
    private final EAnnotation startingEndPredecessor;
    private final EAnnotation finishingEndPredecessor;
    private Interaction rootInteraction;
    private List<EAnnotation> ends;
    private Element current;
    private Set<Lifeline> modifiedLifelines;

    public SequenceDiagramReorderElementSwitch(EAnnotation startingEndPredecessor, EAnnotation finishingEndPredecessor) {
        this.startingEndPredecessor = startingEndPredecessor;
        this.finishingEndPredecessor = finishingEndPredecessor;
    }

    public Element doSwitch(EObject eObject) {
        Element element = (Element)eObject;
        this.rootInteraction = this.umlHelper.getOwningInteraction(element);
        this.ends = this.orderService.getEndsOrdering(this.rootInteraction);
        this.current = element;
        this.modifiedLifelines = new HashSet<Lifeline>();
        super.doSwitch(eObject);
        this.elementsReorder.alignLifelinesCoverage(this.rootInteraction, this.modifiedLifelines);
        return null;
    }

    public Element caseCombinedFragment(CombinedFragment combinedFragment) {
        this.reorderBothEnds();
        this.reorderInFragments((NamedElement)combinedFragment, this.startingEndPredecessor);
        if (this.startingEndPredecessor != this.finishingEndPredecessor && combinedFragment.getOperands().size() == 1) {
            InteractionOperand operand = (InteractionOperand)combinedFragment.getOperands().get(0);
            int eventStart = this.ends.indexOf(this.orderService.getStartingEnd((Element)operand));
            int eventFinish = this.ends.indexOf(this.orderService.getFinishingEnd((Element)operand));
            Element container = combinedFragment.getOwner();
            for (EAnnotation end : this.ends.subList(eventStart + 1, eventFinish)) {
                InteractionFragment endFragment;
                NamedElement event = this.orderService.getEndFragment(end);
                if (!(event instanceof InteractionFragment) || !this.umlHelper.isCoveringASubsetOf((NamedElement)(endFragment = (InteractionFragment)event), (NamedElement)combinedFragment) || event.getOwner() != container) continue;
                InteractionFragment lastElementInOperand = null;
                EList fragments = operand.getFragments();
                if (!fragments.isEmpty()) {
                    lastElementInOperand = (InteractionFragment)fragments.get(fragments.size() - 1);
                }
                this.elementsReorder.addInteractionFragment((NamedElement)endFragment, (Element)operand, UMLPackage.eINSTANCE.getInteractionOperand_Fragment(), (NamedElement)lastElementInOperand);
                this.modifiedLifelines.addAll((Collection<Lifeline>)endFragment.getCovereds());
            }
        }
        return combinedFragment;
    }

    public Element caseExecutionSpecification(ExecutionSpecification execution) {
        this.reorderBothEnds();
        this.reorderInFragments((NamedElement)execution.getStart(), this.startingEndPredecessor);
        this.reorderInFragments((NamedElement)execution.getFinish(), this.getApplicableFinishEnd());
        return execution;
    }

    public Element caseGate(Gate gate) {
        this.reorderBothEnds();
        this.reorderInFragments((NamedElement)gate, this.startingEndPredecessor);
        return gate;
    }

    public Element caseInteractionOperand(InteractionOperand interactionOperand) {
        EAnnotation start = this.orderService.getStartingEnd((Element)interactionOperand);
        this.ends.remove(start);
        this.ends.add(this.ends.indexOf(this.startingEndPredecessor) + 1, start);
        this.reorderInFragments((NamedElement)interactionOperand, this.startingEndPredecessor);
        return interactionOperand;
    }

    public Element caseInteractionUse(InteractionUse interactionUse) {
        this.reorderBothEnds();
        this.reorderInFragments((NamedElement)interactionUse, this.startingEndPredecessor);
        return interactionUse;
    }

    public Element caseMessage(Message message) {
        MessageEnd semanticStart = message.getSendEvent();
        MessageEnd semanticFinish = message.getReceiveEvent();
        if (semanticFinish != null && semanticStart != null) {
            this.reorderBothEnds();
            if (!(semanticStart instanceof Gate)) {
                this.reorderInFragments((NamedElement)semanticStart, this.startingEndPredecessor);
            }
            if (!(semanticFinish instanceof Gate)) {
                this.reorderInFragments((NamedElement)semanticFinish, this.getApplicableFinishEnd());
            }
        } else if (semanticFinish == null) {
            this.reorderEnd(true);
            if (!(semanticStart instanceof Gate)) {
                this.reorderInFragments((NamedElement)semanticStart, this.startingEndPredecessor);
            }
        } else if (semanticStart == null) {
            this.reorderEnd(false);
            if (!(semanticFinish instanceof Gate)) {
                this.reorderInFragments((NamedElement)semanticFinish, this.getApplicableFinishEnd());
            }
        }
        return message;
    }

    public Element caseStateInvariant(StateInvariant stateInvariant) {
        this.reorderBothEnds();
        this.reorderInFragments((NamedElement)stateInvariant, this.startingEndPredecessor);
        return stateInvariant;
    }

    private EAnnotation getApplicableFinishEnd() {
        EAnnotation start = this.orderService.getStartingEnd(this.current);
        int startIndex = this.ends.indexOf(start);
        EAnnotation before = this.finishingEndPredecessor;
        int beforeFinishIndex = this.ends.indexOf(before);
        while (startIndex < beforeFinishIndex && this.isVirtualEnd(before)) {
            before = this.ends.get(--beforeFinishIndex);
        }
        if (beforeFinishIndex <= startIndex) {
            return start;
        }
        return before;
    }

    private boolean isVirtualEnd(EAnnotation end) {
        boolean result = false;
        if (this.orderService.getEndFragment(end) instanceof StateInvariant) {
            result = this.orderService.isFinishingEnd(end) && !(this.current instanceof StateInvariant);
        }
        return result;
    }

    private void reorderInFragments(NamedElement event, EAnnotation endPredecessor) {
        this.elementsReorder.reorderElements(event, endPredecessor, this.ends);
        if (event instanceof InteractionFragment) {
            InteractionFragment fragment = (InteractionFragment)event;
            this.modifiedLifelines.addAll((Collection<Lifeline>)fragment.getCovereds());
        }
    }

    private void reorderBothEnds() {
        this.endReorderHelper.applyBothEndsReorder(this.current, this.startingEndPredecessor, this.finishingEndPredecessor, this.ends);
    }

    private void reorderEnd(boolean start) {
        EAnnotation predecessor = this.startingEndPredecessor;
        if (!start) {
            predecessor = this.finishingEndPredecessor;
        }
        this.endReorderHelper.applySingleEndReorder(this.current, start, predecessor, this.ends);
    }
}

