/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.transformations;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.papyrus.designer.components.FCM.CodeGenOptions;
import org.eclipse.papyrus.designer.components.FCM.PortKind;
import org.eclipse.papyrus.designer.components.transformation.extensions.IOOTrafo;
import org.eclipse.papyrus.designer.components.transformation.extensions.OOTrafo;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.transformations.ApplyRecursive;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ExecuteOOTrafo
implements IM2MTrafoCDP {
    public static String getOOTransformationFromPackage(Package pkg) {
        CodeGenOptions codeGenOpt = (CodeGenOptions)UMLUtil.getStereotypeApplication((Element)pkg, CodeGenOptions.class);
        if (codeGenOpt != null && codeGenOpt.getCompToOOmapping() != null) {
            return codeGenOpt.getCompToOOmapping().getBase_Class().getName();
        }
        return null;
    }

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        String ooTransformation = ExecuteOOTrafo.getOOTransformationFromPackage(TransformationContext.current.modelRoot);
        if (ooTransformation == null) {
            ooTransformation = "StaticCpp";
        }
        IOOTrafo ooTrafo = OOTrafo.getOOTrafo((String)ooTransformation);
        ooTrafo.init(TransformationContext.current.copier, null);
        ApplyRecursive add = new ApplyRecursive(trafo, (IM2MTrafoElem)new AddOOElements(ooTrafo));
        ApplyRecursive remove = new ApplyRecursive(trafo, (IM2MTrafoElem)new RemoveComponentElements());
        add.applyRecursive(TransformationContext.current.modelRoot);
        remove.applyRecursive(TransformationContext.current.modelRoot);
    }

    public class AddOOElements
    implements IM2MTrafoElem {
        IOOTrafo ooTrafo;

        public AddOOElements(IOOTrafo ooTrafo) {
            this.ooTrafo = ooTrafo;
        }

        public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
            Class implementation;
            if (element instanceof Class && !StereotypeUtil.isApplied((Element)(implementation = (Class)element), PortKind.class)) {
                this.ooTrafo.addPortOperations(implementation);
                this.ooTrafo.addConnectionOperation(implementation);
                this.ooTrafo.transformParts(implementation);
            }
        }
    }

    public class RemoveComponentElements
    implements IM2MTrafoElem {
        public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
            if (element instanceof StructuredClassifier) {
                this.removeConnectors((StructuredClassifier)element);
            }
            if (element instanceof EncapsulatedClassifier) {
                this.removePorts((EncapsulatedClassifier)element);
            }
        }

        public void removeConnectors(StructuredClassifier implementation) {
            BasicEList connectors = new BasicEList();
            connectors.addAll((Collection)implementation.getOwnedConnectors());
            for (Connector connector : connectors) {
                connector.destroy();
            }
        }

        public void removePorts(EncapsulatedClassifier implementation) {
            BasicEList portListCopy = new BasicEList();
            portListCopy.addAll((Collection)implementation.getOwnedPorts());
            for (Port port : portListCopy) {
                port.destroy();
            }
        }
    }
}

