/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.monitoring.sm.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.designer.monitoring.sm.animation.Animator;
import org.eclipse.papyrus.designer.monitoring.sm.data.MessageQueue;
import org.eclipse.papyrus.designer.monitoring.sm.data.StateMachineModel;
import org.eclipse.papyrus.designer.monitoring.sm.runnable.AnimatorMessageQueueReader;
import org.eclipse.papyrus.designer.monitoring.sm.runnable.DatagramSocketReader;
import org.eclipse.papyrus.designer.monitoring.sm.runnable.MessageQueueDispatcher;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.StateMachine;

public class StartMonitoringHandler
extends CmdHandler {
    public static boolean monitoring = false;
    public static DatagramSocketReader socketReader;
    public static Map<String, MessageQueue> animatorMessageQueues;
    public static List<AnimatorMessageQueueReader> animatorMessageQueueReaders;
    public static MessageQueueDispatcher messageQueueDispatcher;

    public boolean isEnabled() {
        this.updateSelectedEObject();
        return this.selectedEObject instanceof Element;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MessageQueue socketDataMessageQueue;
        if (!(this.selectedEObject instanceof Element)) {
            return null;
        }
        if (!monitoring && (socketReader = new DatagramSocketReader(socketDataMessageQueue = new MessageQueue())).getSocket() != null) {
            StateMachineModel stateMachineModel = new StateMachineModel(((Element)this.selectedEObject).getModel());
            Animator animator = new Animator(stateMachineModel);
            animatorMessageQueues = new HashMap<String, MessageQueue>();
            animatorMessageQueueReaders = new ArrayList<AnimatorMessageQueueReader>();
            for (StateMachine stateMachine : stateMachineModel.getStateMachines()) {
                if (stateMachine.getQualifiedName() == null || stateMachine.getQualifiedName().isEmpty()) continue;
                MessageQueue animatorMessageQueue = new MessageQueue();
                AnimatorMessageQueueReader animatorMessageQueueReader = new AnimatorMessageQueueReader(animatorMessageQueue, animator);
                animatorMessageQueues.put(stateMachine.getQualifiedName(), animatorMessageQueue);
                animatorMessageQueueReaders.add(animatorMessageQueueReader);
            }
            messageQueueDispatcher = new MessageQueueDispatcher(socketDataMessageQueue, animatorMessageQueues, stateMachineModel);
            monitoring = true;
            for (AnimatorMessageQueueReader animatorMessageQueueReader : animatorMessageQueueReaders) {
                Thread animatorMessageQueueReaderThread = new Thread(animatorMessageQueueReader);
                animatorMessageQueueReaderThread.start();
            }
            Thread messageQueueDispatcherThread = new Thread(messageQueueDispatcher);
            messageQueueDispatcherThread.start();
            Thread socketReaderThread = new Thread(socketReader);
            socketReaderThread.start();
        }
        return null;
    }
}

