/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

public class LibraryUtils {
    public static Element getContent(Resource resource) {
        EList contentObj = resource.getContents();
        if (contentObj.size() > 0 && contentObj.get(0) instanceof Element) {
            return (Element)contentObj.get(0);
        }
        return null;
    }

    public static Element getContent(URI uri, ResourceSet rs) {
        Resource resource = rs.getResource(uri, true);
        return LibraryUtils.getContent(resource);
    }

    public static PackageImport getModelLibraryImportFromURI(URI uri, ResourceSet resourceSet) {
        Element root = LibraryUtils.getContent(uri, resourceSet);
        if (root instanceof Package) {
            Package libToImport = (Package)root;
            PackageImport modelLibImport = UMLFactory.eINSTANCE.createPackageImport();
            modelLibImport.setImportedPackage(libToImport);
            return modelLibImport;
        }
        return null;
    }
}

