/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.types.advice;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.AssemblyPart;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DelegationEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateRelationshipRequest) {
            return this.approveCreateRelationshipRequest((CreateRelationshipRequest)context.getEditCommandRequest());
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateRelationshipRequest(CreateRelationshipRequest request) {
        EObject source = request.getSource();
        EObject target = request.getTarget();
        if (source instanceof Port && target instanceof Port) {
            View sourceView = RequestParameterUtils.getSourceView((IEditCommandRequest)request);
            View targetView = RequestParameterUtils.getTargetView((IEditCommandRequest)request);
            Element sourcePart = null;
            Element targetPart = null;
            if (sourceView.eContainer() instanceof View) {
                View sourceContainer = (View)sourceView.eContainer();
                sourcePart = (Element)sourceContainer.getElement();
            }
            if (targetView.eContainer() instanceof View) {
                View targetContainer = (View)targetView.eContainer();
                targetPart = (Element)targetContainer.getElement();
            }
            if (sourcePart instanceof Property && targetPart instanceof Class) {
                boolean sourceIsAssemblyPart = UMLUtil.getStereotypeApplication((Element)sourcePart, AssemblyPart.class) != null;
                return sourceIsAssemblyPart;
            }
            if (targetPart instanceof Property && sourcePart instanceof Class) {
                boolean targetIsAssemblyPart = UMLUtil.getStereotypeApplication((Element)targetPart, AssemblyPart.class) != null;
                return targetIsAssemblyPart;
            }
        }
        return false;
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return super.getBeforeConfigureCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        return super.getAfterConfigureCommand(request);
    }
}

