/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.deployment.tools.AllocUtils;
import org.eclipse.papyrus.designer.deployment.tools.ConfigUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.core.Activator;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;

public class TransformationUtil {
    public static void applyInstanceConfigurators(InstanceSpecification instance, Property part, InstanceSpecification parentInstance) {
        ConfigUtils.configureInstance((InstanceSpecification)instance, (Property)part, (InstanceSpecification)parentInstance);
        for (Slot slot : instance.getSlots()) {
            InstanceSpecification subInstance = DepUtils.getInstance((Slot)slot);
            if (!(slot.getDefiningFeature() instanceof Property) || DepUtils.isShared((Slot)slot) || subInstance == null) continue;
            TransformationUtil.applyInstanceConfigurators(subInstance, (Property)slot.getDefiningFeature(), instance);
        }
    }

    public static void propagateAllocation(InstanceSpecification instance) {
        TransformationUtil.propagateAllocation(instance, (EList<InstanceSpecification>)new UniqueEList());
    }

    public static void propagateAllocation(InstanceSpecification instance, EList<InstanceSpecification> nodes) {
        UniqueEList nodesCopy = new UniqueEList();
        nodesCopy.addAll(nodes);
        nodesCopy.addAll((Collection)AllocUtils.getNodes((InstanceSpecification)instance));
        for (Slot slot : instance.getSlots()) {
            InstanceSpecification subInstance = DepUtils.getInstance((Slot)slot);
            if (subInstance == null) continue;
            if (DepUtils.isShared((Slot)slot)) {
                for (InstanceSpecification node : nodesCopy) {
                    Activator.log.info(String.format("Propagate node allocation: %s to %s", subInstance.getName(), node.getName()));
                    AllocUtils.allocate((InstanceSpecification)subInstance, (InstanceSpecification)node);
                }
                continue;
            }
            TransformationUtil.propagateAllocation(subInstance, (EList<InstanceSpecification>)nodesCopy);
        }
    }
}

