/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppAttribute;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassAttributesDeclaration;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassFriendDeclaration;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassIncludeClassDeclaration;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassInheritedDeclarations;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassOperationsDeclaration;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassOperationsImplementation;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassTypeAndEnum;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppDocumentation;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppIncludeUtil;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppOperations;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppTemplates;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Union;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CppClassifierGenerator {
    public static CharSequence generateBindHeaderCode(Classifier classifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef ");
        String _fullNameUC = GenUtils.getFullNameUC((NamedElement)classifier);
        _builder.append(_fullNameUC, "");
        _builder.append("_H");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _fullNameUC_1 = GenUtils.getFullNameUC((NamedElement)classifier);
        _builder.append(_fullNameUC_1, "");
        _builder.append("_H");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        String _name = classifier.getName();
        _builder.append(_name, "              ");
        _builder.append(" template binding header");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        _builder.newLine();
        Package _package = classifier.getPackage();
        String _cppOwnerPackageIncludePath = CppClassIncludeClassDeclaration.cppOwnerPackageIncludePath(_package);
        String _includeDirective = CppIncludeUtil.includeDirective(_cppOwnerPackageIncludePath);
        _builder.append(_includeDirective, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _CppIncludeHeader = CppIncludeUtil.CppIncludeHeader((NamedElement)classifier);
        _builder.append(_CppIncludeHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        TemplateBinding tb = GenUtils.getTemplateBinding((Classifier)classifier);
        _builder.newLineIfNotEmpty();
        EList _targets = tb.getTargets();
        Element templateElement = (Element)_targets.get(0);
        _builder.newLineIfNotEmpty();
        Package _package_1 = classifier.getPackage();
        String _fullPath = GenUtils.getFullPath((Package)_package_1);
        String _plus = String.valueOf(_fullPath) + "/";
        Element _owner = templateElement.getOwner();
        String _name_1 = ((NamedElement)_owner).getName();
        String _plus_1 = String.valueOf(_plus) + _name_1;
        String _plus_2 = String.valueOf(_plus_1) + ".";
        String _headerSuffix = CppCodeGenUtils.getHeaderSuffix();
        String _plus_3 = String.valueOf(_plus_2) + _headerSuffix;
        String _includeDirective_1 = CppIncludeUtil.includeDirective(_plus_3);
        _builder.append(_includeDirective_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        List<String> _sortedDeclarePathList = CppClassifierGenerator.getSortedDeclarePathList(classifier);
        for (String path : _sortedDeclarePathList) {
            String _declareDirective = CppIncludeUtil.declareDirective(path);
            _builder.append(_declareDirective, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _openNS = CppGenUtils.openNS((NamedElement)classifier);
        _builder.append(_openNS, "");
        _builder.newLineIfNotEmpty();
        _builder.append("/************************************************************/");
        _builder.newLine();
        _builder.append("typedef ");
        Element _owner_1 = templateElement.getOwner();
        String _name_2 = ((NamedElement)_owner_1).getName();
        _builder.append(_name_2, "");
        _builder.append("<");
        EList _parameterSubstitutions = tb.getParameterSubstitutions();
        boolean _hasElements = false;
        for (TemplateParameterSubstitution ps : _parameterSubstitutions) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            Object _CppTemplateBindingParameter = CppTemplates.CppTemplateBindingParameter(ps);
            _builder.append(_CppTemplateBindingParameter, "");
        }
        _builder.append("> ");
        String _name_3 = classifier.getName();
        _builder.append(_name_3, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _closeNS = CppGenUtils.closeNS((NamedElement)classifier);
        _builder.append(_closeNS, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("End of ");
        String _name_4 = classifier.getName();
        _builder.append(_name_4, "              ");
        _builder.append(" template binding header");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public static List<String> getSortedIncludePathList(Classifier classifier) {
        Iterable<String> _CppClassAllIncludes = CppClassIncludeClassDeclaration.CppClassAllIncludes(classifier);
        List includePathList = IterableExtensions.sort(_CppClassAllIncludes);
        return includePathList;
    }

    public static List<String> getSortedDeclarePathList(Classifier classifier) {
        Iterable<String> _CppClassAllDeclares = CppClassIncludeClassDeclaration.CppClassAllDeclares(classifier);
        List declarePathList = IterableExtensions.sort(_CppClassAllDeclares);
        return declarePathList;
    }

    public static CharSequence generateBindBodyCode(Classifier classifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ");
        String _fullNameUC = GenUtils.getFullNameUC((NamedElement)classifier);
        _builder.append(_fullNameUC, "");
        _builder.append("_BODY");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        String _name = classifier.getName();
        _builder.append(_name, "              ");
        _builder.append(" template binding body");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        _builder.newLine();
        String _CppIncludePreBody = CppIncludeUtil.CppIncludePreBody((NamedElement)classifier);
        _builder.append(_CppIncludePreBody, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// include associated header file");
        _builder.newLine();
        Package _package = classifier.getPackage();
        String _fullPath = GenUtils.getFullPath((Package)_package);
        String _plus = String.valueOf(_fullPath) + "/";
        String _name_1 = classifier.getName();
        String _plus_1 = String.valueOf(_plus) + _name_1;
        String _plus_2 = String.valueOf(_plus_1) + ".";
        String _headerSuffix = CppCodeGenUtils.getHeaderSuffix();
        String _plus_3 = String.valueOf(_plus_2) + _headerSuffix;
        String _includeDirective = CppIncludeUtil.includeDirective(_plus_3);
        _builder.append(_includeDirective, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("// Derived includes directives");
        _builder.newLine();
        Iterable<String> _CppClassAllIncludesDeclarationBody = CppClassIncludeClassDeclaration.CppClassAllIncludesDeclarationBody(classifier);
        List _sort = IterableExtensions.sort(_CppClassAllIncludesDeclarationBody);
        for (String path : _sort) {
            String _includeDirective_1 = CppIncludeUtil.includeDirective(path);
            _builder.append(_includeDirective_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _CppIncludeBody = CppIncludeUtil.CppIncludeBody((NamedElement)classifier);
        _builder.append(_CppIncludeBody, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _openNS = CppGenUtils.openNS((NamedElement)classifier);
        _builder.append(_openNS, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************/");
        _builder.newLine();
        TemplateBinding tb = GenUtils.getTemplateBinding((Classifier)classifier);
        _builder.newLineIfNotEmpty();
        EList _targets = tb.getTargets();
        Element templateElement = (Element)_targets.get(0);
        _builder.newLineIfNotEmpty();
        _builder.append("template class ");
        Element _owner = templateElement.getOwner();
        String _name_2 = ((NamedElement)_owner).getName();
        _builder.append(_name_2, "");
        _builder.append("<");
        EList _parameterSubstitutions = tb.getParameterSubstitutions();
        boolean _hasElements = false;
        for (TemplateParameterSubstitution ps : _parameterSubstitutions) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            Object _CppTemplateBindingParameter = CppTemplates.CppTemplateBindingParameter(ps);
            _builder.append(_CppTemplateBindingParameter, "");
        }
        _builder.append(">;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _closeNS = CppGenUtils.closeNS((NamedElement)classifier);
        _builder.append(_closeNS, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("End of ");
        String _name_3 = classifier.getName();
        _builder.append(_name_3, "              ");
        _builder.append(" template binding body");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generateClassHeaderCode(Classifier classifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef ");
        String _fullNameUC = GenUtils.getFullNameUC((NamedElement)classifier);
        _builder.append(_fullNameUC, "");
        _builder.append("_H");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _fullNameUC_1 = GenUtils.getFullNameUC((NamedElement)classifier);
        _builder.append(_fullNameUC_1, "");
        _builder.append("_H");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        String _name = classifier.getName();
        _builder.append(_name, "              ");
        _builder.append(" class header");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        _builder.newLine();
        Package _package = classifier.getPackage();
        String _cppOwnerPackageIncludePath = CppClassIncludeClassDeclaration.cppOwnerPackageIncludePath(_package);
        String _includeDirective = CppIncludeUtil.includeDirective(_cppOwnerPackageIncludePath);
        _builder.append(_includeDirective, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        List<String> _sortedIncludePathList = CppClassifierGenerator.getSortedIncludePathList(classifier);
        for (String path : _sortedIncludePathList) {
            String _includeDirective_1 = CppIncludeUtil.includeDirective(path);
            _builder.append(_includeDirective_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _CppIncludeHeader = CppIncludeUtil.CppIncludeHeader((NamedElement)classifier);
        _builder.append(_CppIncludeHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        List<String> _sortedDeclarePathList = CppClassifierGenerator.getSortedDeclarePathList(classifier);
        for (String path_1 : _sortedDeclarePathList) {
            String _declareDirective = CppIncludeUtil.declareDirective(path_1);
            _builder.append(_declareDirective, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _openNS = CppGenUtils.openNS((NamedElement)classifier);
        _builder.append(_openNS, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************/");
        _builder.newLine();
        CharSequence _CppElementDoc = CppDocumentation.CppElementDoc((Element)classifier);
        _builder.append((Object)_CppElementDoc, "");
        _builder.newLineIfNotEmpty();
        CharSequence _templateSignature = CppTemplates.templateSignature(classifier);
        _builder.append((Object)_templateSignature, "");
        String _classUnionOrStruct = CppClassifierGenerator.classUnionOrStruct(classifier);
        _builder.append(_classUnionOrStruct, "");
        _builder.append(" ");
        String _name_1 = classifier.getName();
        _builder.append(_name_1, "");
        CharSequence _CppClassInheritedDeclarations = CppClassInheritedDeclarations.CppClassInheritedDeclarations(classifier);
        _builder.append((Object)_CppClassInheritedDeclarations, "");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CppClassFriendDeclaration.CppClassIncludeFriendDeclaration(classifier);
        Object _CppClassTypeAndEnum = CppClassTypeAndEnum.CppClassTypeAndEnum(classifier);
        _builder.append(_CppClassTypeAndEnum, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        VisibilityKind publicVisibility = VisibilityKind.PUBLIC_LITERAL;
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _defaultInitializer = CppClassifierGenerator.defaultInitializer(classifier);
        String _section = CppGenUtils.getSection(publicVisibility, _defaultInitializer);
        _builder.append(_section, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _CppClassAttributesDeclaration = CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, publicVisibility);
        String _string = _CppClassAttributesDeclaration.toString();
        String _section_1 = CppGenUtils.getSection(publicVisibility, _string);
        _builder.append(_section_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _CppClassOperationsDeclaration = CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, publicVisibility);
        String _string_1 = _CppClassOperationsDeclaration.toString();
        String _section_2 = CppGenUtils.getSection(publicVisibility, _string_1);
        _builder.append(_section_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        VisibilityKind protectedVisibility = VisibilityKind.PROTECTED_LITERAL;
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _CppClassAttributesDeclaration_1 = CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, protectedVisibility);
        String _string_2 = _CppClassAttributesDeclaration_1.toString();
        String _section_3 = CppGenUtils.getSection(protectedVisibility, _string_2);
        _builder.append(_section_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _CppClassOperationsDeclaration_1 = CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, protectedVisibility);
        String _string_3 = _CppClassOperationsDeclaration_1.toString();
        String _section_4 = CppGenUtils.getSection(protectedVisibility, _string_3);
        _builder.append(_section_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        VisibilityKind privateVisibility = VisibilityKind.PRIVATE_LITERAL;
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _CppClassAttributesDeclaration_2 = CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, privateVisibility);
        String _string_4 = _CppClassAttributesDeclaration_2.toString();
        String _section_5 = CppGenUtils.getSection(privateVisibility, _string_4);
        _builder.append(_section_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _CppClassOperationsDeclaration_2 = CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, privateVisibility);
        String _string_5 = _CppClassOperationsDeclaration_2.toString();
        String _section_6 = CppGenUtils.getSection(privateVisibility, _string_5);
        _builder.append(_section_6, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.append("/************************************************************/");
        _builder.newLine();
        _builder.append("/* External declarations (package visibility)               */");
        _builder.newLine();
        VisibilityKind packageVisibility = VisibilityKind.PACKAGE_LITERAL;
        _builder.newLineIfNotEmpty();
        CharSequence _CppClassAttributesDeclaration_3 = CppClassAttributesDeclaration.CppClassAttributesDeclaration(classifier, packageVisibility);
        _builder.append((Object)_CppClassAttributesDeclaration_3, "");
        _builder.newLineIfNotEmpty();
        CharSequence _CppClassOperationsDeclaration_3 = CppClassOperationsDeclaration.CppClassOperationsDeclaration(classifier, packageVisibility);
        _builder.append((Object)_CppClassOperationsDeclaration_3, "");
        _builder.newLineIfNotEmpty();
        _builder.append("/************************************************************/");
        _builder.newLine();
        _builder.newLine();
        boolean _isTemplate = CppTemplates.isTemplate(classifier);
        if (_isTemplate) {
            _builder.append("/************************************************************/");
            _builder.newLine();
            _builder.append("/* Template functions                                       */");
            _builder.newLine();
            CharSequence _CppClassOperationsImplementation = CppClassOperationsImplementation.CppClassOperationsImplementation(classifier, false);
            _builder.append((Object)_CppClassOperationsImplementation, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* Inline functions                                         */");
        _builder.newLine();
        CharSequence _CppClassOperationsImplementation_1 = CppClassOperationsImplementation.CppClassOperationsImplementation(classifier, true);
        _builder.append((Object)_CppClassOperationsImplementation_1, "");
        _builder.newLineIfNotEmpty();
        String _closeNS = CppGenUtils.closeNS((NamedElement)classifier);
        _builder.append(_closeNS, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("End of ");
        String _name_2 = classifier.getName();
        _builder.append(_name_2, "              ");
        _builder.append(" class header");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public static String classUnionOrStruct(Classifier classifier) {
        boolean _hasStereotype = GenUtils.hasStereotype((Element)classifier, Union.class);
        if (_hasStereotype) {
            return "union";
        }
        if (classifier instanceof DataType) {
            CppGenUtils.resetVisibility(VisibilityKind.PUBLIC_LITERAL);
            return "struct";
        }
        CppGenUtils.resetVisibility(VisibilityKind.PRIVATE_LITERAL);
        return "class";
    }

    public static String defaultInitializer(Classifier classifier) {
        Functions.Function1<Operation, Boolean> _function;
        StringConcatenation _builder = new StringConcatenation();
        Collection<Operation> _ownedOperations = CppOperations.getOwnedOperations(classifier);
        Iterable _filter = IterableExtensions.filter(_ownedOperations, (Functions.Function1)(_function = new Functions.Function1<Operation, Boolean>(){

            public Boolean apply(Operation it) {
                return GenUtils.hasStereotype((Element)it, Create.class);
            }
        }));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
        if (_isEmpty) {
            boolean _not;
            EList _attributes = classifier.getAttributes();
            Functions.Function1<Property, Boolean> _function_1 = new Functions.Function1<Property, Boolean>(){

                public Boolean apply(Property it) {
                    ValueSpecification _defaultValue_1;
                    String _stringValue;
                    boolean _notEquals_1;
                    ValueSpecification _defaultValue;
                    boolean _notEquals;
                    boolean _equals;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _isStatic = it.isStatic();
                    boolean bl = _equals = !_isStatic;
                    _and_1 = !_equals ? false : (_notEquals = !Objects.equal((Object)(_defaultValue = it.getDefaultValue()), null));
                    _and = !_and_1 ? false : (_notEquals_1 = !Objects.equal((Object)(_stringValue = (_defaultValue_1 = it.getDefaultValue()).stringValue()), null));
                    return _and;
                }
            };
            Iterable attributeList = IterableExtensions.filter((Iterable)_attributes, (Functions.Function1)_function_1);
            _builder.newLineIfNotEmpty();
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)attributeList);
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                String _name = classifier.getName();
                _builder.append(_name, "");
                _builder.append("() : ");
                boolean _hasElements = false;
                for (Property a : attributeList) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    String _name_1 = a.getName();
                    _builder.append(_name_1, "");
                    _builder.append("(");
                    ValueSpecification _defaultValue = a.getDefaultValue();
                    String _stringValue = _defaultValue.stringValue();
                    _builder.append(_stringValue, "");
                    _builder.append(")");
                }
                _builder.append(" {}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
        }
        String code = _builder.toString();
        return code.trim();
    }

    public static CharSequence generateClassBodyCode(Classifier classifier) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ");
        String _fullName = GenUtils.getFullName((NamedElement)classifier);
        _builder.append(_fullName, "");
        _builder.append("_BODY");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        String _name = classifier.getName();
        _builder.append(_name, "              ");
        _builder.append(" class body");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        _builder.newLine();
        String _CppIncludePreBody = CppIncludeUtil.CppIncludePreBody((NamedElement)classifier);
        _builder.append(_CppIncludePreBody, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// include associated header file");
        _builder.newLine();
        Package _nearestPackage = classifier.getNearestPackage();
        String _fullPath = GenUtils.getFullPath((Package)_nearestPackage);
        String _plus = String.valueOf(_fullPath) + "/";
        String _name_1 = classifier.getName();
        String _plus_1 = String.valueOf(_plus) + _name_1;
        String _plus_2 = String.valueOf(_plus_1) + ".";
        String _headerSuffix = CppCodeGenUtils.getHeaderSuffix();
        String _plus_3 = String.valueOf(_plus_2) + _headerSuffix;
        String _includeDirective = CppIncludeUtil.includeDirective(_plus_3);
        _builder.append(_includeDirective, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// Derived includes directives");
        _builder.newLine();
        Iterable<String> _CppClassAllIncludesDeclarationBody = CppClassIncludeClassDeclaration.CppClassAllIncludesDeclarationBody(classifier);
        List _sort = IterableExtensions.sort(_CppClassAllIncludesDeclarationBody);
        for (String path : _sort) {
            String _includeDirective_1 = CppIncludeUtil.includeDirective(path);
            _builder.append(_includeDirective_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _CppIncludeBody = CppIncludeUtil.CppIncludeBody((NamedElement)classifier);
        _builder.append(_CppIncludeBody, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _usingNamespaces = CppCodeGenUtils.getUsingNamespaces();
        if (_usingNamespaces) {
            _builder.append("// Derived using namespaces");
            _builder.newLine();
            Iterable<String> _CppClassAllUsings = CppClassIncludeClassDeclaration.CppClassAllUsings(classifier);
            List _sort_1 = IterableExtensions.sort(_CppClassAllUsings);
            for (String path_1 : _sort_1) {
                String _usingDirective = CppIncludeUtil.usingDirective(path_1);
                _builder.append(_usingDirective, "");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        String _openNS = CppGenUtils.openNS((NamedElement)classifier);
        _builder.append(_openNS, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _CppStaticAttributes = CppAttribute.CppStaticAttributes(classifier);
        _builder.append(_CppStaticAttributes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isTemplate = classifier.isTemplate();
        boolean bl = _not = !_isTemplate;
        if (_not) {
            CharSequence _CppClassOperationsImplementation = CppClassOperationsImplementation.CppClassOperationsImplementation(classifier, false);
            _builder.append((Object)_CppClassOperationsImplementation, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _closeNS = CppGenUtils.closeNS((NamedElement)classifier);
        _builder.append(_closeNS, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************************************************");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("End of ");
        String _name_2 = classifier.getName();
        _builder.append(_name_2, "              ");
        _builder.append(" class body");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("************************************************************/");
        _builder.newLine();
        return _builder;
    }
}

