/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.UmlUtils;
import org.eclipse.uml2.uml.Package;

public class CreationPackageCatalog {
    public static final String WILDCARD = "*";
    private List<CreationPattern> creationPatterns;
    private Package defaultCreationPackage;
    private Package externalTypesCreationPackage;
    private static String defaultCreationPath = "default";
    private static String externalCreationPath = "importedTypes";
    private Package modelRootPackage;
    private static String[] defaultPackageCreationPatterns;

    static {
        String[] stringArray = new String[15];
        stringArray[0] = "java.*";
        stringArray[2] = "java";
        stringArray[3] = "org.eclipse.papyrus.*";
        stringArray[5] = WILDCARD;
        stringArray[6] = "org.eclipse.*";
        stringArray[7] = "org.eclipse.papyrus.*";
        stringArray[8] = WILDCARD;
        stringArray[9] = "org.osgi.*";
        stringArray[11] = "osgi.*";
        stringArray[12] = "datatype.*";
        stringArray[14] = "datatype";
        defaultPackageCreationPatterns = stringArray;
    }

    public CreationPackageCatalog(Package modelRootPackage, Package defaultPackage, List<String> packageCreationPatterns) {
        this.defaultCreationPackage = defaultPackage;
        this.modelRootPackage = modelRootPackage;
        this.creationPatterns = new ArrayList<CreationPattern>();
        if (packageCreationPatterns == null || packageCreationPatterns.size() == 0) {
            this.initPackageCreationPatterns(this.creationPatterns, defaultPackageCreationPatterns);
        } else {
            try {
                CreationPackageCatalog.validateCreationPath(packageCreationPatterns);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parameter initialMappings has bad format:", e);
            }
            this.initPackageCreationPatterns(this.creationPatterns, packageCreationPatterns.toArray(new String[0]));
        }
    }

    public void setDefaultPackage(Package defaultPackage) {
        this.defaultCreationPackage = defaultPackage;
    }

    public Package getDefaultPackage() {
        return this.defaultCreationPackage;
    }

    private void initPackageCreationPatterns(List<CreationPattern> mappings, String[] initialMappings) {
        if (initialMappings == null) {
            return;
        }
        int i = 0;
        while (i < initialMappings.length) {
            String qname = initialMappings[i + 2];
            String excludeKey = initialMappings[i + 1];
            String[] excludeKeys = null;
            if (excludeKey != null) {
                excludeKeys = excludeKey.split(",");
            }
            mappings.add(new CreationPattern(initialMappings[i], excludeKeys, qname));
            i += 3;
        }
    }

    public Package getCreationPackage(List<String> qualifiedName, List<String> qualifiedNamesInProjects) {
        String qname = this.toFlatQualifiedName(qualifiedName);
        for (CreationPattern p : this.creationPatterns) {
            if (!p.isFor(qname)) continue;
            return p.getPackage(qualifiedName);
        }
        boolean isExternal = true;
        if (qualifiedNamesInProjects != null) {
            for (String qualifiedNameInProjects : qualifiedNamesInProjects) {
                if (!qualifiedNameInProjects.startsWith(qname) && !qualifiedNameInProjects.endsWith(qname)) continue;
                isExternal = false;
                break;
            }
        } else {
            isExternal = false;
        }
        if (isExternal) {
            if (this.externalTypesCreationPackage == null) {
                this.externalTypesCreationPackage = UmlUtils.getPackage(this.modelRootPackage, externalCreationPath);
            }
            return this.externalTypesCreationPackage;
        }
        return this.defaultCreationPackage;
    }

    public static String[] getDefaultPackageCreationPatterns(String separator) {
        return CreationPackageCatalog.toLineCreationPattern(defaultPackageCreationPatterns, separator);
    }

    public static String getDefaultCreationPath() {
        return defaultCreationPath;
    }

    private List<String> dotToListOfString(String key) {
        return Arrays.asList(key.split("\\."));
    }

    public String toFlatQualifiedName(List<String> qualifiedName) {
        if (qualifiedName.size() == 1) {
            return qualifiedName.get(0);
        }
        StringBuffer buff = new StringBuffer();
        buff.append(qualifiedName.get(0));
        int i = 1;
        while (i < qualifiedName.size()) {
            String part = qualifiedName.get(i);
            buff.append(".").append(part);
            ++i;
        }
        return buff.toString();
    }

    public static void validateCreationPath(List<String> paths) throws Exception {
        int i = 0;
        while (i < paths.size()) {
            String includePattern = paths.get(i);
            String excludePattern = paths.get(i + 1);
            String targetPath = paths.get(i + 2);
            String errorLine = "[" + includePattern + " ; " + excludePattern + " ; " + targetPath + "]";
            CreationPackageCatalog.checkNotEmptyPattern(includePattern, errorLine);
            CreationPackageCatalog.checkNotEmptyPattern(targetPath, errorLine);
            CreationPackageCatalog.checkSizeNotZero(excludePattern, errorLine);
            i += 3;
        }
    }

    private static void checkSizeNotZero(String pattern, String errorLine) throws Exception {
        if (pattern != null && pattern.length() == 0) {
            throw new Exception("Pattern should not be null or empty" + errorLine);
        }
    }

    private static void checkNotEmptyPattern(String pattern, String errorLine) throws Exception {
        if (pattern == null || pattern.length() == 0) {
            throw new Exception("Pattern should not be null or empty" + errorLine);
        }
    }

    public static String[] toLineCreationPattern(String[] elements, String separator) {
        int size = elements.length / 3;
        String[] result = new String[size];
        int index = 0;
        int i = 0;
        while (i < elements.length) {
            String includePattern = elements[i];
            String excludePattern = elements[i + 1];
            String creationPath = elements[i + 2];
            if (excludePattern == null) {
                excludePattern = "";
            }
            result[index] = String.valueOf(includePattern) + separator + excludePattern + separator + creationPath;
            ++index;
            i += 3;
        }
        return result;
    }

    public static List<String> extractCreationPaths(String[] creationPattern) {
        int size = creationPattern.length / 3;
        ArrayList<String> result = new ArrayList<String>(size);
        int i = 0;
        while (i < creationPattern.length) {
            String element = creationPattern[i + 2];
            if (!result.contains(element)) {
                result.add(element);
            }
            i += 3;
        }
        return result;
    }

    private static String[] extractColumn(String[] inputArray, int columnCount, int extractedColumn) {
        int size = inputArray.length / columnCount;
        String[] result = new String[size];
        int index = 0;
        int i = 0;
        while (i < inputArray.length) {
            String element;
            result[index] = element = inputArray[i + extractedColumn];
            ++index;
            i += 3;
        }
        return result;
    }

    public static List<String> getDefaultSearchPath() {
        return CreationPackageCatalog.extractCreationPaths(defaultPackageCreationPatterns);
    }

    public EClass guessBestType(List<String> qualifiedName) {
        String shortName = qualifiedName.get(qualifiedName.size() - 1);
        if (shortName.length() > 2 && shortName.startsWith("I") && Character.isUpperCase(shortName.charAt(1))) {
            return UmlUtils.CLASSIFIER_TYPE;
        }
        if (shortName.startsWith("Interface") || shortName.endsWith("Interface")) {
            return UmlUtils.CLASSIFIER_TYPE;
        }
        if (shortName.startsWith("Enum") || shortName.endsWith("Enum")) {
            return UmlUtils.ENUM_TYPE;
        }
        return UmlUtils.CLASS_TYPE;
    }

    private abstract class CreationModelPathEntry {
        private CreationModelPathEntry() {
        }

        public abstract List<String> getCreationModelPath(List<String> var1);
    }

    protected class CreationPattern {
        private CreationModelPathEntry creationModelPathEntry;
        private StringFilter includeFilter;
        private StringFilter[] excludeFilters;

        public CreationPattern(String key, String[] excludekeys, String qualifiedName) {
            this.includeFilter = this.createFilter(key);
            this.excludeFilters = this.createFilters(excludekeys);
            this.creationModelPathEntry = this.createCreationModelPathEntry(key, qualifiedName);
        }

        private StringFilter[] createFilters(String[] excludekeys) {
            if (excludekeys == null) {
                return null;
            }
            StringFilter[] filters = new StringFilter[excludekeys.length];
            int i = 0;
            while (i < excludekeys.length) {
                filters[i] = this.createFilter(excludekeys[i]);
                ++i;
            }
            return null;
        }

        private StringFilter createFilter(String name) {
            if (name.startsWith(CreationPackageCatalog.WILDCARD)) {
                return new EndWithFilter(name.substring(1, name.length()));
            }
            if (name.endsWith(CreationPackageCatalog.WILDCARD)) {
                return new StartWithFilter(name.substring(0, name.length() - 1));
            }
            return new IsEqualsFilter(name);
        }

        private CreationModelPathEntry createCreationModelPathEntry(String key, String qualifiedNameWithDot) {
            List qname = CreationPackageCatalog.this.dotToListOfString(qualifiedNameWithDot);
            if (qname.contains(CreationPackageCatalog.WILDCARD)) {
                if (key.contains(CreationPackageCatalog.WILDCARD)) {
                    return new PatternCreationModelPathEntry(key, qname);
                }
                qname.remove(CreationPackageCatalog.WILDCARD);
                return new SimpleCreationModelPathEntry(qname);
            }
            return new SimpleCreationModelPathEntry(qname);
        }

        public boolean isFor(String flatQualifiedName) {
            return this.includeFilter.accept(flatQualifiedName) && !this.isExcluded(flatQualifiedName);
        }

        private boolean isExcluded(String flatQualifiedName) {
            if (this.excludeFilters == null) {
                return false;
            }
            StringFilter[] stringFilterArray = this.excludeFilters;
            int n = this.excludeFilters.length;
            int n2 = 0;
            while (n2 < n) {
                StringFilter exclude = stringFilterArray[n2];
                if (exclude.accept(flatQualifiedName)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Package getPackage(List<String> proposedPath) {
            Package cachedPackage = UmlUtils.getPackage(CreationPackageCatalog.this.modelRootPackage, this.creationModelPathEntry.getCreationModelPath(proposedPath));
            return cachedPackage;
        }
    }

    private class EndWithFilter
    extends StringFilter {
        public EndWithFilter(String filter) {
            super(filter);
        }

        @Override
        public boolean accept(String name) {
            return name.endsWith(this.filter);
        }
    }

    private class IsEqualsFilter
    extends StringFilter {
        public IsEqualsFilter(String filter) {
            super(filter);
        }

        @Override
        public boolean accept(String name) {
            return name.equals(this.filter);
        }
    }

    private class PatternCreationModelPathEntry
    extends CreationModelPathEntry {
        private List<String> qname;
        private int srcPartIndex;
        private int targetPartIndex;

        public PatternCreationModelPathEntry(String key, List<String> qname) {
            List qualifiedKey = CreationPackageCatalog.this.dotToListOfString(key);
            this.srcPartIndex = qualifiedKey.indexOf(CreationPackageCatalog.WILDCARD);
            this.targetPartIndex = qname.indexOf(CreationPackageCatalog.WILDCARD);
            if (this.targetPartIndex < 0 || this.srcPartIndex < 0) {
                System.err.println("getCreationModelPath() - index problem for " + key + ", " + qname);
            }
            this.qname = qname;
        }

        @Override
        public List<String> getCreationModelPath(List<String> elementName) {
            ArrayList<String> result = new ArrayList<String>(this.qname);
            if (this.targetPartIndex < 0 || this.srcPartIndex < 0) {
                System.err.println("getCreationModelPath() - index problem for " + elementName);
            }
            result.set(this.targetPartIndex, elementName.get(this.srcPartIndex));
            return result;
        }
    }

    private class SimpleCreationModelPathEntry
    extends CreationModelPathEntry {
        private List<String> modelPath;

        public SimpleCreationModelPathEntry(List<String> modelPath) {
            this.modelPath = modelPath;
        }

        @Override
        public List<String> getCreationModelPath(List<String> elementName) {
            return this.modelPath;
        }
    }

    private class StartWithFilter
    extends StringFilter {
        public StartWithFilter(String filter) {
            super(filter);
        }

        @Override
        public boolean accept(String name) {
            return name.startsWith(this.filter);
        }
    }

    private abstract class StringFilter {
        protected String filter;

        public StringFilter(String filter) {
            this.filter = filter;
        }

        public abstract boolean accept(String var1);
    }
}

