/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.ruler;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.Guide;
import org.eclipse.gmf.runtime.notation.GuideStyle;

public class DiagramRuler {
    private int unit;
    private boolean horizontal;
    private GuideStyle guideStyle;

    public DiagramRuler(boolean isHorizontal, GuideStyle style) {
        this(isHorizontal, 0, style);
    }

    public DiagramRuler(boolean isHorizontal, int unit, GuideStyle style) {
        this.horizontal = isHorizontal;
        this.setUnit(unit);
        this.guideStyle = style;
    }

    private GuideStyle getGuideStyle() {
        return this.guideStyle;
    }

    public List getGuides() {
        if (!this.isHorizontal()) {
            return this.getGuideStyle().getHorizontalGuides();
        }
        return this.getGuideStyle().getVerticalGuides();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            this.unit = newUnit;
        }
    }

    public void addGuide(Guide toAdd) {
        if (!this.isHorizontal()) {
            this.guideStyle.getHorizontalGuides().add((Object)toAdd);
        } else {
            this.guideStyle.getVerticalGuides().add((Object)toAdd);
        }
    }

    public void addNotificationListener(TransactionalEditingDomain editingDomain, NotificationListener listener) {
        DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain).addNotificationListener((EObject)this.getGuideStyle(), listener);
    }

    public void removeNotificationListener(TransactionalEditingDomain editingDomain, NotificationListener listener) {
        DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain).removeNotificationListener((EObject)this.getGuideStyle(), listener);
    }

    public void setGuideStyle(GuideStyle guideStyle) {
        this.guideStyle = guideStyle;
    }
}

