/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaintContext;

final class LinearGradientPaintContext
extends MultipleGradientPaintContext {
    private float dgdX;
    private float dgdY;
    private float gc;
    private float pixSz;
    private static final int DEFAULT_IMPL = 1;
    private static final int ANTI_ALIAS_IMPL = 3;
    private int fillMethod;

    public LinearGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        super(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
        Point2D.Float float_ = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        Point2D.Float float_2 = new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
        float f = float_2.x - float_.x;
        float f2 = float_2.y - float_.y;
        float f3 = f * f + f2 * f2;
        float f4 = f / f3;
        float f5 = f2 / f3;
        this.dgdX = this.a00 * f4 + this.a10 * f5;
        this.dgdY = this.a01 * f4 + this.a11 * f5;
        float f6 = Math.abs(this.dgdX);
        float f7 = Math.abs(this.dgdY);
        this.pixSz = f6 > f7 ? f6 : f7;
        this.gc = (this.a02 - float_.x) * f4 + (this.a12 - float_.y) * f5;
        Object object = renderingHints.get(RenderingHints.KEY_COLOR_RENDERING);
        Object object2 = renderingHints.get(RenderingHints.KEY_RENDERING);
        this.fillMethod = 1;
        if (cycleMethodEnum == MultipleGradientPaint.REPEAT || this.hasDiscontinuity) {
            if (object2 == RenderingHints.VALUE_RENDER_QUALITY) {
                this.fillMethod = 3;
            }
            if (object == RenderingHints.VALUE_COLOR_RENDER_SPEED) {
                this.fillMethod = 1;
            } else if (object == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
                this.fillMethod = 3;
            }
        }
    }

    protected void fillHardNoCycle(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = this.dgdX * (float)n3 + this.gc;
        int n7 = 0;
        while (n7 < n6) {
            int n8;
            int n9;
            float f2 = f + this.dgdY * (float)(n4 + n7);
            int n10 = n + n5;
            if (this.dgdX == 0.0f) {
                if (f2 <= 0.0f) {
                    n9 = this.gradientUnderflow;
                } else if (f2 >= 1.0f) {
                    n9 = this.gradientOverflow;
                } else {
                    n8 = 0;
                    while (n8 < this.gradientsLength - 1) {
                        if (f2 < this.fractions[n8 + 1]) break;
                        ++n8;
                    }
                    float f3 = f2 - this.fractions[n8];
                    float f4 = f3 * 255.0f / this.normalizedIntervals[n8] + 0.5f;
                    n9 = this.gradients[n8][(int)f4];
                }
                while (n < n10) {
                    nArray[n++] = n9;
                }
            } else {
                int n11;
                int n12;
                int n13;
                int n14;
                double d;
                int[] nArray2;
                float f5;
                int n15;
                int n16;
                int n17;
                float f6;
                float f7;
                if (this.dgdX >= 0.0f) {
                    f7 = (1.0f - f2) / this.dgdX;
                    f6 = (float)Math.ceil((0.0f - f2) / this.dgdX);
                    n17 = this.gradientUnderflow;
                    n16 = this.gradientOverflow;
                } else {
                    f7 = (0.0f - f2) / this.dgdX;
                    f6 = (float)Math.ceil((1.0f - f2) / this.dgdX);
                    n17 = this.gradientOverflow;
                    n16 = this.gradientUnderflow;
                }
                n9 = f7 > (float)n5 ? n5 : (int)f7;
                n8 = f6 > (float)n5 ? n5 : (int)f6;
                int n18 = n + n9;
                if (n8 > 0) {
                    n15 = n + n8;
                    while (n < n15) {
                        nArray[n++] = n17;
                    }
                    f2 += this.dgdX * (float)n8;
                }
                if (this.dgdX > 0.0f) {
                    n15 = 0;
                    while (n15 < this.gradientsLength - 1) {
                        if (f2 < this.fractions[n15 + 1]) break;
                        ++n15;
                    }
                    while (n < n18) {
                        f5 = f2 - this.fractions[n15];
                        nArray2 = this.gradients[n15];
                        d = Math.ceil((this.fractions[n15 + 1] - f2) / this.dgdX);
                        n14 = d > (double)n5 ? n5 : (int)d;
                        n13 = n + n14;
                        if (n13 > n18) {
                            n13 = n18;
                        }
                        n12 = (int)(f5 * 255.0f / this.normalizedIntervals[n15] * 65536.0f) + 32768;
                        n11 = (int)(this.dgdX * 255.0f / this.normalizedIntervals[n15] * 65536.0f);
                        while (n < n13) {
                            nArray[n++] = nArray2[n12 >> 16];
                            n12 += n11;
                        }
                        f2 = (float)((double)f2 + (double)this.dgdX * d);
                        ++n15;
                    }
                } else {
                    n15 = this.gradientsLength - 1;
                    while (n15 > 0) {
                        if (f2 > this.fractions[n15]) break;
                        --n15;
                    }
                    while (n < n18) {
                        f5 = f2 - this.fractions[n15];
                        nArray2 = this.gradients[n15];
                        d = Math.ceil(f5 / -this.dgdX);
                        n14 = d > (double)n5 ? n5 : (int)d;
                        n13 = n + n14;
                        if (n13 > n18) {
                            n13 = n18;
                        }
                        n12 = (int)(f5 * 255.0f / this.normalizedIntervals[n15] * 65536.0f) + 32768;
                        n11 = (int)(this.dgdX * 255.0f / this.normalizedIntervals[n15] * 65536.0f);
                        while (n < n13) {
                            nArray[n++] = nArray2[n12 >> 16];
                            n12 += n11;
                        }
                        f2 = (float)((double)f2 + (double)this.dgdX * d);
                        --n15;
                    }
                }
                while (n < n10) {
                    nArray[n++] = n16;
                }
            }
            n += n2;
            ++n7;
        }
    }

    protected void fillSimpleNoCycle(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = this.dgdX * (float)n3 + this.gc;
        float f2 = this.dgdX * (float)this.fastGradientArraySize;
        int n7 = (int)(f2 * 65536.0f);
        int[] nArray2 = this.gradient;
        int n8 = 0;
        while (n8 < n6) {
            int n9;
            float f3 = f + this.dgdY * (float)(n4 + n8);
            f3 *= (float)this.fastGradientArraySize;
            f3 = (float)((double)f3 + 0.5);
            int n10 = n + n5;
            float f4 = this.dgdX * (float)this.fastGradientArraySize * (float)n5;
            if (f4 < 0.0f) {
                f4 = -f4;
            }
            if ((double)f4 < 0.3) {
                n9 = f3 <= 0.0f ? this.gradientUnderflow : (f3 >= (float)this.fastGradientArraySize ? this.gradientOverflow : nArray2[(int)f3]);
                while (n < n10) {
                    nArray[n++] = n9;
                }
            } else {
                int n11;
                int n12;
                int n13;
                int n14;
                if (this.dgdX > 0.0f) {
                    n9 = (int)(((float)this.fastGradientArraySize - f3) / f2);
                    n14 = (int)Math.ceil(0.0f - f3 / f2);
                    n13 = this.gradientUnderflow;
                    n12 = this.gradientOverflow;
                } else {
                    n9 = (int)((0.0f - f3) / f2);
                    n14 = (int)Math.ceil(((float)this.fastGradientArraySize - f3) / f2);
                    n13 = this.gradientOverflow;
                    n12 = this.gradientUnderflow;
                }
                if (n9 > n5) {
                    n9 = n5;
                }
                int n15 = n + n9;
                if (n14 > 0) {
                    if (n14 > n5) {
                        n14 = n5;
                    }
                    n11 = n + n14;
                    while (n < n11) {
                        nArray[n++] = n13;
                    }
                    f3 += f2 * (float)n14;
                }
                n11 = (int)(f3 * 65536.0f);
                while (n < n15) {
                    nArray[n++] = nArray2[n11 >> 16];
                    n11 += n7;
                }
                while (n < n10) {
                    nArray[n++] = n12;
                }
            }
            n += n2;
            ++n8;
        }
    }

    protected void fillSimpleRepeat(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = this.dgdX * (float)n3 + this.gc;
        float f2 = (this.dgdX - (float)((int)this.dgdX)) * (float)this.fastGradientArraySize;
        if (f2 < 0.0f) {
            f2 += (float)this.fastGradientArraySize;
        }
        int[] nArray2 = this.gradient;
        int n7 = 0;
        while (n7 < n6) {
            float f3 = f + this.dgdY * (float)(n4 + n7);
            if ((f3 -= (float)((int)f3)) < 0.0f) {
                f3 += 1.0f;
            }
            f3 *= (float)this.fastGradientArraySize;
            f3 = (float)((double)f3 + 0.5);
            int n8 = n + n5;
            while (n < n8) {
                int n9 = (int)f3;
                if (n9 >= this.fastGradientArraySize) {
                    f3 -= (float)this.fastGradientArraySize;
                    n9 -= this.fastGradientArraySize;
                }
                nArray[n++] = nArray2[n9];
                f3 += f2;
            }
            n += n2;
            ++n7;
        }
    }

    protected void fillSimpleReflect(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = this.dgdX * (float)n3 + this.gc;
        int[] nArray2 = this.gradient;
        int n7 = 0;
        while (n7 < n6) {
            float f2 = f + this.dgdY * (float)(n4 + n7);
            f2 -= (float)(2 * (int)(f2 / 2.0f));
            float f3 = this.dgdX;
            if (f2 < 0.0f) {
                f2 = -f2;
                f3 = -f3;
            }
            if ((f3 -= 2.0f * ((float)((int)f3) / 2.0f)) < 0.0f) {
                f3 = (float)((double)f3 + 2.0);
            }
            int n8 = 2 * this.fastGradientArraySize;
            f2 *= (float)this.fastGradientArraySize;
            f2 = (float)((double)f2 + 0.5);
            f3 *= (float)this.fastGradientArraySize;
            int n9 = n + n5;
            while (n < n9) {
                int n10 = (int)f2;
                if (n10 >= n8) {
                    f2 -= (float)n8;
                    n10 -= n8;
                }
                nArray[n++] = n10 <= this.fastGradientArraySize ? nArray2[n10] : nArray2[n8 - n10];
                f2 += f3;
            }
            n += n2;
            ++n7;
        }
    }

    protected void fillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = this.dgdX * (float)n3 + this.gc;
        if (this.fillMethod == 3) {
            int n7 = 0;
            while (n7 < n6) {
                float f2 = f + this.dgdY * (float)(n4 + n7);
                int n8 = n + n5;
                while (n < n8) {
                    nArray[n++] = this.indexGradientAntiAlias(f2, this.pixSz);
                    f2 += this.dgdX;
                }
                n += n2;
                ++n7;
            }
        } else if (!this.isSimpleLookup) {
            if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
                this.fillHardNoCycle(nArray, n, n2, n3, n4, n5, n6);
            } else {
                int n9 = 0;
                while (n9 < n6) {
                    float f3 = f + this.dgdY * (float)(n4 + n9);
                    int n10 = n + n5;
                    while (n < n10) {
                        nArray[n++] = this.indexIntoGradientsArrays(f3);
                        f3 += this.dgdX;
                    }
                    n += n2;
                    ++n9;
                }
            }
        } else if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            this.fillSimpleNoCycle(nArray, n, n2, n3, n4, n5, n6);
        } else if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
            this.fillSimpleRepeat(nArray, n, n2, n3, n4, n5, n6);
        } else {
            this.fillSimpleReflect(nArray, n, n2, n3, n4, n5, n6);
        }
    }
}

