/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiPen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class PolyDraw
implements IEmf2SvgConverter,
IRenderToPath {
    private static final int COUNT_OFFSET = 16;
    private static final int POINT_OFFSET = 20;
    private static final int PT_CLOSEFIGURE = 1;
    private static final int PT_LINETO = 2;
    private static final int PT_BEZIERTO = 4;
    private static final int PT_MOVETO = 6;
    private int m_count = 0;
    private int[] m_xPoints = null;
    private int[] m_yPoints = null;
    private byte[] m_flags = null;
    private boolean m_b16Bits = false;

    public PolyDraw(boolean b16Bits) {
        this.m_b16Bits = b16Bits;
    }

    public void readEMFRecord(Record emr) throws IOException {
        this.m_count = (int)emr.getDWORDAt(16);
        this.m_xPoints = new int[this.m_count];
        this.m_yPoints = new int[this.m_count];
        this.m_flags = new byte[this.m_count];
        int curOffset = 20;
        int index = 0;
        while (index < this.m_count) {
            if (this.m_b16Bits) {
                this.m_xPoints[index] = emr.getShortAt(curOffset);
                this.m_yPoints[index] = emr.getShortAt(curOffset + 2);
                curOffset += 4;
            } else {
                this.m_xPoints[index] = emr.getIntAt(curOffset);
                this.m_yPoints[index] = emr.getIntAt(curOffset + 4);
                curOffset += 8;
            }
            ++index;
        }
        this.m_flags = emr.getBytesAt(curOffset, this.m_count);
    }

    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen curPen = context.getCurPen();
        if (curPen != null) {
            curPen.apply(g, context);
            GeneralPath p = new GeneralPath(1);
            p.moveTo(context.convertXToSVGLogicalUnits(context.getCurPosX()), context.convertYToSVGLogicalUnits(context.getCurPosY()));
            this.getShape(context, p);
            g.draw(p);
        }
    }

    public void render(DeviceContext context) throws TranscoderException {
        this.getShape(context, context.getGdiPath().getCurrentFigure());
    }

    private void getShape(DeviceContext context, GeneralPath p) {
        int lastMoveToX = context.getCurPosX();
        int lastMoveToY = context.getCurPosY();
        int index = 0;
        while (index < this.m_count) {
            boolean bCloseFigure = (this.m_flags[index] & 1) == 1;
            int type = this.m_flags[index] & 0xFFFFFFFE;
            int x = this.m_xPoints[index];
            int y = this.m_yPoints[index];
            switch (type) {
                case 6: {
                    context.setCurPosX(x);
                    context.setCurPosY(y);
                    p.moveTo(x, y);
                    lastMoveToX = x;
                    lastMoveToY = y;
                    break;
                }
                case 2: {
                    p.lineTo(context.convertXToSVGLogicalUnits(x), context.convertYToSVGLogicalUnits(y));
                    if (bCloseFigure) {
                        p.closePath();
                        context.setCurPosX(lastMoveToX);
                        context.setCurPosY(lastMoveToY);
                        break;
                    }
                    context.setCurPosX(x);
                    context.setCurPosY(y);
                    break;
                }
                case 4: {
                    int cp1X = context.convertXToSVGLogicalUnits(x);
                    int cp1Y = context.convertYToSVGLogicalUnits(y);
                    int cp2X = context.convertXToSVGLogicalUnits(this.m_xPoints[index + 1]);
                    int cp2Y = context.convertYToSVGLogicalUnits(this.m_yPoints[index + 1]);
                    bCloseFigure |= (this.m_flags[index + 1] & 1) == 1;
                    int endX = context.convertXToSVGLogicalUnits(this.m_xPoints[index + 2]);
                    int endY = context.convertYToSVGLogicalUnits(this.m_yPoints[index + 2]);
                    boolean bl = (this.m_flags[index + 2] & 1) == 1;
                    p.curveTo(cp1X, cp1Y, cp2X, cp2Y, endX, endY);
                    if (bCloseFigure |= bl) {
                        p.closePath();
                        context.setCurPosX(lastMoveToX);
                        context.setCurPosY(lastMoveToY);
                    } else {
                        context.setCurPosX(this.m_xPoints[index + 2]);
                        context.setCurPosY(this.m_yPoints[index + 2]);
                    }
                    index += 2;
                    break;
                }
            }
            ++index;
        }
    }
}

