/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractResourceUndoContextPolicy;
import org.eclipse.emf.workspace.IResourceUndoContextPolicy;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceValidateEditSupport;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.emf.core.internal.resources.PathmapManager;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceModificationManager;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;

public class GMFEditingDomainFactory
extends WorkspaceEditingDomainFactory {
    public static TransactionalSyncExecHelper transactionalSyncExecHelper = new TransactionalSyncExecHelper();
    private static GMFEditingDomainFactory instance;

    static {
        FileModificationValidator.SyncExecHelper.setInstance((FileModificationValidator.ISyncExecHelper)transactionalSyncExecHelper);
        instance = new GMFEditingDomainFactory();
    }

    public static WorkspaceEditingDomainFactory getInstance() {
        return instance;
    }

    public TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain result = super.createEditingDomain();
        this.configure(result);
        return result;
    }

    public TransactionalEditingDomain createEditingDomain(IOperationHistory history) {
        TransactionalEditingDomain result = super.createEditingDomain(history);
        this.configure(result);
        return result;
    }

    public TransactionalEditingDomain createEditingDomain(ResourceSet rset, IOperationHistory history) {
        TransactionalEditingDomain result = super.createEditingDomain(rset, history);
        this.configure(result);
        return result;
    }

    public TransactionalEditingDomain createEditingDomain(ResourceSet rset) {
        TransactionalEditingDomain result = super.createEditingDomain(rset);
        this.configure(result);
        return result;
    }

    protected void configure(final TransactionalEditingDomain domain) {
        final ResourceSet rset = domain.getResourceSet();
        if (CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)rset) == null) {
            rset.eAdapters().add((Object)new CrossReferenceAdapter());
        }
        if (PathmapManager.getExistingPathmapManager(rset) == null) {
            Resource.Factory.Registry existingRegistry = rset.getResourceFactoryRegistry();
            rset.setResourceFactoryRegistry(new Resource.Factory.Registry(existingRegistry){
                private Resource.Factory.Registry delegateRegistry;
                {
                    this.delegateRegistry = registry;
                }

                public Map<String, Object> getContentTypeToFactoryMap() {
                    return this.delegateRegistry.getContentTypeToFactoryMap();
                }

                public Map<String, Object> getExtensionToFactoryMap() {
                    return this.delegateRegistry.getExtensionToFactoryMap();
                }

                public Resource.Factory getFactory(URI uri, String contentType) {
                    if (uri != null && uri.scheme() != null && uri.scheme().equals("pathmap")) {
                        uri = rset.getURIConverter().normalize(uri);
                    }
                    return this.delegateRegistry.getFactory(uri, contentType);
                }

                public Resource.Factory getFactory(URI uri) {
                    if (uri != null && uri.scheme() != null && uri.scheme().equals("pathmap")) {
                        uri = rset.getURIConverter().normalize(uri);
                    }
                    return this.delegateRegistry.getFactory(uri);
                }

                public Map<String, Object> getProtocolToFactoryMap() {
                    return this.delegateRegistry.getProtocolToFactoryMap();
                }
            });
            rset.eAdapters().add((Object)new PathmapManager());
        }
        TransactionalEditingDomain.DefaultOptions options = (TransactionalEditingDomain.DefaultOptions)TransactionUtil.getAdapter((TransactionalEditingDomain)domain, TransactionalEditingDomain.DefaultOptions.class);
        HashMap<String, 2> aMap = new HashMap<String, 2>();
        aMap.put("validate_edit", new WorkspaceValidateEditSupport(){

            protected IStatus doValidateEdit(Transaction transaction, Collection resources, Object context) {
                return transactionalSyncExecHelper.approveFileModification(this.getFiles(resources), domain);
            }
        });
        options.setDefaultTransactionOptions(aMap);
        this.configureResourceModificationManagement(domain);
    }

    protected void configureResourceModificationManagement(TransactionalEditingDomain domain) {
        GMFResourceModificationManager.manage(domain);
    }

    protected IResourceUndoContextPolicy getResourceUndoContextPolicy() {
        return new AbstractResourceUndoContextPolicy(){

            protected boolean isAbstractChange(Notification notification) {
                return super.isAbstractChange(notification) && GMFResource.isModifyingChange(notification);
            }

            protected void resourceChange(Set<Resource> resources, Resource resource, Notification notification) {
                if (notification.getFeatureID(Resource.class) == 3) {
                    resources.add(resource);
                } else {
                    super.resourceChange(resources, resource, notification);
                }
            }
        };
    }

    public static class TransactionalSyncExecHelper
    implements FileModificationValidator.ISyncExecHelper {
        private final ThreadLocal<TransactionalEditingDomain> domain = new ThreadLocal();

        private void setDomain(TransactionalEditingDomain domain) {
            this.domain.set(domain);
        }

        public IStatus approveFileModification(IFile[] files, TransactionalEditingDomain transactionalDomain) {
            this.setDomain(transactionalDomain);
            IStatus status = Status.OK_STATUS;
            try {
                status = FileModificationValidator.approveFileModification((IFile[])files);
            }
            finally {
                this.setDomain(null);
            }
            return status;
        }

        public Runnable safeRunnable(Runnable runnable) {
            if (this.isTransactionOnCurrentThread()) {
                return this.domain.get().createPrivilegedRunnable(runnable);
            }
            return null;
        }

        private boolean isTransactionOnCurrentThread() {
            if (this.domain.get() != null) {
                InternalTransaction tx = ((InternalTransactionalEditingDomain)this.domain.get()).getActiveTransaction();
                return tx != null && tx.getOwner() == Thread.currentThread();
            }
            return false;
        }
    }
}

