/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.services.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.IInternalLayoutRunnable;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutNodeProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.notation.Node;

public abstract class AbstractLayoutEditPartProvider
extends AbstractLayoutNodeProvider {
    public Runnable layoutLayoutNodes(List layoutNodes, boolean offsetFromBoundingBox, IAdaptable layoutHint) {
        IGraphicalEditPart gep = (IGraphicalEditPart)layoutHint.getAdapter(IGraphicalEditPart.class);
        Assert.isNotNull((Object)gep, (String)"The Graphical EditPart is null");
        if (offsetFromBoundingBox) {
            ArrayList editparts = new ArrayList(layoutNodes.size());
            Map registry = gep.getViewer().getEditPartRegistry();
            ListIterator nodes = layoutNodes.listIterator();
            while (nodes.hasNext()) {
                Node view = ((ILayoutNode)nodes.next()).getNode();
                editparts.add(registry.get(view));
            }
            final Command cmdSelect = this.layoutEditParts(editparts, layoutHint);
            return new IInternalLayoutRunnable(){

                public void run() {
                    cmdSelect.execute();
                }

                public Command getCommand() {
                    return cmdSelect;
                }
            };
        }
        final Command cmdDiag = this.layoutEditParts(gep, layoutHint);
        return new IInternalLayoutRunnable(){

            public void run() {
                cmdDiag.execute();
            }

            public Command getCommand() {
                return cmdDiag;
            }
        };
    }

    public abstract Command layoutEditParts(GraphicalEditPart var1, IAdaptable var2);

    public abstract Command layoutEditParts(List var1, IAdaptable var2);
}

