/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.Polyline;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.graphdef.editor.edit.parts.CanvasEditPart;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class GMFGraphVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(GMFGraphDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if (CanvasEditPart.MODEL_ID.equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return GMFGraphVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return GMFGraphVisualIDRegistry.getDiagramVisualID(domainElement, domainElementMetaclass);
    }

    private static int getDiagramVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (GMFGraphPackage.eINSTANCE.getCanvas().isSuperTypeOf(domainElementMetaclass) && GMFGraphVisualIDRegistry.isDiagramCanvas_1000((Canvas)domainElement)) {
            return 1000;
        }
        return GMFGraphVisualIDRegistry.getUnrecognizedDiagramID(domainElement);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return GMFGraphVisualIDRegistry.getNodeVisualID(containerView, domainElement, domainElementMetaclass, null);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement, EClass domainElementMetaclass, String semanticHint) {
        int containerVisualID;
        String containerModelID = GMFGraphVisualIDRegistry.getModelID(containerView);
        if (!CanvasEditPart.MODEL_ID.equals(containerModelID)) {
            return -1;
        }
        if (CanvasEditPart.MODEL_ID.equals(containerModelID)) {
            containerVisualID = GMFGraphVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        int nodeVisualID = semanticHint != null ? GMFGraphVisualIDRegistry.getVisualID(semanticHint) : -1;
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return 5001;
                }
                if (7001 == nodeVisualID) {
                    return 7001;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedCompartment_2001ChildNodeID(domainElement, semanticHint);
            }
            case 2002: {
                if (5002 == nodeVisualID) {
                    return 5002;
                }
                if (7002 == nodeVisualID) {
                    return 7002;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedNode_2002ChildNodeID(domainElement, semanticHint);
            }
            case 2003: {
                if (5003 == nodeVisualID) {
                    return 5003;
                }
                if (7003 == nodeVisualID) {
                    return 7003;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedConnection_2003ChildNodeID(domainElement, semanticHint);
            }
            case 2004: {
                if (5004 == nodeVisualID) {
                    return 5004;
                }
                if (7004 == nodeVisualID) {
                    return 7004;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedFigureGallery_2004ChildNodeID(domainElement, semanticHint);
            }
            case 3001: {
                if ((semanticHint == null || 3002 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRectangle_3002((Rectangle)domainElement))) {
                    return 3002;
                }
                if ((semanticHint == null || 3003 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeEllipse_3003((Ellipse)domainElement))) {
                    return 3003;
                }
                if ((semanticHint == null || 3004 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRoundedRectangle_3004((RoundedRectangle)domainElement))) {
                    return 3004;
                }
                if ((semanticHint == null || 3005 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodePolyline_3005((Polyline)domainElement))) {
                    return 3005;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedRectangle_3001ChildNodeID(domainElement, semanticHint);
            }
            case 3002: {
                if ((semanticHint == null || 3002 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRectangle_3002((Rectangle)domainElement))) {
                    return 3002;
                }
                if ((semanticHint == null || 3003 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeEllipse_3003((Ellipse)domainElement))) {
                    return 3003;
                }
                if ((semanticHint == null || 3004 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRoundedRectangle_3004((RoundedRectangle)domainElement))) {
                    return 3004;
                }
                if ((semanticHint == null || 3005 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodePolyline_3005((Polyline)domainElement))) {
                    return 3005;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedRectangle_3002ChildNodeID(domainElement, semanticHint);
            }
            case 3003: {
                if ((semanticHint == null || 3002 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRectangle_3002((Rectangle)domainElement))) {
                    return 3002;
                }
                if ((semanticHint == null || 3003 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeEllipse_3003((Ellipse)domainElement))) {
                    return 3003;
                }
                if ((semanticHint == null || 3004 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRoundedRectangle_3004((RoundedRectangle)domainElement))) {
                    return 3004;
                }
                if ((semanticHint == null || 3005 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodePolyline_3005((Polyline)domainElement))) {
                    return 3005;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedEllipse_3003ChildNodeID(domainElement, semanticHint);
            }
            case 3004: {
                if ((semanticHint == null || 3002 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRectangle_3002((Rectangle)domainElement))) {
                    return 3002;
                }
                if ((semanticHint == null || 3003 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeEllipse_3003((Ellipse)domainElement))) {
                    return 3003;
                }
                if ((semanticHint == null || 3004 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRoundedRectangle_3004((RoundedRectangle)domainElement))) {
                    return 3004;
                }
                if ((semanticHint == null || 3005 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodePolyline_3005((Polyline)domainElement))) {
                    return 3005;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedRoundedRectangle_3004ChildNodeID(domainElement, semanticHint);
            }
            case 3005: {
                return GMFGraphVisualIDRegistry.getUnrecognizedPolyline_3005ChildNodeID(domainElement, semanticHint);
            }
            case 3006: {
                if ((semanticHint == null || 3002 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRectangle_3002((Rectangle)domainElement))) {
                    return 3002;
                }
                if ((semanticHint == null || 3003 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeEllipse_3003((Ellipse)domainElement))) {
                    return 3003;
                }
                if ((semanticHint == null || 3004 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRoundedRectangle_3004((RoundedRectangle)domainElement))) {
                    return 3004;
                }
                if ((semanticHint == null || 3005 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodePolyline_3005((Polyline)domainElement))) {
                    return 3005;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedEllipse_3006ChildNodeID(domainElement, semanticHint);
            }
            case 3007: {
                if ((semanticHint == null || 3002 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRectangle_3002((Rectangle)domainElement))) {
                    return 3002;
                }
                if ((semanticHint == null || 3003 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeEllipse_3003((Ellipse)domainElement))) {
                    return 3003;
                }
                if ((semanticHint == null || 3004 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRoundedRectangle_3004((RoundedRectangle)domainElement))) {
                    return 3004;
                }
                if ((semanticHint == null || 3005 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodePolyline_3005((Polyline)domainElement))) {
                    return 3005;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedRoundedRectangle_3007ChildNodeID(domainElement, semanticHint);
            }
            case 3008: {
                return GMFGraphVisualIDRegistry.getUnrecognizedPolyline_3008ChildNodeID(domainElement, semanticHint);
            }
            case 7001: {
                return GMFGraphVisualIDRegistry.getUnrecognizedCompartmentVisualFacets_7001ChildNodeID(domainElement, semanticHint);
            }
            case 7002: {
                return GMFGraphVisualIDRegistry.getUnrecognizedNodeVisualFacets_7002ChildNodeID(domainElement, semanticHint);
            }
            case 7003: {
                return GMFGraphVisualIDRegistry.getUnrecognizedConnectionVisualFacets_7003ChildNodeID(domainElement, semanticHint);
            }
            case 7004: {
                if ((semanticHint == null || 3001 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRectangle_3001((Rectangle)domainElement))) {
                    return 3001;
                }
                if ((semanticHint == null || 3006 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeEllipse_3006((Ellipse)domainElement))) {
                    return 3006;
                }
                if ((semanticHint == null || 3007 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeRoundedRectangle_3007((RoundedRectangle)domainElement))) {
                    return 3007;
                }
                if ((semanticHint == null || 3008 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodePolyline_3008((Polyline)domainElement))) {
                    return 3008;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedFigureGalleryFigures_7004ChildNodeID(domainElement, semanticHint);
            }
            case 1000: {
                if ((semanticHint == null || 2001 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getCompartment().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeCompartment_2001((Compartment)domainElement))) {
                    return 2001;
                }
                if ((semanticHint == null || 2002 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getNode().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeNode_2002((Node)domainElement))) {
                    return 2002;
                }
                if ((semanticHint == null || 2003 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getConnection().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeConnection_2003((Connection)domainElement))) {
                    return 2003;
                }
                if ((semanticHint == null || 2004 == nodeVisualID) && GMFGraphPackage.eINSTANCE.getFigureGallery().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFGraphVisualIDRegistry.isNodeFigureGallery_2004((FigureGallery)domainElement))) {
                    return 2004;
                }
                return GMFGraphVisualIDRegistry.getUnrecognizedCanvas_1000ChildNodeID(domainElement, semanticHint);
            }
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        EClass domainElementMetaclass = domainElement.eClass();
        return GMFGraphVisualIDRegistry.getLinkWithClassVisualID(domainElement, domainElementMetaclass);
    }

    public static int getLinkWithClassVisualID(EObject domainElement, EClass domainElementMetaclass) {
        return GMFGraphVisualIDRegistry.getUnrecognizedLinkWithClassID(domainElement);
    }

    private static boolean isDiagramCanvas_1000(Canvas element) {
        return true;
    }

    private static int getUnrecognizedDiagramID(EObject domainElement) {
        return -1;
    }

    private static boolean isNodeCompartment_2001(Compartment element) {
        return true;
    }

    private static boolean isNodeNode_2002(Node element) {
        return true;
    }

    private static boolean isNodeConnection_2003(Connection element) {
        return true;
    }

    private static boolean isNodeFigureGallery_2004(FigureGallery element) {
        return true;
    }

    private static boolean isNodeRectangle_3001(Rectangle element) {
        return true;
    }

    private static boolean isNodeRectangle_3002(Rectangle element) {
        return true;
    }

    private static boolean isNodeEllipse_3003(Ellipse element) {
        return true;
    }

    private static boolean isNodeRoundedRectangle_3004(RoundedRectangle element) {
        return true;
    }

    private static boolean isNodePolyline_3005(Polyline element) {
        return true;
    }

    private static boolean isNodeEllipse_3006(Ellipse element) {
        return true;
    }

    private static boolean isNodeRoundedRectangle_3007(RoundedRectangle element) {
        return true;
    }

    private static boolean isNodePolyline_3008(Polyline element) {
        return true;
    }

    private static int getUnrecognizedCompartment_2001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedNode_2002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedConnection_2003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedFigureGallery_2004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedRectangle_3001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedRectangle_3002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEllipse_3003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedRoundedRectangle_3004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedPolyline_3005ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedEllipse_3006ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedRoundedRectangle_3007ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedPolyline_3008ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedCompartmentVisualFacets_7001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedNodeVisualFacets_7002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedConnectionVisualFacets_7003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedFigureGalleryFigures_7004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedCanvas_1000ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkWithClassID(EObject domainElement) {
        return -1;
    }
}

