/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramPopupBarEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.SnapToGuidesEx;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandDragTracker;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Scrollable;

public class DiagramEditPart
extends GraphicalEditPart
implements LayerConstants,
ISurfaceEditPart {
    private boolean shouldUpdatePageBreakLocation = false;
    private boolean isSupportingViewActions = true;
    private boolean isActivatingDiagram = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DiagramEditPart(View diagramView) {
        super((EObject)diagramView);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ContainerEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DiagramDragDropEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ContainerNodeEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new DiagramPopupBarEditPolicy());
    }

    protected IFigure createFigure() {
        BorderItemsAwareFreeFormLayer f = new BorderItemsAwareFreeFormLayer(){

            public boolean containsPoint(int x, int y) {
                return this.getBounds().contains(x, y);
            }

            public IFigure findFigureAt(int x, int y, TreeSearch search) {
                if (!this.isEnabled()) {
                    return null;
                }
                if (!this.containsPoint(x, y)) {
                    return null;
                }
                if (search.prune((IFigure)this)) {
                    return null;
                }
                IFigure child = this.findDescendantAtExcluding(x, y, search);
                if (child != null) {
                    return child;
                }
                if (search.accept((IFigure)this)) {
                    return this;
                }
                return null;
            }

            public void validate() {
                super.validate();
                if (DiagramEditPart.this.shouldUpdatePageBreakLocation) {
                    DiagramEditPart.this.shouldUpdatePageBreakLocation = false;
                    DiagramEditPart.this.updatePageBreaksLocation();
                }
            }
        };
        f.setLayoutManager((LayoutManager)new FreeFormLayoutEx());
        f.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        f.addLayoutListener((LayoutListener)new PageBreaksLayoutListener());
        return f;
    }

    public Diagram getDiagramView() {
        return (Diagram)this.getModel();
    }

    public DragTracker getDragTracker(Request req) {
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new RubberbandDragTracker();
    }

    public IFigure getLayer(Object layer) {
        return super.getLayer(layer);
    }

    public Scrollable getScrollableControl() {
        return (Scrollable)this.getViewer().getControl();
    }

    public Viewport getViewport() {
        IFigure fig = this.getFigure().getParent();
        while (fig != null) {
            if (fig instanceof Viewport) {
                return (Viewport)fig;
            }
            fig = fig.getParent();
        }
        return null;
    }

    protected IFigure getConnectionLayer() {
        return this.getLayer("Connection Layer");
    }

    public List getConnections() {
        Iterator views = this.getDiagramView().getEdges().iterator();
        Map registry = this.getViewer().getEditPartRegistry();
        ArrayList connections = new ArrayList();
        while (views.hasNext()) {
            Object connectionEP = registry.get(views.next());
            if (connectionEP == null) continue;
            connections.add(connectionEP);
        }
        return connections;
    }

    public List getPrimaryEditParts() {
        List connections = this.getConnections();
        List shapes = this.getChildren();
        if (connections.size() > 0 || shapes.size() > 0) {
            ArrayList myChildren = new ArrayList();
            myChildren.addAll(shapes);
            myChildren.addAll(connections);
            return myChildren;
        }
        return Collections.EMPTY_LIST;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().add(child, index);
    }

    protected void updatePageBreaksLocation() {
        if (this.getParent() == null || this.getRoot() == null) {
            return;
        }
        IPreferenceStore preferenceStore = ((DiagramRootEditPart)this.getRoot()).getWorkspaceViewerPreferences();
        if (preferenceStore == null || !preferenceStore.getBoolean("viewpagebreaks")) {
            return;
        }
        ((DiagramRootEditPart)this.getRoot()).getPageBreakEditPart().resize(this.getChildrenBounds());
    }

    public Rectangle getChildrenBounds() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return PageInfoHelper.getChildrenBounds(this, clazz);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.SnapToHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            ArrayList<SnapToGuidesEx> snapStrategies = new ArrayList<SnapToGuidesEx>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuidesEx(this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add((SnapToGuidesEx)new SnapToGrid((org.eclipse.gef.GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.gmf.runtime.notation.Routing");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            IPreferenceStore store = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
            Routing routingVal = Routing.get((int)store.getInt("Connectors.lineStyle"));
            return routingVal;
        }
        return super.getAdapter(adapter);
    }

    public List getChildrenAffectingZoom() {
        return new ArrayList(this.getChildren());
    }

    public void refreshPageBreaks() {
        if (this.getRoot() == null) {
            return;
        }
        ((DiagramRootEditPart)this.getRoot()).refreshPageBreaks();
    }

    public boolean isSupportingViewActions() {
        return this.isSupportingViewActions;
    }

    public void setIsSupportingViewActions(boolean supportsViewActions) {
        this.isSupportingViewActions = supportsViewActions;
    }

    public boolean isActivatingDiagram() {
        return this.isActivatingDiagram;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activate() {
        this.isActivatingDiagram = true;
        try {
            super.activate();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.isActivatingDiagram = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.isActivatingDiagram = false;
            return;
        }
    }

    private class PageBreaksLayoutListener
    extends LayoutListener.Stub {
        private PageBreaksLayoutListener() {
        }

        public void postLayout(IFigure container) {
            super.postLayout(container);
            DiagramEditPart.this.updatePageBreaksLocation();
        }
    }
}

