/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.semantic.presentation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.examples.runtime.diagram.logic.model.presentation.LogicsemanticEditorPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ResourceLoadedListener
extends DemultiplexingListener {
    private static ResourceLoadedListener instance;
    private final Set ignoredResources = new HashSet();

    public ResourceLoadedListener() {
        super(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4));
        instance = this;
    }

    public static ResourceLoadedListener getDefault() {
        return instance;
    }

    public void ignore(Resource res) {
        this.ignoredResources.add(res);
    }

    public void watch(Resource res) {
        this.ignoredResources.remove(res);
    }

    protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
        IFile file;
        if (this.ignoredResources.contains(notification.getNotifier())) {
            return;
        }
        if (notification.getNewBooleanValue() && !notification.getOldBooleanValue()) {
            final IFile file2 = this.getFile((Resource)notification.getNotifier(), domain);
            if (file2 != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = ResourceLoadedListener.this.getActivePage();
                            if (page != null) {
                                IEditorPart activeEditor = page.getActiveEditor();
                                if (file2.getFileExtension().equals("logic2semantic")) {
                                    page.openEditor((IEditorInput)new FileEditorInput(file2), "org.eclipse.gmf.examples.runtime.diagram.logic.semantic.presentation.SemanticEditorID", false);
                                }
                                if (activeEditor != null) {
                                    page.activate((IWorkbenchPart)activeEditor);
                                }
                            }
                        }
                        catch (PartInitException e) {
                            LogicsemanticEditorPlugin.getPlugin().log(e.getStatus());
                        }
                    }
                });
            }
        } else if (!notification.getNewBooleanValue() && notification.getOldBooleanValue() && (file = WorkspaceSynchronizer.getFile((Resource)((Resource)notification.getNotifier()))) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = ResourceLoadedListener.this.getActivePage();
                    if (page != null) {
                        IEditorReference[] editors = page.findEditors((IEditorInput)new FileEditorInput(file), "org.eclipse.gmf.examples.runtime.diagram.logic.semantic.presentation.SemanticEditorID", 3);
                        page.closeEditors(editors, false);
                    }
                }
            });
        }
    }

    private IFile getFile(Resource resource, TransactionalEditingDomain domain) {
        IFile result = null;
        URI normalizedURI = domain.getResourceSet().getURIConverter().normalize(resource.getURI());
        if ("file".equals(normalizedURI.scheme())) {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(URI.decode((String)normalizedURI.devicePath())));
            if (files.length > 0) {
                result = files[0];
            }
        } else if ("platform".equals(normalizedURI.scheme()) && normalizedURI.segmentCount() > 2 && "resource".equals(normalizedURI.segment(0))) {
            IPath path = new Path(URI.decode((String)normalizedURI.path())).removeFirstSegments(1);
            result = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return result;
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow window;
        IWorkbenchPage result = null;
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench != null && (window = bench.getActiveWorkbenchWindow()) != null) {
            result = window.getActivePage();
        }
        return result;
    }
}

