/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.mint.internal.ui.actions.OpenForeignModelAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class OpenForeignModelsMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final IContributionItem[] NO_ITEMS = new IContributionItem[0];
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        IMenuService svc = (IMenuService)this.serviceLocator.getService(IMenuService.class);
        IWorkbenchWindow window = (IWorkbenchWindow)svc.getCurrentState().getVariable("activeWorkbenchWindow");
        if (window == null) {
            return NO_ITEMS;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return NO_ITEMS;
        }
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        Object selection = svc.getCurrentState().getVariable("activeMenuSelection");
        if (selection instanceof IStructuredSelection) {
            ArrayList<Object> items = new ArrayList<Object>();
            boolean addSeparator = false;
            for (GenModel genModel : (IStructuredSelection)selection) {
                EList paths = genModel.getForeignModel();
                if (!items.isEmpty()) {
                    addSeparator = true;
                }
                for (String path : paths) {
                    URI uri = URI.createURI((String)path).resolve(genModel.eResource().getURI());
                    if (!uri.isPlatformResource()) continue;
                    if (addSeparator) {
                        items.add(new Separator());
                        addSeparator = false;
                    }
                    IFile file = root.getFile((IPath)new Path(uri.toPlatformString(true)));
                    items.add(new ActionContributionItem((IAction)new OpenForeignModelAction(page, file)));
                }
            }
            return items.toArray(new IContributionItem[items.size()]);
        }
        return NO_ITEMS;
    }
}

