/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.ResourceManagerImpl;
import org.eclipse.emf.cdo.client.protocol.AbstractDataRequest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

public class LoadResourceRequest
extends AbstractDataRequest {
    protected int rid;

    public LoadResourceRequest(int rid) {
        this.rid = rid;
    }

    public short getSignalId() {
        return 5;
    }

    public void request() {
        if (this.isDebugEnabled()) {
            this.debug("Loading rid " + this.rid);
        }
        this.transmitInt(this.rid);
    }

    public Object confirm() {
        long oid;
        EObject firstObject = null;
        while ((oid = this.receiveLong()) != 0L) {
            int oca = this.receiveInt();
            int cid = this.receiveInt();
            ResourceManager resourceManager = this.getResourceManager();
            resourceManager.stopRequestingObjects();
            EObject object = this.receiveObject(oid, oca, cid);
            CDOResource resource = this.getResource(this.rid);
            resource.getContents().add((Object)object);
            resourceManager.startRequestingObjects();
            if (firstObject != null) continue;
            firstObject = object;
        }
        return firstObject;
    }

    protected EObject provideObject(EClass eClass, long oid, int oca) {
        if (this.isDebugEnabled()) {
            this.debug("Providing object " + eClass.getName() + " " + this.getPackageManager().getOidEncoder().toString(oid) + "v" + oca);
        }
        int rid = this.getPackageManager().getOidEncoder().getRID(oid);
        ResourceManager resourceManager = this.getResourceManager();
        CDOResource cdoResource = resourceManager.getResource(rid);
        EObject object = this.getProxyObject(oid);
        if (object == null) {
            object = resourceManager.createEObject(eClass, oid, oca, cdoResource);
            resourceManager.registerObject(oid, object);
        } else {
            ResourceManagerImpl.initPersistable(object, cdoResource, oid, oca);
            ((InternalEObject)object).eSetProxyURI(null);
        }
        return object;
    }

    protected void receiveContainers() {
    }
}

