/*
 * Decompiled with CFR 0.152.
 */
package laxcondition;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Operator implements Enumerator
{
    NOT(0, "NOT", "NOT"),
    AND(1, "AND", "AND"),
    OR(2, "OR", "OR"),
    IMPLIES(3, "IMPLIES", "IMPLIES"),
    EQUIVALENT(4, "EQUIVALENT", "EQUIVALENT"),
    XOR(5, "XOR", "XOR");

    public static final int NOT_VALUE = 0;
    public static final int AND_VALUE = 1;
    public static final int OR_VALUE = 2;
    public static final int IMPLIES_VALUE = 3;
    public static final int EQUIVALENT_VALUE = 4;
    public static final int XOR_VALUE = 5;
    private static final Operator[] VALUES_ARRAY;
    public static final List<Operator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Operator[]{NOT, AND, OR, IMPLIES, EQUIVALENT, XOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Operator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator get(int value) {
        switch (value) {
            case 0: {
                return NOT;
            }
            case 1: {
                return AND;
            }
            case 2: {
                return OR;
            }
            case 3: {
                return IMPLIES;
            }
            case 4: {
                return EQUIVALENT;
            }
            case 5: {
                return XOR;
            }
        }
        return null;
    }

    private Operator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

