/*******************************************************************************
 * Copyright (c) 2011 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.eef.extended.editor.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.eef.extended.editor.EditorFactory;
import org.eclipse.emf.eef.extended.editor.EditorPackage;
import org.eclipse.emf.eef.extended.editor.util.EditorAdapterFactory;
import org.eclipse.emf.eef.mapping.AbstractElementBinding;
import org.eclipse.emf.eef.mapping.AbstractPropertyBinding;
import org.eclipse.emf.eef.mapping.Category;
import org.eclipse.emf.eef.mapping.Databinding;
import org.eclipse.emf.eef.mapping.MappingPackage;
import org.eclipse.emf.eef.mapping.util.MappingSwitch;
import org.eclipse.emf.eef.views.Container;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.emf.eef.views.ViewsRepository;
import org.eclipse.emf.eef.views.util.ViewsSwitch;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class EditorItemProviderAdapterFactory extends EditorAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(ExtendedEditPlugin.INSTANCE, EditorPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EditorItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.StandardFormPage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StandardFormPageItemProvider standardFormPageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.StandardFormPage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStandardFormPageAdapter() {
		if (standardFormPageItemProvider == null) {
			standardFormPageItemProvider = new StandardFormPageItemProvider(this);
		}

		return standardFormPageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.EEFMasterPage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EEFMasterPageItemProvider eefMasterPageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.EEFMasterPage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEEFMasterPageAdapter() {
		if (eefMasterPageItemProvider == null) {
			eefMasterPageItemProvider = new EEFMasterPageItemProvider(this);
		}

		return eefMasterPageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.TreeMasterPage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TreeMasterPageItemProvider treeMasterPageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.TreeMasterPage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTreeMasterPageAdapter() {
		if (treeMasterPageItemProvider == null) {
			treeMasterPageItemProvider = new TreeMasterPageItemProvider(this);
		}

		return treeMasterPageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.AllResourcesRootsRelativeInput} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AllResourcesRootsRelativeInputItemProvider allResourcesRootsRelativeInputItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.AllResourcesRootsRelativeInput}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAllResourcesRootsRelativeInputAdapter() {
		if (allResourcesRootsRelativeInputItemProvider == null) {
			allResourcesRootsRelativeInputItemProvider = new AllResourcesRootsRelativeInputItemProvider(this);
		}

		return allResourcesRootsRelativeInputItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.FirstResourceRootRelativeInput} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FirstResourceRootRelativeInputItemProvider firstResourceRootRelativeInputItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.FirstResourceRootRelativeInput}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFirstResourceRootRelativeInputAdapter() {
		if (firstResourceRootRelativeInputItemProvider == null) {
			firstResourceRootRelativeInputItemProvider = new FirstResourceRootRelativeInputItemProvider(this);
		}

		return firstResourceRootRelativeInputItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.PartFilter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartFilterItemProvider partFilterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.PartFilter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartFilterAdapter() {
		if (partFilterItemProvider == null) {
			partFilterItemProvider = new PartFilterItemProvider(this);
		}

		return partFilterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.EEFEditorContributions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EEFEditorContributionsItemProvider eefEditorContributionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.EEFEditorContributions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEEFEditorContributionsAdapter() {
		if (eefEditorContributionsItemProvider == null) {
			eefEditorContributionsItemProvider = new EEFEditorContributionsItemProvider(this);
		}

		return eefEditorContributionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.EEFEditorPages} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EEFEditorPagesItemProvider eefEditorPagesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.EEFEditorPages}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEEFEditorPagesAdapter() {
		if (eefEditorPagesItemProvider == null) {
			eefEditorPagesItemProvider = new EEFEditorPagesItemProvider(this);
		}

		return eefEditorPagesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.StaticEEFEditorContribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StaticEEFEditorContributionItemProvider staticEEFEditorContributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.StaticEEFEditorContribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStaticEEFEditorContributionAdapter() {
		if (staticEEFEditorContributionItemProvider == null) {
			staticEEFEditorContributionItemProvider = new StaticEEFEditorContributionItemProvider(this);
		}

		return staticEEFEditorContributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.DynamicEEFEditorContribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DynamicEEFEditorContributionItemProvider dynamicEEFEditorContributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.DynamicEEFEditorContribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDynamicEEFEditorContributionAdapter() {
		if (dynamicEEFEditorContributionItemProvider == null) {
			dynamicEEFEditorContributionItemProvider = new DynamicEEFEditorContributionItemProvider(this);
		}

		return dynamicEEFEditorContributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.eef.extended.editor.ReferenceableObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceableObjectItemProvider referenceableObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.eef.extended.editor.ReferenceableObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceableObjectAdapter() {
		if (referenceableObjectItemProvider == null) {
			referenceableObjectItemProvider = new ReferenceableObjectItemProvider(this);
		}

		return referenceableObjectItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (standardFormPageItemProvider != null) standardFormPageItemProvider.dispose();
		if (eefMasterPageItemProvider != null) eefMasterPageItemProvider.dispose();
		if (treeMasterPageItemProvider != null) treeMasterPageItemProvider.dispose();
		if (allResourcesRootsRelativeInputItemProvider != null) allResourcesRootsRelativeInputItemProvider.dispose();
		if (firstResourceRootRelativeInputItemProvider != null) firstResourceRootRelativeInputItemProvider.dispose();
		if (partFilterItemProvider != null) partFilterItemProvider.dispose();
		if (eefEditorContributionsItemProvider != null) eefEditorContributionsItemProvider.dispose();
		if (eefEditorPagesItemProvider != null) eefEditorPagesItemProvider.dispose();
		if (staticEEFEditorContributionItemProvider != null) staticEEFEditorContributionItemProvider.dispose();
		if (dynamicEEFEditorContributionItemProvider != null) dynamicEEFEditorContributionItemProvider.dispose();
		if (referenceableObjectItemProvider != null) referenceableObjectItemProvider.dispose();
	}

	/**
	 * A child creation extender for the {@link MappingPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class MappingChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends MappingSwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseDatabinding(Databinding object) {
				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.DATABINDING__BINDINGS,
						 EditorFactory.eINSTANCE.createStaticEEFEditorContribution()));

				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.DATABINDING__BINDINGS,
						 EditorFactory.eINSTANCE.createDynamicEEFEditorContribution()));

				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.DATABINDING__CATEGORIES,
						 EditorFactory.eINSTANCE.createEEFEditorContributions()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseAbstractElementBinding(AbstractElementBinding object) {
				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.ABSTRACT_ELEMENT_BINDING__SUB_ELEMENTS,
						 EditorFactory.eINSTANCE.createStaticEEFEditorContribution()));

				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.ABSTRACT_ELEMENT_BINDING__SUB_ELEMENTS,
						 EditorFactory.eINSTANCE.createDynamicEEFEditorContribution()));

				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.ABSTRACT_ELEMENT_BINDING__BINDING_FILTERS,
						 EditorFactory.eINSTANCE.createPartFilter()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseAbstractPropertyBinding(AbstractPropertyBinding object) {
				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.ABSTRACT_PROPERTY_BINDING__BINDING_FILTERS,
						 EditorFactory.eINSTANCE.createPartFilter()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseCategory(Category object) {
				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.CATEGORY__BINDINGS,
						 EditorFactory.eINSTANCE.createStaticEEFEditorContribution()));

				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.CATEGORY__BINDINGS,
						 EditorFactory.eINSTANCE.createDynamicEEFEditorContribution()));

				newChildDescriptors.add
					(createChildParameter
						(MappingPackage.Literals.CATEGORY__CATEGORIES,
						 EditorFactory.eINSTANCE.createEEFEditorContributions()));

				return null;
			}
 
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
		   new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
		   return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return ExtendedEditPlugin.INSTANCE;
		}
	}

	/**
	 * A child creation extender for the {@link ViewsPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class ViewsChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		protected static class CreationSwitch extends ViewsSwitch<Object> {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseViewsRepository(ViewsRepository object) {
				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.VIEWS_REPOSITORY__VIEWS,
						 EditorFactory.eINSTANCE.createStandardFormPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.VIEWS_REPOSITORY__VIEWS,
						 EditorFactory.eINSTANCE.createEEFMasterPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.VIEWS_REPOSITORY__VIEWS,
						 EditorFactory.eINSTANCE.createTreeMasterPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.VIEWS_REPOSITORY__CATEGORIES,
						 EditorFactory.eINSTANCE.createEEFEditorPages()));

				return null;
			}
  
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseCategory(org.eclipse.emf.eef.views.Category object) {
				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.CATEGORY__VIEWS,
						 EditorFactory.eINSTANCE.createStandardFormPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.CATEGORY__VIEWS,
						 EditorFactory.eINSTANCE.createEEFMasterPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.CATEGORY__VIEWS,
						 EditorFactory.eINSTANCE.createTreeMasterPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.CATEGORY__CATEGORIES,
						 EditorFactory.eINSTANCE.createEEFEditorPages()));

				return null;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseContainer(Container object) {
				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.CONTAINER__ELEMENTS,
						 EditorFactory.eINSTANCE.createStandardFormPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.CONTAINER__ELEMENTS,
						 EditorFactory.eINSTANCE.createEEFMasterPage()));

				newChildDescriptors.add
					(createChildParameter
						(ViewsPackage.Literals.CONTAINER__ELEMENTS,
						 EditorFactory.eINSTANCE.createTreeMasterPage()));

				return null;
			}
			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
		   new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
		   return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		public ResourceLocator getResourceLocator() {
			return ExtendedEditPlugin.INSTANCE;
		}
	}

}
