/*
 * Decompiled with CFR 0.152.
 */
package ordersystem.impl;

import java.util.Date;
import ordersystem.Account;
import ordersystem.Address;
import ordersystem.Customer;
import ordersystem.InventoryItem;
import ordersystem.LineItem;
import ordersystem.Order;
import ordersystem.OrderSystem;
import ordersystem.OrderSystemFactory;
import ordersystem.OrderSystemPackage;
import ordersystem.Product;
import ordersystem.Warehouse;
import ordersystem.impl.AccountImpl;
import ordersystem.impl.AddressImpl;
import ordersystem.impl.CustomerImpl;
import ordersystem.impl.InventoryItemImpl;
import ordersystem.impl.LineItemImpl;
import ordersystem.impl.OrderImpl;
import ordersystem.impl.OrderSystemImpl;
import ordersystem.impl.ProductImpl;
import ordersystem.impl.WarehouseImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class OrderSystemFactoryImpl
extends EFactoryImpl
implements OrderSystemFactory {
    public static OrderSystemFactory init() {
        try {
            OrderSystemFactory theOrderSystemFactory = (OrderSystemFactory)EPackage.Registry.INSTANCE.getEFactory("http:///ordersystem.ecore");
            if (theOrderSystemFactory != null) {
                return theOrderSystemFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new OrderSystemFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createOrder();
            }
            case 1: {
                return this.createProduct();
            }
            case 2: {
                return this.createWarehouse();
            }
            case 3: {
                return this.createOrderSystem();
            }
            case 4: {
                return this.createLineItem();
            }
            case 5: {
                return this.createInventoryItem();
            }
            case 6: {
                return this.createCustomer();
            }
            case 7: {
                return this.createAddress();
            }
            case 8: {
                return this.createAccount();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.createJavaDateFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.convertJavaDateToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public OrderSystem createOrderSystem() {
        OrderSystemImpl orderSystem = new OrderSystemImpl();
        return orderSystem;
    }

    public Customer createCustomer() {
        CustomerImpl customer = new CustomerImpl();
        return customer;
    }

    public Account createAccount() {
        AccountImpl account = new AccountImpl();
        return account;
    }

    public Address createAddress() {
        AddressImpl address = new AddressImpl();
        return address;
    }

    public Order createOrder() {
        OrderImpl order = new OrderImpl();
        return order;
    }

    public LineItem createLineItem() {
        LineItemImpl lineItem = new LineItemImpl();
        return lineItem;
    }

    public Product createProduct() {
        ProductImpl product = new ProductImpl();
        return product;
    }

    public Warehouse createWarehouse() {
        WarehouseImpl warehouse = new WarehouseImpl();
        return warehouse;
    }

    public InventoryItem createInventoryItem() {
        InventoryItemImpl inventoryItem = new InventoryItemImpl();
        return inventoryItem;
    }

    public Date createJavaDateFromString(EDataType eDataType, String initialValue) {
        if (initialValue != null && !initialValue.equals("")) {
            return new Date(Long.parseLong(initialValue));
        }
        return null;
    }

    public String convertJavaDateToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue != null) {
            return String.valueOf(((Date)instanceValue).getTime());
        }
        return null;
    }

    public OrderSystemPackage getOrderSystemPackage() {
        return (OrderSystemPackage)this.getEPackage();
    }

    @Deprecated
    public static OrderSystemPackage getPackage() {
        return OrderSystemPackage.eINSTANCE;
    }
}

