/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration;

import com.google.common.base.Function;
import java.lang.reflect.Field;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.uml2.papyrus.internal.UMLPapyrusCompareMessages;
import org.eclipse.emf.compare.uml2.papyrus.internal.UMLPapyrusComparePlugin;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.MissingProfileSupplier;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.ModelSetWrapper;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.ProfileMigrationDiagnostic;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.UMLLabelProviderService;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.StereotypeApplicationRepairSnippet;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class StereotypeApplicationRepair
extends StereotypeApplicationRepairSnippet {
    private Resource resource;

    public StereotypeApplicationRepair(Resource resource) {
        this.resource = resource;
        this.setLabelProviderService(this.createLabelProviderService());
        this.setProfileSupplier(this.createProfileSupplier());
    }

    public void dispose(ModelSet modelsManager) {
        try {
            LabelProviderService s = (LabelProviderService)this.getSuperField("labelProviderService");
            if (s != null) {
                s.disposeService();
            }
        }
        catch (ServiceException ex) {
            UMLPapyrusComparePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.uml2.papyrus", "Unable to dispose Label Provider Service", (Throwable)ex));
        }
        super.dispose(modelsManager);
    }

    protected void setSuperField(String fieldName, Object fieldValue) {
        try {
            Field superField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            superField.setAccessible(true);
            superField.set((Object)this, fieldValue);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected Object getSuperField(String fieldName) {
        try {
            Field superField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            superField.setAccessible(true);
            return superField.get((Object)this);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setAdapter(ModelSet resourceSet) {
        Object adapterObject = this.getSuperField("adapter");
        if (adapterObject instanceof Adapter.Internal) {
            ((Adapter.Internal)adapterObject).setTarget((Notifier)resourceSet);
        }
    }

    private void setLabelProviderService(LabelProviderService labelProviderService) {
        this.setSuperField("labelProviderService", labelProviderService);
    }

    protected void setProfileSupplier(Function<EPackage, Profile> profileSupplier) {
        this.setSuperField("dynamicProfileSupplier", profileSupplier);
    }

    protected LabelProviderService createLabelProviderService() {
        UMLLabelProviderService umlLabelProviderService = new UMLLabelProviderService();
        try {
            umlLabelProviderService.startService();
        }
        catch (ServiceException ex) {
            UMLPapyrusComparePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.uml2.papyrus", "Unable to start UML Label Provider Service", (Throwable)ex));
        }
        return umlLabelProviderService;
    }

    protected Function<EPackage, Profile> createProfileSupplier() {
        return new MissingProfileSupplier(StereotypeApplicationRepair.getRootElement(this.resource));
    }

    public Resource getResource() {
        return this.resource;
    }

    protected ModelSet createModelSetWrapper(ResourceSet resourceSet) {
        ModelSetWrapper modelSet = new ModelSetWrapper(resourceSet);
        modelSet.setReadOnly(this.resource, Boolean.FALSE);
        return modelSet;
    }

    public ZombieStereotypesDescriptor repair() {
        try {
            ResourceSet resourceSet = this.resource.getResourceSet();
            ModelSet modelSet = this.createModelSetWrapper(resourceSet);
            this.setAdapter(modelSet);
            modelSet.getResources().add((Object)this.resource);
            ZombieStereotypesDescriptor stereotypesDescriptor = this.getZombieStereotypes(this.resource);
            resourceSet.getResources().add((Object)this.resource);
            return stereotypesDescriptor;
        }
        catch (Exception e) {
            this.resource.getErrors().add((Object)new ProfileMigrationDiagnostic(UMLPapyrusCompareMessages.getString("profile.migration.exception", e, this.resource)));
            UMLPapyrusComparePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.uml2.papyrus", "Exception occurred during profile migration", (Throwable)e));
            return null;
        }
    }

    protected static Element getRootElement(Resource resource) {
        return (Element)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
    }
}

