/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.configuration.ui;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.IConfigurationUIFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUIRegistryEventListener
extends AbstractRegistryEventListener {
    private static final String ELEMENT_TAG = "configurator";
    private static final String ITEM_TO_CONFIGURE_ATTR = "itemToConfigure";
    private static final String UI_PROVIDER_ATTR = "uiProvider";
    private final Map<String, IConfigurationUIFactory> registry;
    private final IItemRegistry<?> registryOfConfiguredItem;

    public ConfigurationUIRegistryEventListener(String namespace, String extensionPointID, ILog log, Map<String, IConfigurationUIFactory> registry, IItemRegistry<?> registryOfConfiguredItem) {
        super(namespace, extensionPointID, log);
        this.registry = registry;
        this.registryOfConfiguredItem = registryOfConfiguredItem;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean ret;
        if (ELEMENT_TAG.equals(element.getName())) {
            if (element.getAttribute(ITEM_TO_CONFIGURE_ATTR) == null) {
                this.logMissingAttribute(element, ITEM_TO_CONFIGURE_ATTR);
                ret = false;
            } else if (element.getAttribute(ITEM_TO_CONFIGURE_ATTR) != null) {
                IItemDescriptor itemToConfigure = this.registryOfConfiguredItem.getItemDescriptor(element.getAttribute(ITEM_TO_CONFIGURE_ATTR));
                if (itemToConfigure == null) {
                    this.log(2, element, EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.INCORRECT_ID_PARAMETER"));
                    ret = false;
                } else {
                    ret = true;
                }
            } else if (element.getAttribute(UI_PROVIDER_ATTR) == null) {
                this.logMissingAttribute(element, UI_PROVIDER_ATTR);
                ret = false;
            } else {
                ret = true;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    protected boolean addedValid(IConfigurationElement element) {
        try {
            Object configurator = element.createExecutableExtension(UI_PROVIDER_ATTR);
            if (configurator instanceof IConfigurationUIFactory) {
                IConfigurationUIFactory configurationFactory = (IConfigurationUIFactory)configurator;
                String itemToConfigureID = element.getAttribute(ITEM_TO_CONFIGURE_ATTR);
                IConfigurationUIFactory previous = this.registry.put(itemToConfigureID, configurationFactory);
                if (previous != null) {
                    this.log(2, element, EMFCompareRCPUIMessages.getString("duplicate.extension", this.registry.getClass().getName()));
                }
            } else {
                this.log(2, element, EMFCompareRCPUIMessages.getString("EnginesPreferencePagestatic.INCORRECT_CONFIGURATOR_PARAMETER"));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.log(element, e);
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        return this.registry.remove(element.getAttribute(ITEM_TO_CONFIGURE_ATTR)) != null;
    }
}

