/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.provider.TreeNodeItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeItemProviderSpec
extends TreeNodeItemProvider
implements IItemStyledLabelProvider,
IItemColorProvider {
    private final Map<IDifferenceGroup, GroupItemProviderAdapter> fGroupAdapters = Maps.newHashMap();

    public TreeNodeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getParent(Object object) {
        TreeNode parent = null;
        TreeNode treeNode = (TreeNode)object;
        TreeNode superParent = (TreeNode)super.getParent(object);
        if (superParent != null && superParent.getData() instanceof Comparison) {
            EObject parentData = superParent.getData();
            GroupItemProviderAdapter comparisonGroupItemProvider = (GroupItemProviderAdapter)this.adapterFactory.adapt((Notifier)parentData, IEditingDomainItemProvider.class);
            Collection<?> children = comparisonGroupItemProvider.getChildren(parentData);
            if (children.size() > 1) {
                for (Notifier child : Iterables.filter(children, Notifier.class)) {
                    IDifferenceGroup group;
                    IDifferenceGroup parentGroup = (IDifferenceGroup)EcoreUtil.getAdapter((List)child.eAdapters(), IDifferenceGroup.class);
                    if (parentGroup != (group = (IDifferenceGroup)EcoreUtil.getAdapter((List)treeNode.getData().eAdapters(), IDifferenceGroup.class))) continue;
                    parent = child;
                }
            } else {
                parent = superParent;
            }
        }
        return parent;
    }

    public Collection<?> getChildren(Object object) {
        TreeNode treeNode = (TreeNode)object;
        EObject data = treeNode.getData();
        if (data instanceof Comparison) {
            Comparison comparison;
            IDifferenceGroupProvider groupProvider = (IDifferenceGroupProvider)EcoreUtil.getAdapter((List)treeNode.eAdapters(), IDifferenceGroupProvider.class);
            Collection<? extends IDifferenceGroup> groups = groupProvider.getGroups(comparison = (Comparison)data);
            if (groups.size() > 1) {
                ArrayList children = Lists.newArrayList();
                for (IDifferenceGroup iDifferenceGroup : groups) {
                    if (!this.fGroupAdapters.containsKey(iDifferenceGroup)) {
                        this.fGroupAdapters.put(iDifferenceGroup, new GroupItemProviderAdapter(this.adapterFactory, comparison, iDifferenceGroup));
                    }
                    children.add(this.fGroupAdapters.get(iDifferenceGroup));
                }
                return children;
            }
            return groups.iterator().next().getGroupTree();
        }
        return super.getChildren(object);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        TreeNode treeNode = (TreeNode)object;
        EObject data = treeNode.getData();
        return (IStyledString.IComposedStyledString)AdapterFactoryUtil.getStyledText((AdapterFactory)this.getRootAdapterFactory(), (Object)data);
    }

    public Object getBackground(Object object) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getBackground((Object)treeNode.getData());
    }

    public Object getForeground(Object object) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getForeground((Object)treeNode.getData());
    }

    public Object getBackground(Object object, int columnIndex) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getBackground((Object)treeNode.getData(), columnIndex);
    }

    public Object getForeground(Object object, int columnIndex) {
        TreeNode treeNode = (TreeNode)object;
        return this.itemDelegator.getForeground((Object)treeNode.getData(), columnIndex);
    }
}

