/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;

public class TreeColumnViewerFilter
extends ViewerFilter {
    private String matchingText = "";
    private final TreeViewer treeViewer;
    private final ISTDataViewersField field;
    private final boolean keepAllChildIfParentMatch;

    public TreeColumnViewerFilter(TreeViewer viewer, ISTDataViewersField field, boolean keepAllChildIfParentMatch) {
        this.treeViewer = viewer;
        this.field = field;
        this.keepAllChildIfParentMatch = keepAllChildIfParentMatch;
    }

    public void setMatchingText(String matchingText) {
        this.matchingText = matchingText;
        this.treeViewer.refresh();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ITreeContentProvider provider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        String s = this.field.getValue(element);
        if (s.contains(this.matchingText)) {
            return true;
        }
        if (provider.hasChildren(element)) {
            for (Object o : provider.getChildren(element)) {
                if (!this.select(viewer, element, o)) continue;
                return true;
            }
        }
        if (this.keepAllChildIfParentMatch) {
            while (parentElement != null) {
                String ps = this.field.getValue(parentElement);
                if (ps.contains(this.matchingText)) {
                    return true;
                }
                parentElement = provider.getParent(parentElement);
            }
        }
        return false;
    }
}

