/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.registry;

import io.smallrye.health.AsyncHealthCheckFactory;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.health.api.HealthRegistry;
import io.smallrye.mutiny.Uni;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public class HealthRegistryImpl
implements HealthRegistry {
    Map<String, HealthCheck> checks = new HashMap<String, HealthCheck>();
    Map<String, AsyncHealthCheck> asyncChecks = new HashMap<String, AsyncHealthCheck>();
    private boolean checksChanged = false;
    AsyncHealthCheckFactory asyncHealthCheckFactory = new AsyncHealthCheckFactory();

    @Override
    public HealthRegistry register(String id, HealthCheck healthCheck) {
        return this.register(id, healthCheck, this.checks);
    }

    @Override
    public HealthRegistry register(String id, AsyncHealthCheck asyncHealthCheck) {
        return this.register(id, asyncHealthCheck, this.asyncChecks);
    }

    private <T> HealthRegistry register(String id, T check, Map<String, T> checks) {
        checks.put(id, check);
        this.checksChanged = true;
        return this;
    }

    @Override
    public HealthRegistry remove(String id) {
        try {
            if (this.checks.remove(id) == null && this.asyncChecks.remove(id) == null) {
                throw new IllegalStateException(String.format("ID '%s' not found", id));
            }
            this.checksChanged = true;
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Collection<Uni<HealthCheckResponse>> getChecks(Map<String, Boolean> healthChecksConfigs) {
        Stream<Uni> enabledChecks = this.checks.entrySet().stream().filter(e -> healthChecksConfigs.getOrDefault(e.getKey(), true)).map(e -> this.asyncHealthCheckFactory.callSync((HealthCheck)e.getValue()));
        Stream<Uni> enabledAsyncChecks = this.asyncChecks.entrySet().stream().filter(e -> healthChecksConfigs.getOrDefault(e.getKey(), true)).map(e -> this.asyncHealthCheckFactory.callAsync((AsyncHealthCheck)e.getValue()));
        return Stream.concat(enabledChecks, enabledAsyncChecks).collect(Collectors.toList());
    }

    public boolean checksChanged() {
        return this.checksChanged;
    }
}

