/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.EventState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.ExecutionStep;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.Future;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.Reference;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.Scenario;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ClockStatus;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventWrapper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.StimuliManagerView;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioTool;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ModelSpecificEvent;

public class ScenarioPlayer
extends ScenarioTool {
    private StimuliManagerView _eventView = (StimuliManagerView)((Object)ViewHelper.retrieveView((String)"org.eclipse.gemoc.gemoc_modeling_workbench.concurrent.ui.views.stimulimanager.StimuliManagerView"));
    private int _playProgressIndex;

    public ScenarioPlayer(ModelSpecificEventContext mseContext) {
        super(mseContext);
    }

    public void load(IPath path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)("file:/" + path));
        this._resource = resourceSet.getResource(uri, true);
        this._scenario = (Scenario)this._resource.getContents().get(0);
        this._fragment = ((Reference)this._scenario.getRefList().get(0)).getFragment();
    }

    public boolean play() throws ScenarioException {
        if (this._fragment != null) {
            EList stepList = this._fragment.getStepList();
            if (this.getPlayProgressIndex() == stepList.size()) {
                throw new ScenarioException("Current play progress index is greater than the scenario size.");
            }
            for (ModelSpecificEventWrapper wrapper : this._mseContext.getMSEs()) {
                EList eventStates = ((ExecutionStep)stepList.get(this.getPlayProgressIndex())).getEventList();
                ModelSpecificEvent mse = wrapper.getMSE();
                int i = 0;
                while (i < eventStates.size()) {
                    if (((EventState)eventStates.get(i)).getMse().getName().equals(mse.getName())) {
                        ClockStatus newState = ((EventState)eventStates.get(i)).getState().equals((Object)Future.TICK) ? ClockStatus.FORCED_SET : ClockStatus.FORCED_NOTSET;
                        this._mseContext.forceClock(wrapper, newState);
                    }
                    ++i;
                }
            }
            this.increasePlayProgressIndex();
            this._eventView.updateView();
            return this.getPlayProgressIndex() != stepList.size();
        }
        throw new ScenarioException("The scenario loaded is null or isn't an instance of Scenario");
    }

    public void stop() {
        this.resetPlayProgressIndex();
        this._fragment = null;
        this._mseContext.freeAllClocks();
        this._mseContext.getEngine().recomputePossibleLogicalSteps();
    }

    private int getPlayProgressIndex() {
        return this._playProgressIndex;
    }

    private void increasePlayProgressIndex() {
        ++this._playProgressIndex;
    }

    private void resetPlayProgressIndex() {
        this._playProgressIndex = 0;
    }
}

